/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.serversettings.IgnoreKeyListenerTextField;
import com.aem.shelp.util.swing.ExampleLabel;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AdminPorts
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    IgnoreKeyListenerTextField portField;
    IgnoreKeyListenerTextField ipPortsField;
    JRadioButton portsOnly;
    JRadioButton ipPortCombos;
    JButton portsApply;
    JButton ipApply;
    JWrapLabel ipWarningLabel;
    private ValidationKeyListener validationListener;

    @Override
    protected void initUI() {
        this.validationListener = new ValidationKeyListener(this);
        this.portsApply = new JButton(Language.get("APPLY"));
        this.ipApply = new JButton(Language.get("APPLY"));
        ActionListener save = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminPorts.this.saveListener.requestImmediateSave();
            }
        };
        this.portsApply.addActionListener(save);
        this.ipApply.addActionListener(save);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.get("ADMIN_SERVER_DESC") + "</html>");
        JLabel portLabel = new JLabel(Language.get("ADMIN_CUSTOM_PORT"));
        JLabel ipLabel = new JLabel(Language.get("ADMIN_CUSTOM_IP"));
        this.portsOnly = new JRadioButton(Language.get("SPECIFY_PORTS_ONLY"));
        this.ipPortCombos = new JRadioButton(Language.get("SPECIFY_PORTS_AND_IPS"));
        this.portField = new IgnoreKeyListenerTextField();
        this.portField.setDocument(new DigitDocument(true));
        this.ipPortsField = new IgnoreKeyListenerTextField();
        this.ipWarningLabel = new JWrapLabel();
        JLabel optionalLabel = new JLabel("");
        this.ipWarningLabel.setVerticalTextPosition(1);
        this.ipWarningLabel.setIconTextGap(8);
        this.showIPWarning(false);
        SwingUtil.setWidth(this.ipPortsField, 300);
        SwingUtil.setWidth(this.portField, 100);
        this.ipPortsField.addKeyListener(this.validationListener);
        this.portField.addKeyListener(this.validationListener);
        int YY = 0;
        GridBagLayout gbl2 = new GridBagLayout();
        this.rootComponent.setLayout(gbl2);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.portsOnly);
        bg.add(this.ipPortCombos);
        SwingUtil.setHeight(this.ipApply, this.ipPortsField.getHeight());
        SwingUtil.setHeight(this.portsApply, this.portField.getHeight());
        SHButtonUI.makeButtonSegmentedRight(this.ipApply);
        SHButtonUI.makeButtonSegmentedRight(this.portsApply);
        ExampleLabel portsExampleLabel = new ExampleLabel(Language.get("EXAMPLE") + ": 80, 443");
        ExampleLabel ipPortExampleLabel = new ExampleLabel(Language.get("EXAMPLE") + ": 2.2.2.2:80, 4.4.4.4:443");
        GbPanel portsPanel = new GbPanel();
        portsPanel.add(this.portField, 0, 0, 1, 1, 0, 1, 17, 2);
        portsPanel.add(this.portsApply, 1, 0, 1, 1, 0, 1, 17, 0, new Insets(0, 0, 0, 0));
        portsPanel.add(portsExampleLabel, 2, 0, 1, 1, 1, 1, 17, 2, new Insets(0, 10, 0, 0));
        GbPanel ipPortsPanel = new GbPanel();
        ipPortsPanel.add(this.ipPortsField, 0, 0, 1, 1, 0, 1, 17, 2);
        ipPortsPanel.add(this.ipApply, 1, 0, 1, 1, 0, 1, 17, 0, new Insets(0, 0, 0, 0));
        ipPortsPanel.add(ipPortExampleLabel, 2, 0, 1, 1, 1, 1, 17, 2, new Insets(0, 10, 0, 0));
        ipPortsPanel.add(this.ipWarningLabel, 0, 1, 3, 1, 1, 1, 17, 2, new Insets(5, 0, 0, 0));
        this.portsOnly.addActionListener(new PortOrIpsListener());
        this.ipPortCombos.addActionListener(new PortOrIpsListener());
        gbl2.setConstraints(descriptionLabel, new GridBagConstraints(0, YY++, 3, 1, 1.0, 100.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        gbl2.setConstraints(this.portsOnly, new GridBagConstraints(0, YY++, 3, 1, 1.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        gbl2.setConstraints(portsPanel, new GridBagConstraints(0, YY++, 1, 1, 100.0, 1.0, 17, 2, new Insets(2, 25, 0, 0), 100, 0));
        gbl2.setConstraints(this.ipPortCombos, new GridBagConstraints(0, YY++, 3, 1, 1.0, 100.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        gbl2.setConstraints(ipPortsPanel, new GridBagConstraints(0, YY++, 1, 1, 100.0, 1.0, 17, 2, new Insets(2, 25, 5, 0), 100, 0));
        this.rootComponent.add(this.portsOnly);
        this.rootComponent.add(this.ipPortCombos);
        this.rootComponent.add(ipPortsPanel);
        this.rootComponent.add(portsPanel);
    }

    @Override
    public ArrayList<JComponent> checkAndMarkValid() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (this.ipPortCombos.isSelected()) {
            this.showIPWarning(true);
        } else {
            this.showIPWarning(false);
        }
        if (this.portsOnly.isSelected() && (this.portField.getText().length() == 0 || !AdminPorts.isValidPortField(this.portField.getText(), true))) {
            list.add(this.portField);
        } else {
            this.portField.setBorder(this.defaultTextFieldBorder);
        }
        if (this.ipPortCombos.isSelected() && !this.isValidIpPortsField(this.ipPortsField.getText())) {
            list.add(this.ipPortsField);
        } else {
            this.ipPortsField.setBorder(this.defaultTextFieldBorder);
        }
        return list;
    }

    private void showIPWarning(boolean showit) {
        if (showit) {
            this.ipWarningLabel.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
            this.ipWarningLabel.setText("<HTML>" + Language.get("SPECIFY_PORTS_AND_IPS_WARNING") + "</HTML>");
        } else {
            this.ipWarningLabel.setIcon(null);
            this.ipWarningLabel.setText(" ");
        }
        this.ipWarningLabel.setVisible(showit);
    }

    private boolean isValidIpPortsField(String ipText) {
        if (ipText.trim().length() == 0) {
            return false;
        }
        char[] ips = ipText.toCharArray();
        for (int i = 0; i < ips.length; ++i) {
            if (Character.isDigit(ips[i]) || ips[i] == '.' || ips[i] == ':' || ips[i] == ',') continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_SERVER_CONFIG");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        StringBuffer buffer = new StringBuffer();
        if (config.portList != null) {
            for (int i = 0; i < config.portList.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(config.portList[i]);
            }
        }
        this.portField.setText(buffer.toString());
        StringBuffer ipbuf = new StringBuffer();
        if (config.ipPortPairsList != null) {
            for (int i = 0; i < config.ipPortPairsList.length; ++i) {
                if (i > 0) {
                    ipbuf.append(",");
                }
                ipbuf.append(config.ipPortPairsList[i]);
            }
        }
        this.ipPortsField.setText(ipbuf.toString());
        if (this.ipPortsField.getText().length() > 0) {
            this.portsOnly.setSelected(false);
            this.ipPortCombos.setSelected(true);
        } else {
            this.ipPortCombos.setSelected(false);
            this.portsOnly.setSelected(true);
        }
        this.updatePortOrIpsEnabled();
    }

    private void updatePortOrIpsEnabled() {
        this.portField.setEnabled(this.portsOnly.isSelected());
        this.ipPortsField.setEnabled(this.ipPortCombos.isSelected());
        this.portsApply.setEnabled(this.portsOnly.isSelected());
        this.ipApply.setEnabled(this.ipPortCombos.isSelected());
    }

    @Override
    public void saveTo(ServerConfig config) {
        String[] parsedPorts;
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (String parsedPort : parsedPorts = this.portField.getText().split(",")) {
            try {
                ports.add(Integer.parseInt(parsedPort));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        config.portList = new int[ports.size()];
        for (int i = 0; i < ports.size(); ++i) {
            config.portList[i] = (Integer)ports.get(i);
        }
        if (this.ipPortCombos.isSelected()) {
            String[] allips = this.ipPortsField.getText().split(",");
            config.ipPortPairsList = allips;
            if (allips.length == 1 && allips[0].trim().length() == 0) {
                config.ipPortPairsList = null;
            }
        } else {
            config.ipPortPairsList = null;
        }
        config.recreateIpAndPortLists();
    }

    @Override
    public void checkEnabled() {
    }

    private class PortOrIpsListener
    implements ActionListener {
        private PortOrIpsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminPorts.this.updatePortOrIpsEnabled();
            AdminPorts.this.contentChanged(AdminPorts.this.checkIfValid());
        }
    }
}

