/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.util.swing.ExampleLabel;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTextField;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.layout.GbPanelWrapper;

public class AdminHostname
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    private JTextField hostnameField;
    private ValidationKeyListener validationListener;

    @Override
    public ArrayList<JComponent> checkAndMarkValid() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (this.hostnameField.getText().length() == 0 || !this.isValidHostname(this.hostnameField.getText())) {
            list.add(this.hostnameField);
        } else {
            this.hostnameField.setBorder(this.defaultTextFieldBorder);
        }
        return list;
    }

    private boolean isValidHostname(String text) {
        return text.indexOf(32) == -1;
    }

    @Override
    protected void initUI() {
        this.validationListener = new ValidationKeyListener(this);
        GbPanelWrapper wrapper = new GbPanelWrapper(this.rootComponent);
        JWrapLabel wrapLabel = new JWrapLabel(Language.get("SERVER_HOSTNAME_DESC"));
        this.hostnameField = new JTextField();
        SwingUtil.setWidth(this.hostnameField, 300);
        this.hostnameField.addKeyListener(this.validationListener);
        ExampleLabel exampleLabel = new ExampleLabel(Language.get("EXAMPLE") + ": support.yourcompany.com, www.yourserver.com:443");
        wrapper.add(wrapLabel, 0, 0, 2, 1, 1, 0, 17, 2, new Insets(0, 0, 5, 0));
        wrapper.add(this.hostnameField, 0, 1, 1, 1, 0, 1, 17, 2);
        wrapper.add(exampleLabel, 1, 1, 1, 1, 1, 1, 17, 2, new Insets(0, 10, 0, 0));
    }

    @Override
    public String getTitle() {
        return Language.get("SERVER_HOSTNAME_TITLE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.hostnameField.setText(config.hostname);
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.hostname = this.hostnameField.getText().trim();
    }

    @Override
    public void checkEnabled() {
    }
}

