/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.gettingstarted;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.License;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.util.PleaseWaitDialog;
import com.aem.utils.StreamUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.progtools.date.DateUtil;
import utils.site.transact.TrialUtil;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.LinePanel;

public class AdminLicense
extends SubSection
implements ActionListener {
    public static AdminLicense INSTANCE = null;
    private License license = new License();
    private JButton addLicenseButton;
    private JButton updateButton;
    private JButton upgradeButton;
    private JButton purchaseButton;
    private RoundBorderPanel licensesPanel;
    private JLabel licenseSummaryLabel1;
    private JLabel licenseSummaryLabel2;
    private LinePanel trialPanel;
    private PleaseWaitDialog pleaseWaitDialog;
    int currentIndex = 0;
    private TechClient client;
    private JPanel cardsPanel;

    public AdminLicense() {
        INSTANCE = this;
    }

    public void setLicense(License license) {
        this.license = license;
        this.updateLicenseUI();
    }

    @Override
    protected void initUI() {
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagLayout masterLayout = new GridBagLayout();
        this.rootComponent.setLayout(masterLayout);
        this.licenseSummaryLabel1 = new JWrapLabel();
        this.licenseSummaryLabel1.setHorizontalAlignment(0);
        this.licenseSummaryLabel2 = new JWrapLabel();
        this.licenseSummaryLabel2.setHorizontalAlignment(0);
        this.trialPanel = new LinePanel(0, true, false);
        this.trialPanel.setOpaque(false);
        this.licensesPanel = new RoundBorderPanel(Language.get("ADMIN_LICENSE_TITLE"));
        GridBagLayout licenseLayout = new GridBagLayout();
        this.licensesPanel.setLayout(licenseLayout);
        this.cardsPanel = new JPanel(new GridLayout(1, 1));
        this.cardsPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        licenseLayout.setConstraints(this.cardsPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        licenseLayout.setConstraints(this.licenseSummaryLabel1, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 0), 0, 0));
        licenseLayout.setConstraints(this.licenseSummaryLabel2, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 0), 0, 0));
        licenseLayout.setConstraints(this.trialPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 0), 0, 0));
        this.licensesPanel.add(this.cardsPanel);
        this.licensesPanel.add(this.licenseSummaryLabel1);
        this.licensesPanel.add(this.licenseSummaryLabel2);
        this.licensesPanel.add(this.trialPanel);
        this.addLicenseButton = new JButton(Language.get("LIC_INSTALL"), ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
        this.updateButton = new JButton(Language.get("RENEW_SUPPORT"), ImageLoader.getImageIcon("images/svg/commerce/basket-add.svg,16"));
        this.updateButton.setVisible(false);
        this.upgradeButton = new JButton(Language.get("INCREASE_SESSION_COUNT"), ImageLoader.getImageIcon("images/svg/commerce/basket-add.svg,16"));
        this.upgradeButton.setVisible(false);
        this.purchaseButton = new JButton(Language.get("PURCHASE_LICENSE"), ImageLoader.getImageIcon("images/svg/commerce/basket-add.svg,16"));
        this.purchaseButton.setVisible(false);
        SwingUtil.setSizesToWidest(new JComponent[]{this.purchaseButton, this.upgradeButton, this.updateButton, this.addLicenseButton});
        JPanel paddy = new JPanel();
        int YY = 0;
        masterLayout.setConstraints(this.licensesPanel, new GridBagConstraints(0, YY++, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        masterLayout.setConstraints(this.addLicenseButton, new GridBagConstraints(0, YY++, 2, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        masterLayout.setConstraints(this.updateButton, new GridBagConstraints(0, YY++, 2, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        masterLayout.setConstraints(this.upgradeButton, new GridBagConstraints(0, YY++, 2, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        masterLayout.setConstraints(this.purchaseButton, new GridBagConstraints(0, YY++, 2, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        masterLayout.setConstraints(paddy, new GridBagConstraints(0, YY++, 2, 1, 1.0, 1000.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.rootComponent.add(this.licensesPanel);
        this.rootComponent.add(this.addLicenseButton);
        this.rootComponent.add(this.updateButton);
        this.rootComponent.add(this.upgradeButton);
        this.rootComponent.add(this.purchaseButton);
        this.addLicenseButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.upgradeButton.addActionListener(this);
        this.purchaseButton.addActionListener(this);
    }

    private void addLicenseLine(int Y, GbPanel parent, String title, String value) {
        JLabel titleLabel = new JLabel(title + "  ");
        titleLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        JLabel valueLabel = new JLabel("  " + value);
        titleLabel.setHorizontalAlignment(4);
        int height = titleLabel.getPreferredSize().height;
        int maxWidth = Math.max(titleLabel.getPreferredSize().width, valueLabel.getPreferredSize().width);
        titleLabel.setPreferredSize(new Dimension(maxWidth, height));
        valueLabel.setPreferredSize(new Dimension(maxWidth, height));
        parent.add(titleLabel, 0, Y, 1, 1, 1, 1, 13, 0);
        parent.add(valueLabel, 1, Y, 1, 1, 1, 1, 10, 2);
    }

    public String getAmountOrUnlimited(int amount, int unlimitedAmount) {
        if (amount < unlimitedAmount) {
            return amount + "";
        }
        return Language.get("UNLIMITED");
    }

    public void updateLicenseUI() {
        Date shExpiryDate = null;
        Date sgExpiryDate = null;
        Date shIssueDate = null;
        Date sgIssueDate = null;
        this.cardsPanel.removeAll();
        GbPanel currentLicensePanel = new GbPanel();
        currentLicensePanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        boolean haveLicense = false;
        boolean amBusinessOrEnt = false;
        if (this.license != null) {
            haveLicense = true;
            String product = "SimpleSuite";
            String name = this.license.getName();
            String company = this.license.getCompany();
            String date = this.license.getSupportStartFormattedYMD();
            String expiry = this.license.getExpiryFormattedYMD();
            String commercialUse = this.license.isTrial() ? "false" : "true";
            String sessions = this.license.getSessions() + "";
            String notes = this.license.getNotes();
            String type = "";
            int demoAttendees = this.license.getDemoAttendees();
            int Y = 0;
            if (name != null && name.length() != 0) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_NAME"), name);
            }
            if (company != null && company.length() != 0) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_COMPANY"), company);
            }
            if (sessions != null && sessions.length() != 0) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_SESSIONS"), sessions);
            }
            if (date != null && date.length() != 0) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_DATE"), date);
            }
            if (product != null && product.length() != 0) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PRODUCT"), product);
            }
            if (this.license.isVersion2Enterprise()) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_ENT") + " (P2)");
                amBusinessOrEnt = true;
            } else if (this.license.isVersion2Business()) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_BIZ") + " (P2)");
                amBusinessOrEnt = true;
            } else if (this.license.isVersion2Standard()) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_STD") + " (P2)");
            } else if (this.license.allowsV1Management()) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_MGMT") + " (P1)");
            } else {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_STD") + " (P1)");
            }
            if (type != null && type.length() != 0) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_TYPE"), type);
            }
            if (expiry != null && expiry.length() != 0) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_EXPIRY"), expiry);
            }
            if (commercialUse != null && commercialUse.length() != 0) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_COMMERCIALUSE"), Boolean.parseBoolean(commercialUse) ? Language.get("YES") : Language.get("NO"));
            }
            if (notes != null && notes.length() != 0) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_NOTES"), notes);
            }
            if (demoAttendees >= 1000000) {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_DEMO_ATTENDEES"), Language.get("UNLIMITED"));
            } else {
                this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_DEMO_ATTENDEES"), "" + demoAttendees);
            }
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                Date expiryDate = null;
                if (expiry != null && expiry.length() > 0) {
                    expiryDate = sdf.parse(expiry);
                }
                Date issueDate = sdf.parse(date);
                int sessionsInt = 0;
                try {
                    sessionsInt = Integer.parseInt(sessions);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (product.equals("SimpleSuite")) {
                    if (expiryDate != null) {
                        shExpiryDate = expiryDate;
                        sgExpiryDate = expiryDate;
                    }
                    shIssueDate = issueDate;
                    sgIssueDate = issueDate;
                } else if (product.equals("SimpleHelp")) {
                    if (expiryDate != null) {
                        shExpiryDate = expiryDate;
                    }
                    shIssueDate = issueDate;
                } else if (product.equals("SimpleGateway")) {
                    if (expiryDate != null) {
                        sgExpiryDate = expiryDate;
                    }
                    sgIssueDate = issueDate;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.cardsPanel.add(currentLicensePanel);
        } else {
            JLabel label = new JLabel(Language.get("ADMIN_NO_LICENSE"));
            label.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
            this.cardsPanel.add(label);
            this.currentIndex = 0;
        }
        if (haveLicense) {
            boolean isTrial = this.license.isTrial();
            if (isTrial) {
                StringBuffer trialExpires = new StringBuffer();
                if (shExpiryDate != null) {
                    long days = DateUtil.getDaysBetween(System.currentTimeMillis(), shExpiryDate.getTime());
                    if (days == -1L) {
                        trialExpires.append(Language.get("ADMIN_LICENSE_TRIAL_EXPIRED"));
                    } else {
                        trialExpires.append(Language.get("ADMIN_LICENSE_EXPIRES_IN") + " " + days + " " + Language.get("ADMIN_LICENSE_EXPIRES_DAYS") + ".");
                    }
                }
                this.licenseSummaryLabel1.setForeground(Color.red.darker());
                this.licenseSummaryLabel1.setText("<html>" + trialExpires.toString());
                this.purchaseButton.setVisible(true);
            } else {
                boolean inSupport = !this.license.isOutOfSupport();
                this.purchaseButton.setVisible(false);
                if (inSupport) {
                    Date endOfSupportDate = new Date(this.license.getSupportFinishMs());
                    this.licenseSummaryLabel1.setText(Language.get("LICENSE_SUPPORT_OK"));
                    this.licenseSummaryLabel1.setForeground(Color.green.darker().darker());
                    this.licenseSummaryLabel2.setVisible(true);
                    this.licenseSummaryLabel2.setText(Language.get("LICENSE_MAINTENANCE") + " " + DateFormat.getDateInstance(1).format(endOfSupportDate) + ".");
                    this.updateButton.setVisible(false);
                    this.upgradeButton.setVisible(true);
                } else {
                    this.licenseSummaryLabel1.setText(Language.get("LICENSE_SUPPORT_FINISHED"));
                    this.licenseSummaryLabel1.setForeground(Color.red.darker().darker());
                    this.licenseSummaryLabel2.setVisible(true);
                    this.licenseSummaryLabel2.setText(Language.get("LICENSE_MAINTENANCE_UPDATE"));
                    this.updateButton.setVisible(true);
                    this.upgradeButton.setVisible(true);
                }
            }
        } else {
            this.updateButton.setVisible(false);
            this.upgradeButton.setVisible(false);
            this.purchaseButton.setVisible(true);
        }
        String licenseSource = null;
        try {
            licenseSource = this.client.getLicenseSource();
        }
        catch (Exception inSupport) {
            // empty catch block
        }
        this.trialPanel.removeAll();
        TrialUtil tu = TrialUtils.getTU();
        System.out.println("[Trial] Loading trialled features");
        ArrayList<String> feats = tu.getTrialledFeatures();
        for (String feat : feats) {
            System.out.println("[Trial] Feature: " + feat);
            if (feat.equals(TrialUtil.FEATURE_BIZ) && !amBusinessOrEnt) {
                JPanel tmp = new JPanel();
                tmp.setLayout(new FlowLayout());
                tmp.setOpaque(false);
                String text = Language.get("MANAGEMENT_TRIAL_IN", new Object[]{tu.trialDaysLeft(feat)});
                if (tu.hasTrialEnded(feat)) {
                    text = Language.get("MANAGEMENT_TRIAL_DONE", new Object[]{tu.trialDaysLeft(feat)});
                }
                JLabel desc = new JLabel(text, 0);
                JButton buy = TrialUtils.getUpgradeButton(Language.get("TRIAL_INFO_UPGRADE"), licenseSource);
                tmp.add(desc);
                tmp.add(buy);
                this.trialPanel.add(tmp);
                continue;
            }
            System.out.println("***Unhandled feature in AdminLicense pane: " + feat);
        }
        if (feats.size() > 0) {
            this.trialPanel.setVisible(true);
        } else {
            this.trialPanel.setVisible(false);
        }
        this.setBorderTitle();
    }

    public void save(Object saveToObject) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.addLicenseButton)) {
            File licenseFile = SafeJFileChooser.pickFile(this.rootComponent, new String[]{"txt"});
            if (licenseFile != null) {
                try {
                    FileInputStream fin = new FileInputStream(licenseFile);
                    String licenseData = StreamUtils.readAllAsStringISO88951(fin);
                    fin.close();
                    this.pleaseWaitDialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer(this.rootComponent), Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_SAVING_LICENSE"));
                    new SaveLicenseThread(licenseData).start();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (this.pleaseWaitDialog != null) {
                        this.pleaseWaitDialog.setVisible(false);
                    }
                }
            }
        } else if (e.getSource() == this.purchaseButton) {
            SHWebsiteURLUtil.launchBuyPage();
        } else if (e.getSource() == this.upgradeButton) {
            try {
                String source = this.client.getLicenseSource();
                SHWebsiteURLUtil.launchUpgradeForLicense(source);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else if (e.getSource() == this.updateButton) {
            AdminLicense.showUpdateInBrowser(this.client);
        }
    }

    public static void showUpdateInBrowser(TechClient client) {
        try {
            String source = client.getLicenseSource();
            SHWebsiteURLUtil.launchUpdateForLicense(source);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void setBorderTitle() {
        this.licensesPanel.setBorderText(Language.get("ADMIN_LICENSE_TITLE"));
    }

    @Override
    public void setTechClient(TechClient client) {
        this.client = client;
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_LICENSE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    @Override
    public boolean insertDefaultPadding() {
        return false;
    }

    class SaveLicenseThread
    extends Thread {
        private String data;

        public SaveLicenseThread(String licenseData) {
            this.data = licenseData;
        }

        @Override
        public void run() {
            String error = null;
            try {
                AdminLicense.this.client.putServerLicense(this.data);
                ArrayList<License> licensesReadFromServer = new ArrayList<License>();
                AdminLicense.this.client.fetchServerConfiguration(null, licensesReadFromServer);
                if (licensesReadFromServer.size() == 0) {
                    AdminLicense.this.setLicense(null);
                } else {
                    AdminLicense.this.setLicense(licensesReadFromServer.get(0));
                }
                AdminLicense.this.client.updateServerManagement();
            }
            catch (Exception e) {
                e.printStackTrace();
                error = e.getMessage() != null ? e.getMessage().trim() : "";
                error = error.replace("VALID_LICENSE_EXPIRED", Language.get("VALID_LICENSE_EXPIRED").trim());
            }
            if (AdminLicense.this.pleaseWaitDialog != null) {
                AdminLicense.this.pleaseWaitDialog.setVisible(false);
            }
            if (error != null) {
                String htmlError = Language.get("FAILED_SAVE_LICENSE_MSG") + "\n\n" + error;
                SHGlassOptionPane.showErrorDialog(SwingUtil.getRootPaneContainer(AdminLicense.this.rootComponent), htmlError, Language.get("FAILED_SAVE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            }
        }
    }
}

