/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.dataexport;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.enterprise.PeerServerList;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.gstarted.TrialUtils;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHStyle;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.CardPanel;
import utils.swing.layout.VariableLinePanel;

public class AdminEnterprise
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    CardPanel cardPanel;
    PeerServerList list;
    JTextField idfield;
    int currentLimit;

    @Override
    public boolean grabAllVerticalSpace() {
        return true;
    }

    @Override
    protected void initUI() {
        BorderPanel main = new BorderPanel();
        this.rootComponent.setLayout(new BorderLayout());
        BorderPanel idpanel = new BorderPanel();
        idpanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JLabel title = new JLabel(Language.get("PEER_ID_TITLE"));
        title.setFont(SHStyle.largeFont);
        idpanel.addNorth(title);
        this.idfield = new JTextField(30);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new JLabel(Language.get("PEER_ID_DESC")));
        panel.add(this.idfield);
        idpanel.addCenter(panel);
        main.addNorth(idpanel);
        this.cardPanel = new CardPanel();
        this.list = new PeerServerList(this.cardPanel);
        if (this.techClient != null) {
            this.list.setTechClient(this.techClient);
        }
        main.addCenter(this.list.getRootComponent());
        this.cardPanel.add(main);
        this.rootComponent.add("Center", this.cardPanel);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_NOTIFY_ENTERPRISE_TAB");
    }

    public void licenseChanged() {
        if (AdminPanel.LOADED_LICENSE.isVersion2Enterprise() || TrialUtils.amTriallingEnt()) {
            this.cardPanel.showCard(0);
        } else {
            JPanel flow = new JPanel();
            flow.setLayout(new FlowLayout(1));
            VariableLinePanel lines = new VariableLinePanel(0, true, true);
            flow.add(lines);
            JLabel noent = new JLabel(Language.get("ENTERPRISE_NO"), 0);
            JButton more = new JButton(Language.get("MORE_DETAILS"));
            more.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrialUtils.entUpgradeRequestPopup(SwingUtil.getRootPaneContainer(AdminEnterprise.this.rootComponent), AdminEnterprise.this.rootComponent, AdminEnterprise.this.techClient);
                }
            });
            lines.add(noent);
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            panel.add(more);
            lines.add(panel);
            this.cardPanel.showTemporaryCard(flow);
            this.updateSessionLimit();
        }
    }

    public void updateSessionLimit() {
        if (this.techClient.getSessionLimit() != this.currentLimit) {
            this.currentLimit = this.techClient.getSessionLimit();
            this.list.reloadPeers();
        }
    }

    public void peersChanged() {
        try {
            this.list.reloadPeers();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void loadFrom(ServerConfig config) {
        new EnterpriseLoader().start();
    }

    @Override
    public void saveTo(ServerConfig config) {
        new EnterpriseSaver().start();
    }

    @Override
    public void checkEnabled() {
    }

    @Override
    public void setTechClient(TechClient techClient) {
        super.setTechClient(techClient);
        if (this.list != null) {
            this.list.setTechClient(techClient);
        }
    }

    class EnterpriseSaver
    extends Thread {
        public EnterpriseSaver() {
            super("EnterpriseSaver");
        }

        @Override
        public void run() {
            try {
                AdminEnterprise.this.techClient.saveAllPeerConfigs(AdminEnterprise.this.list.getCurrentPeerConfigs(), true);
                AdminEnterprise.this.techClient.setServerPeerName(AdminEnterprise.this.idfield.getText().trim());
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    class EnterpriseLoader
    extends Thread {
        public EnterpriseLoader() {
            super("EnterpriseLoader");
        }

        @Override
        public void run() {
            try {
                final String peerName = AdminEnterprise.this.techClient.getServerPeerName();
                AdminEnterprise.this.currentLimit = AdminEnterprise.this.techClient.getSessionLimit();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdminEnterprise.this.idfield.setText(peerName);
                        AdminEnterprise.this.list.reloadPeers();
                    }
                });
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

