/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.dataexport;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.enterprise.ClusteringPanel;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.gstarted.TrialUtils;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.CardPanel;
import utils.swing.layout.VariableLinePanel;

public class AdminCluster
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    CardPanel cardPanel;
    ClusteringPanel clusteringPanel;

    @Override
    public boolean grabAllVerticalSpace() {
        return true;
    }

    @Override
    protected void initUI() {
        BorderPanel main = new BorderPanel();
        this.rootComponent.setLayout(new BorderLayout());
        this.cardPanel = new CardPanel();
        this.clusteringPanel = new ClusteringPanel(this.cardPanel);
        if (this.techClient != null) {
            this.clusteringPanel.setTechClient(this.techClient);
        }
        main.addCenter(this.clusteringPanel.getRootComponent());
        this.cardPanel.add(main);
        this.rootComponent.add("Center", this.cardPanel);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_NOTIFY_CLUSTERING_TAB");
    }

    public void licenseChanged() {
        if (AdminPanel.LOADED_LICENSE.isVersion2Enterprise() || TrialUtils.amTriallingEnt()) {
            this.cardPanel.showCard(0);
        } else {
            JPanel flow = new JPanel();
            flow.setLayout(new FlowLayout(1));
            VariableLinePanel lines = new VariableLinePanel(0, true, true);
            flow.add(lines);
            JLabel noent = new JLabel(Language.get("ENTERPRISE_NO"), 0);
            JButton more = new JButton(Language.get("MORE_DETAILS"));
            more.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrialUtils.entUpgradeRequestPopup(SwingUtil.getRootPaneContainer(AdminCluster.this.rootComponent), AdminCluster.this.rootComponent, AdminCluster.this.techClient);
                }
            });
            lines.add(noent);
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            panel.add(more);
            lines.add(panel);
            this.cardPanel.showTemporaryCard(flow);
        }
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    @Override
    public void checkEnabled() {
    }

    @Override
    public void setTechClient(TechClient techClient) {
        super.setTechClient(techClient);
        if (this.clusteringPanel != null) {
            this.clusteringPanel.setTechClient(techClient);
        }
    }
}

