/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.customlaf.SHStyle;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class AdminBackup
extends SubSection {
    public static AdminBackup INSTANCE = null;
    private JButton debug_restartButton;
    private JButton backupButton;
    private JLabel backupTitle;
    private JWrapLabel backupDesc;
    private JLabel backupIcon;
    private ArrowedProgressBar bar5;
    private AdminPanel adminPanel;

    public AdminBackup(AdminPanel adminPanel) {
        this.adminPanel = adminPanel;
        INSTANCE = this;
    }

    @Override
    protected void initUI() {
        this.bar5 = new ArrowedProgressBar();
        GbPanelWrapper backupWrapper = new GbPanelWrapper(this.rootComponent, new Insets(3, 3, 3, 3));
        this.backupIcon = new JLabel(ImageLoader.getImageIcon("images/svg/alert-flags/red.svg,32"));
        this.backupTitle = new JLabel(Language.get("ADMIN_BACKUP_TITLE") + " (" + Language.get("ADMIN_BACKUP_NEVER").trim() + ")");
        this.backupDesc = new JWrapLabel("<html>" + Language.get("ADMIN_BACKUP_WARNING1") + " " + Language.get("ADMIN_BACKUP_WARNING2")){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                System.out.println(dim);
                return dim;
            }
        };
        this.backupDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.backupButton = new JButton(Language.get("ADMIN_BACKUP_BACKUP_NOW"));
        if (CentralDebugging.DEBUG_SHOW_RESTART_SERVER_BUTTON) {
            this.debug_restartButton = new JButton("Restart Server");
            this.debug_restartButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AdminBackup.this.techClient.restartServer();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        this.bar5.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        int YY = 0;
        backupWrapper.add(this.bar5.getRootComponent(), 0, YY, 1, 3, 0, 0, 10, 0, new Insets(10, 10, 15, 10));
        backupWrapper.add(this.backupIcon, 1, YY, 1, 3, 0, 0, 17, 0, new Insets(10, 10, 15, 10));
        backupWrapper.add(this.backupTitle, 2, YY++, 2, 1, 1, 0, 17, 0, new Insets(10, 10, 0, 10));
        backupWrapper.add(this.backupDesc, 2, YY++, 2, 1, 1, 1, 17, 1, new Insets(5, 10, 0, 10));
        backupWrapper.add(this.backupButton, 2, YY++, 1, 1, 0, 0, 17, 0, new Insets(10, 10, 3, 10));
        if (this.debug_restartButton != null) {
            backupWrapper.add(this.debug_restartButton, 2, YY++, 1, 1, 0, 0, 17, 0, new Insets(10, 10, 3, 10));
        }
        this.backupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminBackup.this.backupButton.setEnabled(false);
                AdminBackup.this.backupDesc.setText("<html>" + Language.get("ADMIN_BACKUP_BACKING_UP"));
                AdminBackup.this.backupDesc.getParent().repaint();
                try {
                    AdminBackup.this.bar5.on();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                new BackupThread().start();
            }
        });
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_BACKUP_TITLE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    public class CheckBackupThread
    extends Thread {
        @Override
        public void run() {
            try {
                long t = AdminBackup.this.techClient.getLastBackup();
                System.out.println("[AdminBackup] Last backup was on " + new Date(t) + " (" + t + ")");
                DateFormat df = DateFormat.getDateInstance(2);
                if (t == -1L) {
                    AdminBackup.this.adminPanel.setLastBackedUp(null);
                    AdminBackup.this.backupIcon.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/red.svg,32"));
                    AdminBackup.this.backupTitle.setText(Language.get("ADMIN_BACKUP_TITLE") + " (" + Language.get("ADMIN_BACKUP_NEVER").trim() + ")");
                    AdminBackup.this.backupDesc.setText("<html>" + Language.get("ADMIN_BACKUP_WARNING1") + " " + Language.get("ADMIN_BACKUP_WARNING2"));
                } else {
                    AdminBackup.this.adminPanel.setLastBackedUp(df.format(new Date(t)));
                    AdminBackup.this.backupIcon.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/green.svg,32"));
                    AdminBackup.this.backupTitle.setText(Language.get("ADMIN_BACKUP_TITLE") + " (" + Language.get("ADMIN_BACKUP_LAST").trim() + " " + df.format(new Date(t)) + ")");
                    AdminBackup.this.backupDesc.setText("<html>" + Language.get("ADMIN_BACKUP_WARNING1") + " " + Language.get("ADMIN_BACKUP_WARNING2"));
                }
                AdminBackup.this.backupDesc.getParent().repaint();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    class BackupThread
    extends Thread {
        BackupThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File backupFolder = SafeJFileChooser.saveDirectory(AdminBackup.this.rootComponent);
                if (backupFolder == null) {
                    AdminBackup.this.backupDesc.setText(" ");
                    return;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd_HHmmss");
                File backupFile = new File(backupFolder, OemBranding.OEM_APPLICATION_NAME.toLowerCase() + "_backup_" + sdf.format(new Date(System.currentTimeMillis())) + ".zip");
                System.out.println("[AdminPanel Backup] Will save config backup to " + backupFile);
                backupFile.getParentFile().mkdirs();
                AdminBackup.this.techClient.requestConfigBackupZip();
                System.out.println("[AdminPanel Backup] Backup now ready to download");
                boolean write = true;
                if (backupFile.exists()) {
                    write = SHGlassOptionPane.showConfirmDialog(SwingUtil.getRootPaneContainer(AdminBackup.this.rootComponent), Language.get("ADMIN_BACKUP_DIALOG_CONFIRM"), Language.get("SAVE_CHANGES"), null, Language.get("OVERWRITE"));
                }
                if (write) {
                    AdminBackup.this.techClient.saveConfigBackupZipTo(backupFile);
                    System.out.println("[AdminPanel Backup] Wrote backup to file");
                    AdminBackup.this.backupDesc.setText("<html>" + Language.get("ADMIN_BACKUP_COMPLETE") + " (" + backupFile.getName() + ")");
                    AdminBackup.this.backupIcon.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/green.svg,32"));
                    AdminBackup.this.backupTitle.setText(Language.get("ADMIN_BACKUP_TITLE") + " (" + Language.get("ADMIN_BACKUP_LAST").trim() + " " + new Date(System.currentTimeMillis()) + ")");
                    AdminBackup.this.backupDesc.getParent().repaint();
                    if (AdminBackup.this.adminPanel != null) {
                        AdminBackup.this.adminPanel.setLastBackedUp("");
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                AdminBackup.this.backupDesc.setText("<html>" + Language.get("ADMIN_BACKUP_FAILED"));
                AdminBackup.this.backupIcon.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/red.svg,32"));
                AdminBackup.this.backupTitle.setText(Language.get("ADMIN_BACKUP_TITLE") + " (" + Language.get("ADMIN_BACKUP_LAST").trim() + " " + new Date(System.currentTimeMillis()) + ")");
                AdminBackup.this.backupDesc.getParent().repaint();
            }
            finally {
                AdminBackup.this.backupButton.setEnabled(true);
                AdminBackup.this.bar5.off();
            }
        }
    }
}

