/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.enterprise;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.shelp.proxy.PeerPipe;
import com.aem.shelp.proxy.config.ServerConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import utils.message.Message;
import utils.message.TypedMap;

public class PeerConfig {
    public static final File CONFIGS_FOLDER = new File("configuration/peers");
    String identity;
    String hostname;
    String authToken;
    String pubKeyHash;
    boolean syncHistory = false;
    boolean syncSessionTokens = false;
    int licensesToIssue;
    int transient_myIssuedLicenses;
    long transient_lastConnectFailure;
    long transient_lastValidConnected;
    private static int count = 0;

    public String toString() {
        return "PeerConfig (id:" + this.identity + " hostname:" + this.hostname + " history:" + this.syncHistory + " sessions:" + this.syncSessionTokens + ")";
    }

    public int hashCode() {
        return this.authToken.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PeerConfig) {
            PeerConfig pc = (PeerConfig)o;
            return this.authToken.equals(pc.authToken);
        }
        return false;
    }

    public int getLicensesToIssue() {
        return this.licensesToIssue;
    }

    public void setLicensesToIssue(int sessions) {
        this.licensesToIssue = sessions;
    }

    public void setTransient_lastValidConnected(long t) {
        this.transient_lastValidConnected = t;
    }

    public long getTransient_lastValidConnected() {
        return this.transient_lastValidConnected;
    }

    public void setTransient_lastConnectFailure(long t) {
        this.transient_lastConnectFailure = t;
    }

    public long getTransient_lastConnectFailure() {
        return this.transient_lastConnectFailure;
    }

    public void setTransientMyIssuedLicenses(int n) {
        this.transient_myIssuedLicenses = n;
    }

    public int getTransientMyIssuedLicenses() {
        return this.transient_myIssuedLicenses;
    }

    public String getPubKeyHash() {
        return this.pubKeyHash;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void updateIdentity(String name) {
        this.identity = name;
    }

    public String getHostname() {
        return this.hostname;
    }

    private PeerConfig() {
    }

    private TypedMap toMap(boolean includeTransient) throws IOException {
        TypedMap map = new TypedMap();
        map.setString("id", this.identity);
        map.setString("host", this.hostname);
        map.setString("auth", this.authToken);
        map.setString("pkhash", this.pubKeyHash);
        map.setBoolean("sync_history", this.syncHistory);
        map.setBoolean("sync_sessionTokens", this.syncSessionTokens);
        map.setInt("issued", this.licensesToIssue);
        map.setInt("mylicenses", this.transient_myIssuedLicenses);
        if (CentralDebugging.PX_PEER_PROCESSING) {
            System.out.println("[PeerConfig] Saving " + this);
        }
        return map;
    }

    public Message toMessage() throws IOException {
        return this.toMap(true).toCompressedMessage();
    }

    public void toFile(File f) throws IOException {
        this.toMap(false).toFile(f);
    }

    private static PeerConfig fromMap(TypedMap map) throws IOException {
        PeerConfig config = new PeerConfig();
        config.identity = map.getString("id");
        config.hostname = map.getString("host");
        config.authToken = map.getString("auth");
        config.pubKeyHash = map.getString("pkhash");
        config.syncHistory = map.getBoolean("sync_history", false);
        config.syncSessionTokens = map.getBoolean("sync_sessionTokens", false);
        config.licensesToIssue = map.contains("issued") ? map.getInt("issued") : 0;
        config.transient_myIssuedLicenses = map.contains("mylicenses") ? map.getInt("mylicenses") : 0;
        if (CentralDebugging.PX_PEER_PROCESSING) {
            System.out.println("[PeerConfig] Loaded " + config);
        }
        return config;
    }

    public static PeerConfig fromMessage(Message m) throws IOException {
        TypedMap map = TypedMap.fromCompressedMessage(m);
        System.out.println("PeerConfig.fromMessage() - " + map);
        return PeerConfig.fromMap(map);
    }

    public static PeerConfig fromFile(String authToken) throws IOException {
        String fileName = authToken.substring(0, 20);
        return PeerConfig.fromFile(new File(CONFIGS_FOLDER, fileName));
    }

    public static PeerConfig fromFile(File file) throws IOException {
        TypedMap map = TypedMap.fromFile(file);
        System.out.println("PeerConfig.fromFile() - " + map);
        return PeerConfig.fromMap(map);
    }

    public boolean isSyncHistory() {
        return this.syncHistory;
    }

    public boolean isSyncSessionTokens() {
        return this.syncSessionTokens;
    }

    private String getFileName() {
        return this.authToken.substring(0, 20);
    }

    public void deleteConfig() {
        File target = new File(CONFIGS_FOLDER, this.getFileName());
        System.out.println("[Peer] Asked to delete config " + target);
        target.delete();
    }

    public boolean hasStoredConfig() {
        return new File(CONFIGS_FOLDER, this.getFileName()).exists();
    }

    public void save() throws IOException {
        CONFIGS_FOLDER.mkdirs();
        File target = new File(CONFIGS_FOLDER, this.getFileName());
        if (CentralDebugging.PX_PEER_PROCESSING) {
            System.out.println("[Peer] Saving peer config to " + target.getCanonicalPath());
        }
        this.toFile(target);
    }

    public static ArrayList<PeerConfig> loadAll() {
        ArrayList<PeerConfig> all = new ArrayList<PeerConfig>();
        File[] files = CONFIGS_FOLDER.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.getName().startsWith("_")) continue;
                try {
                    all.add(PeerConfig.fromFile(f));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        return all;
    }

    public static String createAuthToken() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            sb.append(Long.toString(Math.abs(BCUtil.getSecureRandom().nextLong())));
        }
        return sb.toString();
    }

    public static PeerConfig createNewConfig(String identity, String hostname, String pubKeyHash, String authToken) {
        PeerConfig config = new PeerConfig();
        config.identity = identity;
        config.hostname = hostname;
        config.pubKeyHash = pubKeyHash;
        config.authToken = authToken;
        return config;
    }

    public static PeerConfig createTestConfig() {
        PeerConfig config = new PeerConfig();
        config.identity = "Primary " + count;
        config.hostname = "example" + count + ".simplehelp.io";
        config.pubKeyHash = "ABCDHASH" + count;
        config.authToken = PeerConfig.createAuthToken();
        ++count;
        return config;
    }

    private static File getPeerMetadataFile() {
        CONFIGS_FOLDER.mkdirs();
        return new File(CONFIGS_FOLDER, "__peer_metadata__");
    }

    public static void setPeerServerName(String name) {
        File file = PeerConfig.getPeerMetadataFile();
        TypedMap map = new TypedMap();
        map.setString("name", name);
        try {
            map.toFile(file);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public static String getPeerServerName() {
        File file = PeerConfig.getPeerMetadataFile();
        if (file.exists()) {
            try {
                TypedMap map = TypedMap.fromFile(file);
                String name = map.getString("name");
                if (name != null && name.length() > 0) {
                    return name;
                }
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        return ServerConfig.get().hostname;
    }

    public static PeerConfig getConnected(PeerConfig config) {
        for (PeerConfig connected : PeerPipe.getConnectedPeerList()) {
            if (!config.getAuthToken().equals(connected.getAuthToken())) continue;
            return connected;
        }
        return config;
    }

    public static void updateToLatest(ArrayList<PeerConfig> list) {
        HashMap<String, PeerConfig> map = new HashMap<String, PeerConfig>();
        for (PeerConfig config : PeerPipe.getConnectedPeerList()) {
            map.put(config.getAuthToken(), config);
        }
        for (int i = 0; i < list.size(); ++i) {
            PeerConfig config;
            config = list.get(i);
            PeerConfig connected = (PeerConfig)map.get(config.getAuthToken());
            if (connected == null) continue;
            connected.copyStateFrom(config);
            list.set(i, connected);
        }
        map = new HashMap();
        for (PeerConfig config : PeerConfig.loadAll()) {
            map.put(config.getAuthToken(), config);
        }
        for (PeerConfig config : list) {
            PeerConfig file = (PeerConfig)map.get(config.getAuthToken());
            if (file == null) continue;
            config.setLicensesToIssue(file.getLicensesToIssue());
            config.updateIdentity(file.getIdentity());
        }
    }

    private void copyStateFrom(PeerConfig config) {
        this.setLicensesToIssue(config.getLicensesToIssue());
        this.updateIdentity(config.getIdentity());
        this.setSyncHistory(config.isSyncHistory());
        this.setSyncSessionTokens(config.isSyncSessionTokens());
    }

    public void setSyncHistory(boolean syncHistory) {
        this.syncHistory = syncHistory;
    }

    public void setSyncSessionTokens(boolean syncSessionTokens) {
        this.syncSessionTokens = syncSessionTokens;
    }
}

