/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;

public class PasswordDialog
extends ScaledGlassDialog
implements KeyListener,
ActionListener {
    JButton bok;
    JButton bcancel;
    JFixedWidthPasswordField oldPasswordField;
    JFixedWidthPasswordField newPassword1;
    JFixedWidthPasswordField newPassword2;
    boolean requireOldPassword = false;
    String username;
    String oldPassword;
    public char[] newPassword;
    boolean isOK;

    public PasswordDialog(RootPaneContainer rootPane, int w, int h, boolean modal, boolean makeVisible, boolean tint, boolean requireOldPassword, String username, String oldPassword) {
        super(rootPane, w, h, modal, makeVisible, tint);
        this.requireOldPassword = requireOldPassword;
        this.username = username;
        this.oldPassword = oldPassword;
        this.setModal(true);
        JPanel main = new JPanel();
        main.setBorder(SHBorderFactory.createEmptyBorder(10, 20, 10, 20));
        GridBagLayout gbl = new GridBagLayout();
        main.setLayout(gbl);
        JWrapLabel description = username.equals(OemBranding.OEM_ADMIN_USERNAME) ? new JWrapLabel("<html>" + Language.get("PASSWORD_DIALOG_DESC_ADMIN") + "</html>") : new JWrapLabel("<html>" + Language.get("PASSWORD_DIALOG_DESC") + " '" + username + "'. </html>");
        JLabel oldPasswordLabel = new JLabel(Language.get("PASSWORD_DIALOG_OLD"));
        JLabel newPassword1Label = new JLabel(Language.get("PASSWORD_DIALOG_NEW1"));
        JLabel newPassword2Label = new JLabel(Language.get("PASSWORD_DIALOG_NEW2"));
        JLabel icon = new JLabel(ImageLoader.getImageIcon("images/svg/general/lock.svg,48"));
        this.oldPasswordField = new JFixedWidthPasswordField();
        this.newPassword1 = new JFixedWidthPasswordField();
        this.newPassword2 = new JFixedWidthPasswordField();
        this.bok = new JButton(Language.get("PASSWORD_DIALOG_SET_PASSWORD"));
        this.bcancel = new JButton(Language.get("CANCEL"));
        SHButtonUI.makeButtonBlue(this.bok);
        JPanel buttonWidthPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        buttonWidthPanel.add(this.bcancel);
        buttonWidthPanel.add(this.bok);
        int Y = 0;
        gbl.setConstraints(description, new GridBagConstraints(0, Y++, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (requireOldPassword) {
            gbl.setConstraints(oldPasswordLabel, new GridBagConstraints(1, Y, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            gbl.setConstraints(this.oldPasswordField, new GridBagConstraints(2, Y++, 1, 1, 100.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        gbl.setConstraints(newPassword1Label, new GridBagConstraints(1, Y, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        gbl.setConstraints(this.newPassword1, new GridBagConstraints(2, Y++, 1, 1, 100.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        gbl.setConstraints(newPassword2Label, new GridBagConstraints(1, Y, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        gbl.setConstraints(this.newPassword2, new GridBagConstraints(2, Y++, 1, 1, 100.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        gbl.setConstraints(buttonWidthPanel, new GridBagConstraints(0, Y++, 3, 1, 100.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        gbl.setConstraints(icon, new GridBagConstraints(0, 1, 1, Y - 2, 1.0, 1.0, 11, 3, new Insets(0, 0, 0, 10), 0, 0));
        main.add(buttonWidthPanel);
        main.add(icon);
        main.add(description);
        main.add(newPassword1Label);
        main.add(newPassword2Label);
        if (requireOldPassword) {
            main.add(this.oldPasswordField);
            main.add(oldPasswordLabel);
        }
        main.add(this.newPassword1);
        main.add(this.newPassword2);
        if (requireOldPassword) {
            this.oldPasswordField.addKeyListener(this);
        }
        this.newPassword1.addKeyListener(this);
        this.newPassword2.addKeyListener(this);
        this.bok.addActionListener(this);
        this.bcancel.addActionListener(this);
        this.bok.setEnabled(false);
        this.getContentPane().add(main);
        this.setTitle(Language.get("PASSWORD_DIALOG_TITLE"));
        if (requireOldPassword) {
            this.setFocusComponent(this.oldPasswordField);
        } else {
            this.setFocusComponent(this.newPassword1);
        }
        if (CentralDebugging.GLASS_DIALOGS_VERBOSE) {
            System.out.println("Setting password dialog visible");
        }
        this.setVisible(true);
        if (CentralDebugging.GLASS_DIALOGS_VERBOSE) {
            System.out.println("Set password dialog visible");
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        boolean valid;
        if (e.getKeyCode() == 27) {
            this.isOK = false;
            this.setVisible(false);
            return;
        }
        boolean bl = valid = Arrays.equals(this.newPassword1.getPassword(), this.newPassword2.getPassword()) && this.newPassword1.getPassword().length > 0;
        if (valid && this.requireOldPassword) {
            valid = new String(this.oldPasswordField.getPassword()).equals(this.oldPassword);
        }
        this.bok.setEnabled(valid);
        if (valid && e.getKeyCode() == 10) {
            this.isOK = true;
            this.newPassword = this.newPassword1.getPassword();
            this.setVisible(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.bok)) {
            this.isOK = true;
            this.newPassword = this.newPassword1.getPassword();
        } else {
            this.isOK = false;
        }
        this.setVisible(false);
    }

    public boolean isOK() {
        return this.isOK;
    }
}

