/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.utils;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class AutoscrollSupport
implements Autoscroll {
    private Component comp;
    private Insets insets;
    private Insets scrollUnits;
    private Point lastPoint = null;
    private int xDiff = 0;
    private int yDiff = 0;

    public AutoscrollSupport(Component comp, Insets insets) {
        this(comp, insets, insets);
    }

    public AutoscrollSupport(Component comp, Insets insets, Insets scrollUnits) {
        this.comp = comp;
        this.insets = insets;
        this.scrollUnits = scrollUnits;
    }

    @Override
    public void autoscroll(Point cursorLoc) {
        JViewport viewport = this.getViewport();
        if (viewport == null) {
            return;
        }
        Point viewPos = viewport.getViewPosition();
        int viewHeight = viewport.getExtentSize().height;
        int viewWidth = viewport.getExtentSize().width;
        Point scrollPoint = null;
        if (this.lastPoint == null || !cursorLoc.equals(this.lastPoint)) {
            this.xDiff = 0;
            this.yDiff = 0;
            this.lastPoint = cursorLoc;
            if (cursorLoc.y - viewPos.y < this.insets.top) {
                this.xDiff = 0;
                this.yDiff = -this.scrollUnits.top;
            } else if (viewPos.y + viewHeight - cursorLoc.y < this.insets.bottom) {
                this.xDiff = 0;
                this.yDiff = this.scrollUnits.bottom;
            } else if (cursorLoc.x - viewPos.x < this.insets.left) {
                this.yDiff = 0;
                this.xDiff = -this.scrollUnits.left;
            } else if (viewPos.x + viewWidth - cursorLoc.x < this.insets.right) {
                this.xDiff = this.scrollUnits.right;
                this.yDiff = 0;
            }
        }
        scrollPoint = new Point(viewPos.x + this.xDiff, viewPos.y + this.yDiff);
        scrollPoint.x = Math.max(scrollPoint.x, 0);
        scrollPoint.y = Math.max(scrollPoint.y, 0);
        scrollPoint.x = Math.min(scrollPoint.x, this.comp.getWidth() - viewWidth);
        scrollPoint.y = Math.min(scrollPoint.y, this.comp.getHeight() - viewHeight);
        if (scrollPoint != null) {
            viewport.setViewPosition(scrollPoint);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        int height = this.comp.getHeight();
        int width = this.comp.getWidth();
        return new Insets(height, width, height, width);
    }

    JViewport getViewport() {
        return (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.comp);
    }
}

