/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.model.machine.filters;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.subgroups.FilterResultsGroup;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeNodeFilterProcessor;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utils.xml.XML14Util;

public class TextMachineFilter
extends TreeNodeFilterProcessor<MachineGroup, Machine> {
    private MachineGroup rootGroup;
    private String[] conjunctions;
    private String id;
    private static int offset = 0;

    public TextMachineFilter(MachineGroup rootGroup, String[] conjunctions) {
        this();
        this.rootGroup = rootGroup;
        this.conjunctions = conjunctions;
    }

    private TextMachineFilter() {
        this.id = System.currentTimeMillis() + "-" + offset++;
    }

    public void setConjunctionFilters(String[] conjunctions) {
        this.conjunctions = conjunctions;
    }

    public TextMachineFilter(MachineGroup rootGroup) {
        this.rootGroup = rootGroup;
        this.conjunctions = null;
        this.id = System.currentTimeMillis() + "";
    }

    @Override
    public void setRoot(MachineGroup root) {
        this.rootGroup = root;
    }

    @Override
    public boolean includes(Machine machine) {
        if (this.conjunctions == null) {
            return false;
        }
        for (String filter : this.conjunctions) {
            try {
                if (machine.matchesFilter(filter)) continue;
                return false;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public MachineGroup getRoot() {
        return this.rootGroup;
    }

    @Override
    public String getMetadata() {
        return this.id;
    }

    @Override
    public String getXMLIdentifier() {
        return "TextMachineFilter";
    }

    @Override
    public void saveToXML(StringBuffer xml) {
        xml.append("<FilterProcessor groupName=\"").append(XML14Util.escape(this.rootGroup.groupName)).append("\" class=\"" + this.getXMLIdentifier() + "\">\n");
        for (String string : this.conjunctions) {
            xml.append("\t<Conjunction>").append(XML14Util.escape(string)).append("</Conjunction>\n");
        }
        xml.append("</FilterProcessor>\n");
    }

    public void fromXML(AbstractTreeModel<MachineGroup, Machine> model, Element filterProcessorElement) {
        String groupName = filterProcessorElement.getAttribute("groupName");
        NodeList elementsByTagName = filterProcessorElement.getElementsByTagName("Conjunction");
        ArrayList<String> conjunctions = new ArrayList<String>();
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Element element = (Element)elementsByTagName.item(i);
            String content = element.getTextContent().trim();
            conjunctions.add(content);
        }
        FilterResultsGroup group = FilterResultsGroup.newResultsGroup(groupName);
        group.setTemporary(false);
        this.rootGroup = group;
        this.conjunctions = conjunctions.toArray(new String[0]);
    }

    @Override
    public boolean removeIfEmpty() {
        return false;
    }
}

