/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.model.machine.filters;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.common.toolbox.ToolBoxStatus;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.service.ServiceUIListener;
import com.aem.shelp.tech.hierarchy.model.TreeNodeFilterProcessor;
import com.aem.shelp.tech.toolbox.ToolBoxResultUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class RunToolMachineFilter
extends TreeNodeFilterProcessor<MachineGroup, Machine> {
    private MachineGroup rootGroup;
    private List<Machine> machinesToUpdate;
    private RunToolMachineUI ui;
    private ServiceUIListener listener;
    private long runID;

    public RunToolMachineUI getUi() {
        return this.ui;
    }

    public RunToolMachineFilter(TechClient client, ArrayList<Machine> machines, MachineGroup rootGroup, ServiceUIListener listener, ToolBoxItem item) {
        this.machinesToUpdate = machines;
        this.rootGroup = rootGroup;
        this.listener = listener;
        listener.setFilterProcessor(this);
        this.ui = new RunToolMachineUI(client, machines.toArray(new Machine[0]), listener, item);
    }

    @Override
    public void setRoot(MachineGroup root) {
        this.rootGroup = root;
        this.ui.listener.setRoot(root);
    }

    public void removeMachine(Machine machine) {
        this.machinesToUpdate.remove(machine);
    }

    @Override
    public boolean includes(Machine machine) {
        return this.machinesToUpdate.contains(machine);
    }

    @Override
    public MachineGroup getRoot() {
        return this.rootGroup;
    }

    @Override
    public String getMetadata() {
        return "RUNTOOL";
    }

    @Override
    public void saveToXML(StringBuffer xml) {
    }

    @Override
    public boolean removeIfEmpty() {
        return true;
    }

    @Override
    public String getXMLIdentifier() {
        return null;
    }

    public void setRunID(long runID) {
        this.runID = runID;
    }

    public class RunToolMachineUI
    implements ActionListener {
        private final TechClient client;
        private final HashMap<String, ToolBoxResultWrapper> machineIDToResultMap = new HashMap();
        private final ToolBoxItem item;
        private ServiceUIListener listener;
        private JPanel rootComponent = new JPanel();
        private ToolBoxResultUI resultsUI;
        private JButton clearThisMachine = new JButton();
        private JButton clearAllResults = new JButton();
        private Machine selectedMachine;

        public RunToolMachineUI(TechClient client, Machine[] array, ServiceUIListener listener, ToolBoxItem item) {
            this.listener = listener;
            this.client = client;
            this.item = item;
            this.initUI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ToolBoxResultWrapper getResultsWrapperFor(Machine machine) {
            HashMap<String, ToolBoxResultWrapper> hashMap = this.machineIDToResultMap;
            synchronized (hashMap) {
                if (machine == null) {
                    return null;
                }
                ToolBoxResultWrapper result = this.machineIDToResultMap.get(machine.getID());
                if (result == null) {
                    result = new ToolBoxResultWrapper();
                    this.machineIDToResultMap.put(machine.getID(), result);
                }
                return result;
            }
        }

        private void initUI() {
            this.resultsUI = new ToolBoxResultUI(this.item);
            this.clearThisMachine.setText(Language.get("TOOLBOX_CLEAR_MACHINE"));
            this.clearAllResults.setText(Language.get("TOOLBOX_CLEAR_ALL_RESULTS"));
            this.clearThisMachine.addActionListener(this);
            this.clearAllResults.addActionListener(this);
            GbPanel buttonPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
            buttonPanel.add(this.clearThisMachine, 0, 0, 1, 1, 1, 0, 13, 0);
            buttonPanel.add(this.clearAllResults, 1, 0, 1, 1, 0, 0, 13, 0);
            this.rootComponent.setLayout(new BorderLayout());
            this.rootComponent.add((Component)this.resultsUI.rootComponent, "Center");
            this.rootComponent.add((Component)buttonPanel, "South");
            SwingUtil.setSizesToWidest(this.clearThisMachine, this.clearAllResults);
        }

        public JPanel getRootComponent() {
            return this.rootComponent;
        }

        public void setSelectedMachines(Machine[] machines) {
            this.selectedMachine = machines[0];
            this.reloadResult(this.machineIDToResultMap.get(this.selectedMachine.getID()));
        }

        public void setResult(Machine machine, ToolBoxResult result) {
            ToolBoxResultWrapper resultWrapper = this.getResultsWrapperFor(machine);
            resultWrapper.updateStatus(result);
            if (this.selectedMachine != null && this.selectedMachine.equals(machine)) {
                this.reloadResult(resultWrapper);
            }
        }

        public void updateStatus(Machine machine, ToolBoxStatus statusUpdate) {
            if (machine == null) {
                return;
            }
            ToolBoxResultWrapper resultWrapper = this.getResultsWrapperFor(machine);
            if (resultWrapper != null) {
                resultWrapper.updateStatus(statusUpdate);
                if (this.selectedMachine != null && this.selectedMachine.equals(machine)) {
                    this.reloadResult(resultWrapper);
                }
            }
        }

        private void reloadResult(ToolBoxResultWrapper resultWrapper) {
            this.resultsUI.load(resultWrapper);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.clearThisMachine) {
                try {
                    System.out.println("[RunToolMachineFilter] Cancelling run to " + this.selectedMachine + " with " + RunToolMachineFilter.this.runID);
                    this.client.cancelToolboxRun(new Machine[]{this.selectedMachine}, RunToolMachineFilter.this.runID, 1);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                this.listener.removeMachineFromList(this.selectedMachine);
            } else {
                try {
                    System.out.println("[RunToolMachineFilter] Cancelling run to " + RunToolMachineFilter.this.machinesToUpdate.size() + " machines with " + RunToolMachineFilter.this.runID);
                    this.client.cancelToolboxRun(RunToolMachineFilter.this.machinesToUpdate.toArray(new Machine[0]), RunToolMachineFilter.this.runID, 1);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                this.listener.finish();
            }
        }
    }

    public static class ToolBoxResultWrapper {
        public byte statusCode;
        public StringBuffer stdout = new StringBuffer();
        public StringBuffer stderr = new StringBuffer();
        public String launchError;
        public int returnCode;

        public String toString() {
            return "ToolBoxStatus Status:" + this.statusCode + " Error:" + this.launchError + " Return:" + this.returnCode + " Std:" + this.stdout.length() + "/" + this.stderr.length();
        }

        public void updateStatus(ToolBoxStatus status) {
            if (status.statusCode > this.statusCode) {
                this.statusCode = status.statusCode;
            }
            if (status.stdout != null) {
                this.stdout.append(status.stdout);
            }
            if (status.stderr != null) {
                this.stderr.append(status.stderr);
            }
            if (status.error != null) {
                this.launchError = status.error;
            }
        }

        public void updateStatus(ToolBoxResult result) {
            this.returnCode = result.returnCode;
            if (result.stdout != null) {
                this.stdout.append(result.stdout);
            }
            if (result.stderr != null) {
                this.stderr.append(result.stderr);
            }
            if (result.preLaunchError != null) {
                this.launchError = result.preLaunchError;
            }
        }
    }
}

