/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.model.machine;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.hierarchy.model.stats.DescendentTreeStats;
import java.util.ArrayList;

public class MachineGroupStats
extends DescendentTreeStats<Machine> {
    public int offlineCount = 0;
    public int availableCount = 0;
    public int needRestartCount = 0;
    public int supportsAutoUpdateCount = 0;
    public int needUpgradeCount = 0;
    public int monitored = 0;
    public int autoUpdating = 0;
    public int allowMonitoring = 0;
    public int activeSessionCount = 0;

    @Override
    public void copyFrom(DescendentTreeStats<Machine> treeStats) {
        super.copyFrom(treeStats);
        MachineGroupStats stats = (MachineGroupStats)treeStats;
        this.offlineCount = stats.offlineCount;
        this.availableCount = stats.availableCount;
        this.needRestartCount = stats.needRestartCount;
        this.supportsAutoUpdateCount = stats.supportsAutoUpdateCount;
        this.needUpgradeCount = stats.needUpgradeCount;
        this.monitored = stats.monitored;
        this.autoUpdating = stats.autoUpdating;
        this.allowMonitoring = stats.allowMonitoring;
        this.activeSessionCount = stats.activeSessionCount;
    }

    @Override
    public void remove(Machine machine) {
        super.remove(machine);
        if (machine.isAvailable()) {
            --this.availableCount;
            if (machine.needsRestarting()) {
                --this.needRestartCount;
            }
            if (machine.supportsAutoUpdating()) {
                --this.supportsAutoUpdateCount;
            }
            if (machine.needsUpgrading()) {
                --this.needUpgradeCount;
            }
            if (machine.isMonitored()) {
                --this.monitored;
            }
            if (machine.isAutoUpdating()) {
                --this.autoUpdating;
            }
            if (machine.allowMonitoring()) {
                --this.allowMonitoring;
            }
            this.activeSessionCount -= machine.getActiveSessionCount();
        } else {
            --this.offlineCount;
        }
    }

    @Override
    public void add(Machine machine) {
        super.add(machine);
        if (machine.isAvailable()) {
            ++this.availableCount;
            if (machine.needsRestarting()) {
                ++this.needRestartCount;
            }
            if (machine.supportsAutoUpdating()) {
                ++this.supportsAutoUpdateCount;
            }
            if (machine.needsUpgrading()) {
                ++this.needUpgradeCount;
            }
            if (machine.isMonitored()) {
                ++this.monitored;
            }
            if (machine.isAutoUpdating()) {
                ++this.autoUpdating;
            }
            if (machine.allowMonitoring()) {
                ++this.allowMonitoring;
            }
            this.activeSessionCount += machine.getActiveSessionCount();
        } else {
            ++this.offlineCount;
        }
    }

    @Override
    public void updateWith(Machine.MachineChanges stats) {
        if (stats == null) {
            return;
        }
        super.updateWith(stats);
        this.offlineCount += stats.offlineCount;
        this.availableCount += stats.availableCount;
        this.needRestartCount += stats.needRestartCount;
        this.supportsAutoUpdateCount += stats.supportsAutoUpdateCount;
        this.needUpgradeCount += stats.needUpgradeCount;
        this.monitored += stats.monitored;
        this.autoUpdating += stats.autoUpdating;
        this.allowMonitoring += stats.allowMonitoring;
        this.activeSessionCount += stats.activeSessionCount;
    }

    @Override
    public void descendentsRemoved(ArrayList<Machine> removedItems) {
        super.descendentsRemoved(removedItems);
        for (Machine m : removedItems) {
            this.activeSessionCount -= m.getActiveSessionCount();
        }
    }

    @Override
    public void descendentsAdded(ArrayList<Machine> addedMachines) {
        super.descendentsAdded(addedMachines);
        for (Machine m : addedMachines) {
            this.activeSessionCount += m.getActiveSessionCount();
        }
    }

    @Override
    public void descendentUpdated(Machine.MachineChanges copyStateFrom) {
        if (copyStateFrom == null) {
            return;
        }
        super.descendentUpdated(copyStateFrom);
        this.activeSessionCount += copyStateFrom.activeSessionCount;
    }
}

