/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.dnd;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicLong THREAD_POOL_NUM = new AtomicLong(0L);
    private final AtomicLong mThreadNum = new AtomicLong(0L);
    private final String mPrefix;
    private final boolean mIsDaemon;

    public NamedThreadFactory(String pPrefix) {
        this(pPrefix, true);
        THREAD_POOL_NUM.incrementAndGet();
    }

    public NamedThreadFactory(String pPrefix, boolean pIsDaemon) {
        this.mIsDaemon = pIsDaemon;
        this.mPrefix = pPrefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.mPrefix + "-" + THREAD_POOL_NUM.get() + "-Thread-" + this.mThreadNum.incrementAndGet());
        if (t.isDaemon() != this.mIsDaemon) {
            t.setDaemon(this.mIsDaemon);
        }
        return t;
    }
}

