/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.tech.access.MachineDetailsPanel;
import com.aem.shelp.tech.access.contents.ui.MachineStatusLabel;
import com.aem.shelp.tech.customer.OSIconLoader;
import com.aem.shelp.tech.utils.WifiIcon;
import com.aem.shelp.util.EasyDateTimeFormatter;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.ScaledShadowImagePanel;
import utils.swing.color.ConfigurableColor;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JEditableLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.switches.Switches;
import utils.switches.oem.OEMSwitches;

public class SystemPanel
extends ColorPropagatingGBPanel {
    DecimalFormat df = new DecimalFormat("########0.#");
    JLabel hostname = new JLabel();
    JLabel lastPing = new JLabel();
    JLabel lastRestart = new JLabel();
    JLabel os = new JLabel();
    JLabel wifi = new JLabel();
    JLabel osIconLabel = new JLabel();
    MachineStatusLabel inUse = new MachineStatusLabel();
    JLabel inUseLabel;
    JEditableLabel title = new JEditableLabel(true);
    private ElapsedTimeFormatter eformat = new ElapsedTimeFormatter();
    private ScaledShadowImagePanel screenShotImagePanel = new ScaledShadowImagePanel();
    private Machine machine;
    private Cursor iBeam = Cursor.getPredefinedCursor(2);
    private MachineDetailsPanel detailsPanel;
    private TimerTask refreshTimeTask;
    private static Timer autoUpdateTimer = new Timer();
    private EasyDateTimeFormatter dateFormat = new EasyDateTimeFormatter();
    private JLabel lastRestartLabel;
    private JLabel wifiLabel;
    private SimpleDateFormat datef = new SimpleDateFormat("E d MMM HH:mm z");
    private HashMap<String, Integer> machineToScreenSelection = new HashMap();

    public SystemPanel(MachineDetailsPanel detailsPanel) {
        super(new Insets(0, 0, 0, 0));
        this.detailsPanel = detailsPanel;
        this.initSystemPanelUI();
        if (detailsPanel != null) {
            this.title.addListener(detailsPanel);
        }
        this.title.setFont(SHStyle.largeFont);
        this.title.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SystemPanel.this.title.setCursor(SystemPanel.this.iBeam);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SystemPanel.this.title.getBounds().contains(e.getPoint())) {
                    return;
                }
                SystemPanel.this.title.setCursor(null);
            }
        });
    }

    private void initSystemPanelUI() {
        Color borderColor;
        Color fillColor;
        int Y = 0;
        Border border = SHBorderFactory.createEmptyBorder(3, 3, 3, 3);
        this.osIconLabel.setBorder(border);
        this.title.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 3, 3));
        this.hostname.setBorder(border);
        this.os.setBorder(border);
        this.wifi.setBorder(border);
        this.lastPing.setBorder(border);
        this.lastRestart.setBorder(border);
        this.inUse.setBorder(border);
        this.screenShotImagePanel.setBorder(border);
        if (OEMSwitches.DARK_THEME) {
            fillColor = SHStyle.THEME_COLOR_BORDER;
            borderColor = SHStyle.THEME_COLOR_FILL;
        } else {
            fillColor = SHStyle.THEME_COLOR_FILL;
            borderColor = SHStyle.THEME_COLOR_BORDER;
        }
        new ConfigurableColor(fillColor, "SystemPanel.ScreenShot.fill", this);
        new ConfigurableColor(borderColor, "SystemPanel.ScreenShot.border", this);
        this.screenShotImagePanel.setColor(fillColor, borderColor);
        this.screenShotImagePanel.setShadowPanelListener(new ScaledShadowImagePanel.ShadowPanelListener(){

            @Override
            public void zoomPressed() {
                SystemPanel.this.detailsPanel.showBigScreenshot();
            }

            @Override
            public void leftPressed() {
                int screen = SystemPanel.this.screenShotImagePanel.getSelectedScreen();
                SystemPanel.this.machineToScreenSelection.put(SystemPanel.this.machine.getID(), new Integer(screen));
                SystemPanel.this.detailsPanel.previousScreen(false);
            }

            @Override
            public void rightPressed() {
                int screen = SystemPanel.this.screenShotImagePanel.getSelectedScreen();
                SystemPanel.this.machineToScreenSelection.put(SystemPanel.this.machine.getID(), new Integer(screen));
                SystemPanel.this.detailsPanel.nextScreen(false);
            }
        });
        JLabel hostnameLabel = new JLabel(Language.get("HOSTNAME"));
        this.inUseLabel = new JLabel(Language.get("STATUS"));
        this.wifiLabel = new JLabel(Language.get("WIFI_COMBINED"));
        JLabel osLabel = new JLabel(Language.get("OPERATING_SYSTEM"));
        this.lastRestartLabel = new JLabel(Language.get("LAST_RESTARTED"));
        JLabel lastPingLabel = new JLabel(Language.get("LAST_ACCESSED"));
        hostnameLabel.setHorizontalAlignment(4);
        this.wifiLabel.setHorizontalAlignment(4);
        osLabel.setHorizontalAlignment(4);
        this.inUseLabel.setHorizontalAlignment(4);
        this.lastRestartLabel.setHorizontalAlignment(4);
        lastPingLabel.setHorizontalAlignment(4);
        hostnameLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.wifiLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        osLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.inUseLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.lastRestartLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        lastPingLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        Insets rightBorder = new Insets(0, 0, 0, 3);
        this.add(this.osIconLabel, 0, Y, 1, 1, 0, 0, 11, 2);
        this.add(this.title, 1, Y++, 2, 1, 1, 0, 11, 2);
        this.add(hostnameLabel, 1, Y, 1, 1, 0, 0, 13, 2, rightBorder);
        this.add(this.hostname, 2, Y++, 1, 1, 0, 0, 17, 2);
        this.add(this.inUseLabel, 1, Y, 1, 1, 0, 0, 13, 2, rightBorder);
        this.add(this.inUse, 2, Y++, 1, 1, 1, 0, 17, 2);
        this.add(osLabel, 1, Y, 1, 1, 0, 0, 13, 2, rightBorder);
        this.add(this.os, 2, Y++, 1, 1, 0, 0, 17, 2);
        this.add(this.wifiLabel, 1, Y, 1, 1, 0, 0, 13, 2, rightBorder);
        this.add(this.wifi, 2, Y++, 1, 1, 0, 0, 17, 2);
        if (Switches.SH_1446_showUptimeInUI) {
            this.add(this.lastRestartLabel, 1, Y, 1, 1, 0, 0, 13, 2, rightBorder);
            this.add(this.lastRestart, 2, Y++, 1, 1, 0, 0, 17, 2);
        }
        this.add(lastPingLabel, 1, Y, 1, 1, 0, 0, 13, 2, rightBorder);
        this.add(this.lastPing, 2, Y++, 1, 1, 0, 0, 17, 2);
        this.add(new JPanel(), 2, Y++, 1, 1, 1, 1, 17, 1, new Insets(0, 0, 0, 0));
        this.add(this.screenShotImagePanel, 3, 0, 1, Y, 0, 100, 10, 1);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.screenShotImagePanel != null) {
            this.screenShotImagePanel.setBackground(color);
        }
    }

    public int getSelectedScreen(Machine machine) {
        Integer screenSelectionInteger = this.machineToScreenSelection.get(machine.getID());
        int screenSelection = 0;
        if (screenSelectionInteger != null) {
            screenSelection = screenSelectionInteger;
        }
        return screenSelection;
    }

    public void initSystemPanelWith(Machine machine) {
        this.inUse.setMachine(machine);
        MachineInfo info = machine.getMachineInfo();
        if (info != null) {
            this.screenShotImagePanel.setShowArrows(info.getScreenCount() > 1, info.getScreenCount(), this.getSelectedScreen(machine));
        }
        Icon osIcon = machine.isAvailable() ? OSIconLoader.getOSIcon(machine.getOsBaseType(), machine.getOsVariant(), machine.getOsSummary()) : OSIconLoader.getOSIconDisabled(machine.getOsBaseType(), machine.getOsVariant(), machine.getOsSummary());
        this.title.setText("<html>" + machine.getMachineName().getName());
        this.osIconLabel.setIcon(osIcon);
        this.hostname.setVisible(info != null);
        this.os.setVisible(info != null);
        if (info != null) {
            this.hostname.setText(info.getHostname());
            this.os.setText(info.getOsNameWithBitness());
        }
        boolean showWifi = machine.isAvailable() && info.getWifiMbit() > 0.0;
        this.wifiLabel.setVisible(showWifi);
        this.wifi.setVisible(showWifi);
        if (showWifi) {
            double signal = info.getWifiSignalPc();
            if (signal < 0.0) {
                signal = 0.0;
            }
            if (signal > 100.0) {
                signal = 100.0;
            }
            WifiIcon icon = new WifiIcon(signal);
            double mbit = info.getWifiMbit();
            if (mbit > 9.9) {
                mbit = (int)mbit;
            }
            this.wifi.setIcon(icon);
            this.wifi.setText(this.df.format(signal) + "% (" + this.df.format(mbit) + " Mbps)");
        }
        this.updatePingTime(machine);
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePingTime(Machine machine) {
        this.machine = machine;
        this.updatePingTimeLabel();
        if (machine != null) {
            Timer timer = autoUpdateTimer;
            synchronized (timer) {
                if (this.refreshTimeTask == null) {
                    this.refreshTimeTask = new TimerTask(){

                        @Override
                        public void run() {
                            SystemPanel.this.updatePingTimeLabel();
                            SystemPanel.this.inUse.updateTimer();
                        }
                    };
                    autoUpdateTimer.scheduleAtFixedRate(this.refreshTimeTask, 0L, 1000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePingTimeLabel() {
        long time;
        if (this.machine == null) {
            Timer timer = autoUpdateTimer;
            synchronized (timer) {
                if (this.refreshTimeTask != null) {
                    this.refreshTimeTask.cancel();
                    autoUpdateTimer.purge();
                }
            }
            return;
        }
        if (this.machine.getLastPingTimeMillis() == 0L) {
            this.lastPing.setText(Language.get("UNKNOWN"));
        } else if (this.machine.isAvailable()) {
            time = System.currentTimeMillis() - this.machine.getLastPingTimeMillis();
            time = Math.max(1000L, time);
            this.lastPing.setText(this.eformat.getFormattedTimeAgo(time));
        } else {
            time = System.currentTimeMillis() - this.machine.getLastPingTimeMillis();
            time = Math.max(1000L, time);
            this.lastPing.setText(this.eformat.getFormattedTimeAgo(time) + " (" + this.dateFormat.formatDateTime(this.machine.getLastPingTimeMillis()) + ")");
        }
        if (Switches.SH_1446_showUptimeInUI) {
            if (this.machine.getMachineInfo().getLastRestartedUTC() != 0L) {
                this.lastRestart.setVisible(true);
                this.lastRestartLabel.setVisible(true);
                long lastRestarted = this.machine.getMachineInfo().getLastRestartedLocal();
                long uptimeMs = System.currentTimeMillis() - lastRestarted;
                this.lastRestart.setText(this.eformat.getFormattedTimeAgo(uptimeMs) + " (" + this.datef.format(lastRestarted) + ")");
            } else {
                this.lastRestart.setVisible(false);
                this.lastRestartLabel.setVisible(false);
            }
        } else {
            this.lastRestart.setVisible(false);
            this.lastRestartLabel.setVisible(false);
        }
    }

    public void setImage(Image screenshot) {
        this.screenShotImagePanel.setImage(screenshot);
        if (screenshot != null) {
            this.screenShotImagePanel.setVisible(true);
        } else {
            this.screenShotImagePanel.setVisible(false);
        }
    }

    public void initUIWithPermissions(TechGroupPermissions permissions) {
        if (permissions.canViewScreenshots()) {
            this.screenShotImagePanel.setVisible(true);
        } else {
            this.screenShotImagePanel.setVisible(false);
        }
        this.title.setIsEditable(permissions.canManagePersistentConnections());
    }
}

