/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.sgateway.ServiceConfigureListener;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.SimpleGatewayServiceConfigure;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.MiniClient;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.SwingUtil;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class MachineConfigurePanel
implements ActionListener {
    private static GbPanel buttonsPanel;
    private static JButton okButton;
    private static JButton cancelButton;
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private JPanel contentPanel = new JPanel(new BorderLayout());
    private Machine configuringMachine;
    private AccessPanelListener accessPanelListener;
    private ServiceConfigureListener serviceListener;
    private Object PASSWORD_LOCK = new Object();
    private String enteredPassword = null;
    private boolean die;
    private SimpleGatewayServiceConfigure configurePanel;
    private JFixedWidthPasswordField passwordField;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public MachineConfigurePanel(Machine machine, AccessPanelListener listener, ServiceConfigureListener serviceListener) {
        this.accessPanelListener = listener;
        this.configuringMachine = machine;
        this.serviceListener = serviceListener;
        this.initUI();
        if (machine != null) {
            new ConfigureThread(machine, machine.isLaterThan(3, 9)).start();
        }
    }

    private void initUI() {
        JLabel title = new JLabel();
        title.setFont(SHStyle.largeFont);
        title.setText(Language.get("SG_CONFIGURE_SERVICE"));
        title.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 3, 3));
        title.setHorizontalAlignment(0);
        this.rootComponent.add((Component)title, "North");
        this.rootComponent.add((Component)this.contentPanel, "Center");
        this.showProgessPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String requestMachinePassword(boolean incorrectPassword) {
        Object object = this.PASSWORD_LOCK;
        synchronized (object) {
            this.showPasswordPrompt(incorrectPassword);
            try {
                this.PASSWORD_LOCK.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.enteredPassword;
        }
    }

    private void showProgessPanel() {
        this.contentPanel.removeAll();
        JLabel connectingLabel = new JLabel(Language.get("CONNECTING"));
        connectingLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        ArrowedProgressBar apb = new ArrowedProgressBar();
        GbPanel progressPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        progressPanel.add(apb.getRootComponent(), 0, 0, 1, 1, 0, 0, 13, 0);
        progressPanel.add(connectingLabel, 1, 0, 1, 1, 0, 0, 17, 0);
        apb.on();
        this.contentPanel.add("Center", progressPanel);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    private void showConfigurationEditor(SimpleGatewayConfig config, boolean supportsUDP) {
        this.contentPanel.removeAll();
        this.contentPanel.setLayout(new BorderLayout());
        this.configurePanel = new SimpleGatewayServiceConfigure(SwingUtil.getRootPaneContainer(this.contentPanel), null, config, this.serviceListener, supportsUDP, false);
        this.configurePanel.setTechClient(this.accessPanelListener.getTechClient());
        this.configurePanel.setBorder(SHBorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.contentPanel.add("Center", this.configurePanel);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private void showPasswordPrompt(boolean isIncorrectPassword) {
        this.contentPanel.removeAll();
        this.passwordField = new JFixedWidthPasswordField();
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MachineConfigurePanel.this.okPressed();
                } else if (e.getKeyCode() == 27) {
                    MachineConfigurePanel.this.cancelPressed();
                }
            }
        });
        SwingUtil.setWidth(this.passwordField, 200);
        GbPanel passwordPanel = new GbPanel(new ScaledInsets(6, 6, 6, 6));
        int Y = 0;
        cancelButton = new JButton(Language.get("CANCEL"));
        okButton = new JButton(Language.get("LOGIN"));
        SHButtonUI.makeButtonBlue(okButton);
        cancelButton.addActionListener(this);
        okButton.addActionListener(this);
        SwingUtil.setSizesToWidest(cancelButton, okButton);
        buttonsPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        buttonsPanel.add(cancelButton, 0, 0, 1, 0, 1, 1, 13, 0);
        buttonsPanel.add(okButton, 1, 0, 1, 0, 0, 1, 17, 0);
        SwingUtil.setWidth(buttonsPanel, 320);
        JLabel desc = new JLabel(Language.get("COMPUTER_REQUIRES_PASSWORD") + ".");
        if (isIncorrectPassword) {
            desc.setText(Language.get("QUEUE_PASSWORD_INCORRECT_TITLE"));
            desc.setForeground(Color.red);
        }
        desc.setHorizontalAlignment(0);
        passwordPanel.add(desc, 0, Y++, 2, 1, 1, 0, 17, 2);
        passwordPanel.add(new JLabel(Language.get("MOBILE_MACHINE_PASSWORD")), 0, Y, 1, 1, 1, 0, 13, 3);
        passwordPanel.add(this.passwordField, 1, Y++, 1, 1, 1, 0, 17, 3);
        passwordPanel.add(buttonsPanel, 0, Y++, 2, 1, 0, 0, 10, 0);
        passwordPanel.add(new JPanel(), 0, Y++, 2, 1, 1, 100, 10, 1);
        this.contentPanel.add("Center", passwordPanel);
        this.passwordField.requestFocusInWindow();
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setSize(500, 200);
        Language.loadTranslations();
        MachineConfigurePanel mcp = new MachineConfigurePanel(null, null, null);
        frame.getContentPane().add(mcp.getRootComponent());
        frame.setVisible(true);
        Thread.sleep(1000L);
        System.out.println("BOOM: " + mcp.requestMachinePassword(false));
        System.out.println("BOOM: " + mcp.requestMachinePassword(true));
    }

    public boolean isConfiguring(Machine firstMachine) {
        if (this.configuringMachine == null) {
            return false;
        }
        return this.configuringMachine.getMachineID() == firstMachine.getMachineID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConfiguring(boolean saveResult) {
        if (!saveResult) {
            this.die = true;
        }
        MachineConfigurePanel machineConfigurePanel = this;
        synchronized (machineConfigurePanel) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okPressed() {
        Object object = this.PASSWORD_LOCK;
        synchronized (object) {
            this.enteredPassword = new String(this.passwordField.getPassword());
            this.PASSWORD_LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPressed() {
        Object object = this.PASSWORD_LOCK;
        synchronized (object) {
            System.out.println("[MachineConfigurePanel] Cancel was pressed");
            this.enteredPassword = null;
            this.PASSWORD_LOCK.notify();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == okButton) {
            this.okPressed();
        } else {
            this.cancelPressed();
        }
    }

    class ConfigureThread
    extends Thread {
        Machine machine;
        boolean supportsUDP;

        public ConfigureThread(Machine machine, boolean supportsUDP) {
            this.machine = machine;
            this.supportsUDP = supportsUDP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            boolean useMiniSession = !this.machine.isLaterThan(4, 1);
            String pass = null;
            System.out.println("[MachineConfiguration] Trying to configure " + this.machine.getMachineID() + " (Try lossy is " + !useMiniSession + ")");
            MiniClient mini = null;
            TechClient client = MachineConfigurePanel.this.accessPanelListener.getTechClient();
            try {
                boolean loginRequired = false;
                SimpleGatewayConfig config = null;
                if (!useMiniSession) {
                    try {
                        config = client.getServiceConfigViaSecMsg(this.machine.getMachineID(), pass);
                    }
                    catch (TechClient.PasswordRequiredException t) {
                        System.out.println("[MachineConfiguration] Password required for machine " + this.machine.getMachineID());
                        loginRequired = true;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        System.out.println("[MachineConfiguration] Falling back to mini session due to " + t.getMessage());
                        t.printStackTrace();
                        useMiniSession = true;
                    }
                }
                if (useMiniSession) {
                    mini = client.startMiniSession(this.machine.getMachineID());
                    loginRequired = mini.isLoginRequired();
                }
                if (loginRequired) {
                    boolean isIncorrect = false;
                    while (loginRequired) {
                        pass = MachineConfigurePanel.this.requestMachinePassword(isIncorrect);
                        if (pass == null) {
                            MachineConfigurePanel.this.serviceListener.cancelled();
                            return;
                        }
                        if (useMiniSession) {
                            loginRequired = !mini.doLogin(pass);
                        } else {
                            try {
                                config = client.getServiceConfigViaSecMsg(this.machine.getMachineID(), pass);
                                loginRequired = false;
                            }
                            catch (TechClient.PasswordRequiredException t) {
                                System.out.println("[MachineConfiguration] Password again required for machine " + this.machine.getMachineID() + " (invalid?)");
                                loginRequired = true;
                            }
                        }
                        isIncorrect = true;
                    }
                }
                if (useMiniSession) {
                    config = mini.fetchSgConfig();
                }
                if (MachineConfigurePanel.this.die) return;
                MachineConfigurePanel.this.showConfigurationEditor(config, this.supportsUDP);
                MachineConfigurePanel machineConfigurePanel = MachineConfigurePanel.this;
                // MONITORENTER : machineConfigurePanel
                MachineConfigurePanel.this.wait();
                // MONITOREXIT : machineConfigurePanel
                if (MachineConfigurePanel.this.die) {
                    MachineConfigurePanel.this.serviceListener.cancelled();
                    return;
                }
                if (useMiniSession) {
                    mini.storeSgConfig(MachineConfigurePanel.this.configurePanel.createConfigFromSettings());
                    return;
                }
                client.storeServiceConfigViaSecMsg(this.machine.getMachineID(), pass, MachineConfigurePanel.this.configurePanel.createConfigFromSettings());
                return;
            }
            catch (Exception x) {
                x.printStackTrace();
                RootPaneContainer rootPaneContainer = SwingUtil.getRootPaneContainer(MachineConfigurePanel.this.getRootComponent());
                System.out.println("[MachineDetailsPanel] RootPaneContainer is " + rootPaneContainer);
                SHGlassOptionPane.showErrorDialog(rootPaneContainer, x.getMessage(), Language.get("ERROR_CONTACTING_MACHINE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
                MachineConfigurePanel.this.serviceListener.cancelled();
                return;
            }
            finally {
                MachineConfigurePanel.this.configuringMachine = null;
                try {
                    if (mini != null) {
                        mini.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

