/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.details.ActiveSessionTable;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import utils.swing.RetinaImageIcon;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;

public class ActiveSessionRenderer
extends DefaultTableCellRenderer {
    private final int terminateButtonIndex;
    private ElapsedTimeFormatter timeFormat = new ElapsedTimeFormatter();
    private Color background;
    private int hoverRow = -1;
    private Image hoverImage;
    private Image nonHoverImage;
    private BufferedImage technicianImage;
    private ImageIcon hoverIcon;
    private ImageIcon nonHoverIcon;
    private AccessPanelListener listener;

    public ActiveSessionRenderer(AccessPanelListener listener, int terminateButtonIndex) {
        this.listener = listener;
        this.terminateButtonIndex = terminateButtonIndex;
        if (this.hoverImage == null) {
            this.hoverImage = SwingUtil.getButtonImage(Language.get("KILL_SESSION"), true);
            this.nonHoverImage = SwingUtil.getButtonImage(Language.get("KILL_SESSION"), false);
            this.technicianImage = new BufferedImage(this.hoverImage.getWidth(null), this.hoverImage.getHeight(null), 2);
            Graphics2D g2d = this.technicianImage.createGraphics();
            Icon imageIcon = ImageLoader.getImageIcon("images/svg/users/technician.svg,16");
            imageIcon.paintIcon(null, g2d, this.hoverImage.getWidth(null) - imageIcon.getIconWidth(), (this.hoverImage.getHeight(null) - imageIcon.getIconHeight()) / 2);
            g2d.dispose();
            this.hoverIcon = new RetinaImageIcon(this.hoverImage);
            this.nonHoverIcon = new RetinaImageIcon(this.nonHoverImage);
        }
    }

    public Dimension getButtonSize() {
        return new Dimension(this.nonHoverImage.getWidth(null), this.nonHoverImage.getHeight(null));
    }

    public void setRowBackground(Color c) {
        this.background = c;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        AbstractSession session;
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.setIcon(null);
        if (column == 0) {
            session = (AbstractSession)value;
            label.setText(session.getTechnicianDisplayName());
            if (session.isMobile()) {
                label.setIcon(ImageLoader.getImageIcon("images/svg/computing/tablet.svg,16"));
            } else if (session.isAppTunnelSession()) {
                label.setIcon(ImageLoader.getImageIcon("images/svg/computing/app-connection.svg,16"));
            } else {
                label.setIcon(ImageLoader.getImageIcon("images/svg/users/technician.svg,16"));
            }
        } else if (column == this.terminateButtonIndex) {
            label.setText("");
            session = (AbstractSession)value;
            boolean allowedToTerminate = ActiveSessionTable.canTerminateSession(this.listener, session, row);
            if (allowedToTerminate) {
                if (this.hoverRow == row) {
                    label.setIcon(this.hoverIcon);
                } else {
                    label.setIcon(this.nonHoverIcon);
                }
            } else {
                label.setIcon(null);
            }
        }
        if (column == 1 && value instanceof Long) {
            label.setText(this.timeFormat.getFormattedTime((Long)value));
        } else if (column == 2 && value instanceof Long) {
            long v = (Long)value;
            if (v == 255L) {
                label.setText(Language.get("COLOUR_FULL"));
            } else if (v == 0L) {
                label.setText("");
            }
        } else if (column == 3 && value instanceof Long) {
            long v = (Long)value;
            if (v == 0L) {
                label.setText("");
            } else {
                label.setText(label.getText() + " fps");
            }
        }
        switch (column) {
            case 0: {
                label.setForeground(UIManager.getColor("Label.foreground"));
                label.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                label.setForeground(UIManager.getColor("Label.foreground"));
                label.setHorizontalAlignment(4);
                break;
            }
            default: {
                label.setHorizontalAlignment(0);
                label.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            }
        }
        if (column == this.terminateButtonIndex) {
            label.setHorizontalAlignment(4);
        }
        return label;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setBackground(this.background);
        super.paintComponent(g);
    }

    public void setHoverRow(int row) {
        this.hoverRow = row;
    }

    public int[] getMinColumnSizes() {
        return new int[]{0, 0, 0, 0, 0, this.hoverIcon.getIconWidth() + 2};
    }

    public int[] getMaxColumnSizes() {
        return new int[]{-1, -1, 70, 70, 120, this.hoverIcon.getIconWidth() + 2};
    }
}

