/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.contents.table.MachineTableColumns;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class MachineTableHeader
extends JPanel
implements ComponentListener,
MachineTableColumns.MachineColumnPainter {
    public MachineTableHeader() {
        this.setBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, AccessStyle.GROUP_TITLE_BORDER_TOP));
        this.addComponentListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = SimpleHelpLookAndFeel.scale(20);
        return size;
    }

    @Override
    public void paintComponent(Graphics g) {
        MachineTableColumns.setAvailableWidth(this.getWidth());
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setFont(AccessStyle.HEADER_TITLE_FONT);
        g2d.setColor(AccessStyle.HEADER_TITLE_COLOR);
        int width = super.getWidth();
        int height = super.getHeight();
        MachineTableColumns.callPaintMethods(g, width, height, this, false);
    }

    private void drawTextCentered(Graphics g, String string, int memCenter, int heightTotal) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        int hgt = heightTotal - (heightTotal - metrics.getAscent()) / 2;
        int adv = metrics.stringWidth(string);
        g.drawString(string, memCenter - adv / 2, hgt);
    }

    private void drawText(Graphics g, String string, int x, int heightTotal) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        int hgt = heightTotal - (heightTotal - metrics.getAscent()) / 2;
        int adv = metrics.stringWidth(string);
        g.drawString(string, x, hgt);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        MachineTableColumns.setAvailableWidth(this.getWidth());
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void paintIP(Graphics g, int width, int height) {
        this.drawText(g, Language.get("IP"), width + MachineTableColumns.ipCenter - MachineTableColumns.IP_WIDTH / 2, height);
    }

    @Override
    public void paintWANIP(Graphics g, int width, int height) {
        this.drawText(g, Language.get("WAN"), width + MachineTableColumns.wanIpCenter - MachineTableColumns.WANIP_WIDTH / 2, height);
    }

    @Override
    public void paintHostname(Graphics g, int width, int height) {
        this.drawText(g, Language.get("HOSTNAME"), width + MachineTableColumns.hostnameCenter - MachineTableColumns.HOSTNAME_WIDTH / 2, height);
    }

    @Override
    public void paintUsername(Graphics g, int width, int height) {
        this.drawText(g, Language.get("USERNAME"), width + MachineTableColumns.usernameCenter - MachineTableColumns.USERNAME_WIDTH / 2, height);
    }

    @Override
    public void paintGraphs(Graphics g, int width, int height) {
        this.drawTextCentered(g, Language.get("MEMORY_ABBREV"), width + MachineTableColumns.memCenter, height);
        this.drawTextCentered(g, Language.get("CPU_ABBREV"), width + MachineTableColumns.cpuCenter, height);
    }

    @Override
    public void paintOS(Graphics g, int width, int height, boolean isSelected) {
        this.drawTextCentered(g, Language.get("OPERATING_SYSTEM_ABBREV"), width + MachineTableColumns.osCenter, height);
    }

    @Override
    public void paintStatus(Graphics g, int width, int height) {
        this.drawTextCentered(g, Language.get("STATUS"), width + MachineTableColumns.statusCenter, height);
    }

    @Override
    public void paintMachineName(Graphics g, int width, int height) {
        this.drawText(g, Language.get("MACHINE_NAME"), 5, height);
    }

    @Override
    public void paintAlert(Graphics g, int width, int height) {
        this.drawTextCentered(g, Language.get("ALERTS"), width + MachineTableColumns.alertsCenter, height);
    }
}

