/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.grid;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.contents.ui.MachineStatusLabel;
import com.aem.shelp.tech.access.contents.ui.StatusIcon;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.customer.OSIconLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import utils.swing.MiniStatGraph;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;

public class GridMachineRenderer
extends JComponent {
    public static final int HEIGHT = SimpleHelpLookAndFeel.scale(240);
    public static final int WIDTH = (int)((double)HEIGHT / 1.2);
    public static final int PADDING = SimpleHelpLookAndFeel.scale(4);
    private static final int BORDER_WIDTH = 1;
    private static final Rectangle2D BORDER_RECTANGLE = new Rectangle2D.Float(PADDING, PADDING, WIDTH - 2 * PADDING, HEIGHT - 2 * PADDING);
    private static final Rectangle2D INNER_RECTANGLE = new Rectangle2D.Float(PADDING + 1, PADDING + 1, WIDTH - 2 * PADDING - 1, HEIGHT - 2 * PADDING - 1);
    private Font smallFont = new Font("SansSerif", 0, SimpleHelpLookAndFeel.scale(10));
    private BasicStroke borderStroke = new BasicStroke(1.0f);
    private BasicStroke borderStrokeLarger = new BasicStroke(3.0f);
    private Machine machine;
    private MachineTreeModel machineModel;
    MiniStatGraph cpu = new MiniStatGraph(AccessStyle.MINISTAT_BG, MiniStatGraph.GREEN, 100.0);
    MiniStatGraph mem = new MiniStatGraph(AccessStyle.MINISTAT_BG, MiniStatGraph.BLUE, 100.0);
    private ListSelectionModel selectionModel;
    private int machineIndex;
    private MachineStatusLabel statusLabel = new MachineStatusLabel();
    private TechGroupPermissions permissions;
    private static final Icon DEFAULT_SCREEN = ImageLoader.getImageIcon("images/svg/technology/screen.svg,96");
    private static final Icon DEFAULT_SCREEN_DISABLED = ImageLoader.getImageIconDisabled("images/svg/technology/screen.svg,96");

    public GridMachineRenderer(ListSelectionModel selectionModel, TechGroupPermissions permissions) {
        this.setSize(WIDTH, HEIGHT);
        this.selectionModel = selectionModel;
        this.permissions = permissions;
    }

    public void setMachineModel(MachineTreeModel machineModel) {
        this.machineModel = machineModel;
    }

    public void initRendererFor(int index, Machine machine) {
        this.machine = machine;
        this.machineIndex = index;
    }

    private static Dimension getScaledImageSize(Image sourceImage, int maxWidth, int maxHeight) {
        int imageWidth = sourceImage.getWidth(null);
        int imageHeight = sourceImage.getHeight(null);
        if (imageWidth < maxWidth && imageHeight < maxHeight) {
            return new Dimension(imageWidth, imageHeight);
        }
        double ratio = (double)imageWidth / (double)imageHeight;
        if (imageWidth > maxWidth) {
            int newWidth = maxWidth;
            int newHeight = (int)((double)newWidth / ratio);
            if (newWidth <= maxWidth && newHeight <= maxHeight) {
                return new Dimension(newWidth, newHeight);
            }
        }
        int newHeight = maxHeight;
        int newWidth = (int)((double)newHeight * ratio);
        return new Dimension(newWidth, newHeight);
    }

    @Override
    public void paintComponent(Graphics g) {
        int iconHeight;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        MachineInfo info = null;
        if (this.machine.isAvailable()) {
            info = this.machine.getMachineInfo();
        }
        if (this.machine.isAvailable()) {
            g.setColor(AccessStyle.MACHINE_BACKGROUND);
        } else {
            g.setColor(AccessStyle.MACHINE_BACKGROUND_DISABLED);
        }
        g2d.fill(INNER_RECTANGLE);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D original2D = g2d;
        g = g.create((int)INNER_RECTANGLE.getX(), (int)INNER_RECTANGLE.getY(), (int)INNER_RECTANGLE.getWidth(), (int)INNER_RECTANGLE.getHeight());
        g2d = (Graphics2D)g;
        int iHEIGHT = (int)INNER_RECTANGLE.getHeight();
        int iWIDTH = (int)INNER_RECTANGLE.getWidth();
        Image screen = null;
        int maxWidth = iWIDTH;
        int maxHeight = SimpleHelpLookAndFeel.scale(118);
        boolean haveScreenshot = false;
        boolean drawDisabledScreen = false;
        if (this.permissions.canViewScreenshots() && this.machine.isAvailable() && info != null) {
            Image cachedScreen = (Image)info.getSmallScreenImage();
            if (cachedScreen != null) {
                screen = cachedScreen;
            } else {
                byte[] screenData = info.getSmallScreenJpeg();
                if (screenData != null && screenData.length > 0) {
                    try {
                        screen = ImageIO.read(new ByteArrayInputStream(screenData));
                        info.setSmallScreenImage(screen);
                    }
                    catch (Throwable t) {
                        screen = null;
                    }
                }
            }
            if (screen != null) {
                haveScreenshot = true;
            }
            drawDisabledScreen = false;
        } else {
            drawDisabledScreen = true;
        }
        Dimension size = screen != null ? GridMachineRenderer.getScaledImageSize(screen, maxWidth, maxHeight) : new Dimension(DEFAULT_SCREEN.getIconWidth(), DEFAULT_SCREEN.getIconHeight());
        int xoffset = (iWIDTH - size.width) / 2;
        int yoffset = 0;
        if (haveScreenshot) {
            g2d.drawImage(screen, xoffset, yoffset, size.width, size.height, null);
        } else {
            Icon icon = DEFAULT_SCREEN;
            if (drawDisabledScreen) {
                icon = DEFAULT_SCREEN_DISABLED;
            }
            icon.paintIcon(this, g2d, xoffset, yoffset);
        }
        int yTopOffset = 0;
        FontMetrics fontMetrics = g.getFontMetrics(this.smallFont);
        String name = this.machine.getMachineName().getName();
        Rectangle2D nameBounds = fontMetrics.getStringBounds(name, g);
        g.setColor(Color.DARK_GRAY);
        g.setFont(this.smallFont);
        int X = iWIDTH / 2 - (int)(nameBounds.getWidth() / 2.0);
        if (X >= 0) {
            g.drawString(name, X, PADDING * 6 + HEIGHT / 2);
            yTopOffset = PADDING * 3 + iHEIGHT / 2 + PADDING;
        } else {
            float overFlow = -X * 2;
            int characters = name.length();
            int wrapIndex = (int)((float)characters * ((float)iWIDTH / ((float)iWIDTH + overFlow)));
            String name1 = name.substring(0, --wrapIndex).trim();
            String name2 = name.substring(wrapIndex).trim();
            Rectangle2D nameBounds1 = fontMetrics.getStringBounds(name1, g);
            Rectangle2D nameBounds2 = fontMetrics.getStringBounds(name2, g);
            int X1 = iWIDTH / 2 - (int)(nameBounds1.getWidth() / 2.0);
            int X2 = iWIDTH / 2 - (int)(nameBounds2.getWidth() / 2.0);
            if (X2 < 0) {
                overFlow = -X2 * 2;
                characters = name2.length();
                wrapIndex = (int)((float)characters * ((float)iWIDTH / ((float)iWIDTH + overFlow)));
                name2 = name2.substring(0, wrapIndex -= 5).trim() + "...";
                nameBounds2 = fontMetrics.getStringBounds(name2, g);
                X2 = iWIDTH / 2 - (int)(nameBounds2.getWidth() / 2.0);
            }
            g.drawString(name1, X1, PADDING * 3 + iHEIGHT / 2);
            g.drawString(name2, X2, (int)((double)(PADDING * 4 + iHEIGHT / 2) + nameBounds2.getHeight()));
            yTopOffset = (int)((double)(PADDING * 3 + iHEIGHT / 2) + nameBounds2.getHeight() + (double)PADDING);
        }
        int gPadding = 2;
        int gHeight = iHEIGHT / 5;
        int yBottomOffset = iHEIGHT - gPadding - gHeight;
        if (info != null && this.permissions.canViewMetrics()) {
            if (info.allowMonitoring()) {
                int gWidth = (iWIDTH - gPadding * 3) / 2;
                this.cpu.paint(g, this.machine.getMachineInfo().getCpu(), gPadding, iHEIGHT - gPadding - gHeight, gWidth, gHeight, true);
                this.mem.paint(g, this.machine.getMachineInfo().getMem(), gPadding + gPadding + gWidth, iHEIGHT - gPadding - gHeight, gWidth, gHeight, true);
            } else if (this.machine.supportsMonitoring()) {
                Icon icon = ImageLoader.getImageIcon("images/svg/general/accessdenied.svg,16");
                String text = Language.get("MONITOR_DENIED");
                FontMetrics fm = g.getFontMetrics();
                iconHeight = icon != null ? icon.getIconHeight() : fm.getHeight();
                int middleIconLine = iHEIGHT - gPadding - gHeight / 2;
                int baseTextLine = middleIconLine + fm.getDescent() + 1;
                int totalWidth = SwingUtilities.computeStringWidth(fm, text) + icon.getIconWidth();
                int iconX = iWIDTH / 2 - totalWidth / 2;
                g.setColor(AccessStyle.GROUP_TITLE_FONT_COLOR);
                g.setFont(this.smallFont);
                g.drawString(text, iconX + icon.getIconWidth() + PADDING, baseTextLine);
                icon.paintIcon(null, g, iconX, middleIconLine - iconHeight / 2);
            }
        }
        this.statusLabel.setMachine(this.machine);
        StatusIcon icon = (StatusIcon)this.statusLabel.getIcon();
        String text = this.statusLabel.getMachineStateText();
        FontMetrics fm = g.getFontMetrics();
        iconHeight = icon != null ? icon.getIconHeight() : fm.getHeight();
        int middleIconLine = yBottomOffset - iconHeight / 2 - 2 * PADDING;
        int baseTextLine = middleIconLine + fm.getDescent() + 1;
        int totalWidth = SwingUtilities.computeStringWidth(fm, text) + icon.getIconWidth();
        int iconX = (int)INNER_RECTANGLE.getX() + 2 * PADDING;
        StatusIcon.renderStatus(g2d, this.machine, iconX, middleIconLine);
        g.setColor(Color.DARK_GRAY);
        g.setFont(this.smallFont);
        g.drawString(text, iconX + icon.getIconWidth(), baseTextLine);
        Icon osIcon = info != null ? OSIconLoader.getOSIcon(this.machine.getOsBaseType(), this.machine.getOsVariant(), this.machine.getOsSummary()) : OSIconLoader.getOSIconDisabled(this.machine.getOsBaseType(), this.machine.getOsVariant(), this.machine.getOsSummary());
        if (osIcon != null) {
            osIcon.paintIcon(null, g2d, (int)(INNER_RECTANGLE.getWidth() - (double)osIcon.getIconWidth()) - PADDING, middleIconLine - osIcon.getIconHeight() / 2);
        }
        Icon alertIcon = ImageLoader.getImageIcon("images/svg/alert-flags/yellow.svg,20");
        if (this.machine.getMachineInfo() != null && this.machine.getMachineInfo().hasTriggeredAlerts()) {
            alertIcon.paintIcon(null, g2d, (int)(INNER_RECTANGLE.getWidth() - (double)osIcon.getIconWidth()) - 2 * PADDING - osIcon.getIconWidth(), middleIconLine - alertIcon.getIconHeight() / 2);
        }
        if (this.selectionModel.isSelectionEmpty() || !this.selectionModel.isSelectedIndex(this.machineIndex)) {
            original2D.setColor(AccessStyle.MACHINE_BORDER);
            original2D.setStroke(this.borderStroke);
            original2D.draw(BORDER_RECTANGLE);
        } else {
            original2D.setColor(AccessStyle.MACHINE_SELECTED_BORDER_LIGHT);
            original2D.setStroke(this.borderStrokeLarger);
            original2D.draw(BORDER_RECTANGLE);
        }
        g2d.dispose();
    }
}

