/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access;

import com.aem.sgateway.ui.SimpleMachineGroupList;
import com.aem.shelp.common.Language;
import com.aem.shelp.mdupload.fs.FSPane;
import com.aem.shelp.mdupload.fs.TechClientFS;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;

public class MachineFileChooser {
    FSPane fsPanel = new FSPane(true);

    public static String launchMachineFileChooser(RootPaneContainer rpc, Machine[] machines, TechClient tc) {
        SimpleMachineGroupList groupList = new SimpleMachineGroupList();
        ArrayList<String[]> groupsToShow = new ArrayList<String[]>();
        ArrayList<String> machineNames = new ArrayList<String>();
        for (Machine m : machines) {
            groupsToShow.add(m.getName().getGroup());
            machineNames.add(m.getName().getName());
        }
        groupList.setGroupsToShow(groupsToShow, machineNames, null);
        groupList.getRootComponent().setPreferredSize(new Dimension(500, 300));
        if (0 == JOptionPane.showConfirmDialog(rpc.getRootPane(), groupList.getRootComponent(), Language.get("MACHINE_FILE_CHOOSE"), 2, -1, null)) {
            String selectedMachine = groupList.getSelection();
            for (Machine machine : machines) {
                if (!machine.getMachineName().toString().equals(selectedMachine)) continue;
                return MachineFileChooser.launchMachineFileChooser(rpc, machine, tc, false);
            }
        }
        return null;
    }

    public static String launchMachineFileChooser(RootPaneContainer rpc, Machine machine, TechClient tc, boolean glass) {
        FSPane fsPanel = new FSPane(true);
        fsPanel.setPreferredSize(new Dimension(500, 300));
        fsPanel.setRemoteOS(machine.getOsBaseType());
        fsPanel.initUI(rpc, new TechClientFS(tc, machine.getMachineID()), null, null);
        if (glass ? SHGlassOptionPane.showConfirmDialog(rpc, fsPanel, Language.get("MACHINE_FILE_CHOOSE"), Language.get("ACCEPT")) : 0 == JOptionPane.showConfirmDialog(rpc.getRootPane(), fsPanel, Language.get("MACHINE_FILE_CHOOSE"), 2, -1, null)) {
            return fsPanel.getSelectedFileOrFolder(true);
        }
        return null;
    }
}

