/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.contents.ContentsMetrics;
import com.aem.shelp.tech.access.contents.grid.GridGroupList;
import com.aem.shelp.tech.access.contents.table.TableGroupList;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineModelChangeListener;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.access.model.machine.filters.TextMachineFilter;
import com.aem.shelp.tech.access.model.subgroups.FilterResultsGroup;
import com.aem.shelp.tech.access.utils.MachineSelection;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupsList;
import com.aem.shelp.tech.hierarchy.utils.TreeSelection;
import com.aem.shelp.tech.reporting.ReportingClient;
import com.aem.shelp.util.swing.ShSearchTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import utils.progtools.arrays.ArrayUtils;
import utils.string.SearchTermSplitter;
import utils.swing.SwingUtil;
import utils.swing.components.JIconTextField;
import utils.swing.components.JSearchTextField;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class MachineContentsPanel
implements MessageFieldHandler.FilterListener,
MachineModelChangeListener,
ActionListener {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private AbstractGroupsList<MachineGroup, Machine> currentContentsPanel;
    private AbstractGroupsList<MachineGroup, Machine> machineGrid;
    private AbstractGroupsList<MachineGroup, Machine> machineTable;
    private CardLayout contentsCardLayout;
    private AccessPanelListener accessPanelListener;
    private MachineTreeModel machineModel;
    private JPanel cardPanel;
    private GbPanel buttonPanel;
    private FilterSetter delayedFilterSetter = null;
    private final Object setFilterLock = new Object();
    private ButtonListener buttonListener = new ButtonListener();
    private JButton toggleTableGridButton;
    private JToggleButton toggleDetailsButton;
    private JButton launchProfilePopup;
    private JButton generateReportButton;
    private boolean isTableSelected = true;
    private JSearchTextField filterField;
    private MachineGroup resultsGroup;
    private TextMachineFilter searchFilter;
    private MachineGroup[] selectedGroups;
    private boolean isDetailsPanelVisible = true;
    private MachineSelection selection;

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public MachineContentsPanel(MachineTreeModel machineInterface, AccessPanelListener listener) {
        this.accessPanelListener = listener;
        this.machineModel = machineInterface;
        this.initUI();
    }

    public void setDetailsPanelIsShowing(boolean isDetailsPanelVisible) {
        this.isDetailsPanelVisible = isDetailsPanelVisible;
        this.toggleDetailsButton.setSelected(isDetailsPanelVisible);
        this.setDetailsButtonTooltip();
    }

    private void initContentsMetrics() {
    }

    public void updateUIWithMetrics(ContentsMetrics metrics) {
        this.generateReportButton.setEnabled(metrics.machineCount > 0);
        this.generateReportButton.repaint();
    }

    private void initUI() {
        this.initContentsMetrics();
        this.resultsGroup = FilterResultsGroup.newResultsGroup(Language.get("SEARCH_RESULTS"));
        this.searchFilter = new TextMachineFilter(this.resultsGroup);
        this.machineGrid = new GridGroupList(this.accessPanelListener);
        this.machineGrid.initUI(this.machineModel, this.machineModel.getRootGroups());
        this.machineModel.addModelChangeListener(this.machineGrid);
        this.machineTable = new TableGroupList(this.accessPanelListener);
        this.machineModel.addModelChangeListener(this.machineTable);
        this.contentsCardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.contentsCardLayout);
        this.cardPanel.add((Component)this.machineGrid.getRootComponent(), "GRID");
        this.cardPanel.add((Component)this.machineTable.getRootComponent(), "TABLE");
        this.currentContentsPanel = this.machineTable;
        this.initButtonPanel();
        this.rootComponent.add((Component)this.cardPanel, "Center");
        this.rootComponent.add((Component)this.buttonPanel, "North");
        this.toggleTableGridButton.addActionListener(this.buttonListener);
        this.toggleDetailsButton.addActionListener(this.buttonListener);
        this.launchProfilePopup.addActionListener(this.buttonListener);
        this.generateReportButton.addActionListener(this.buttonListener);
        this.machineTable.initUI(this.machineModel, this.machineModel.getRootGroups());
        this.setSelectedMachines(MachineSelection.EMPTY);
    }

    private void initButtonPanel() {
        this.buttonPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.buttonPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARK);
        MatteBorder outer = SHBorderFactory.createMatteBorder(0, 0, 1, 0, AccessStyle.GROUP_TITLE_BORDER_TOP);
        Border inner = SHBorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.buttonPanel.setBorder(SHBorderFactory.createCompoundBorder(outer, inner));
        this.toggleTableGridButton = new JButton(ImageLoader.getImageIcon("images/svg/general/grid.svg,16"));
        this.toggleDetailsButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/dialogs/information-square-green.svg,16"));
        this.launchProfilePopup = new JButton(ImageLoader.getImageIcon(Icons.ACCESS_LAUNCH_PROFILE));
        this.launchProfilePopup.setToolTipText(Language.get("LAUNCH_PROFILE_TOOLTIP"));
        this.generateReportButton = new JButton(ImageLoader.getImageIcon("images/svg/arrows/share.svg,16"));
        this.generateReportButton.setToolTipText(Language.get("GENERATE_REPORT_TOOLTIP"));
        this.generateReportButton.setEnabled(false);
        this.toggleDetailsButton.setSelected(true);
        this.setDetailsButtonTooltip();
        this.isTableSelected = true;
        this.updateSelectedView();
        this.filterField = new ShSearchTextField();
        this.filterField.setFilterListener(this);
        this.filterField.addIconClickListener(new JIconTextField.IconClickListener(){

            @Override
            public void iconClicked(String id) {
                if (id.equals("SEARCH") && MachineContentsPanel.this.filterField.getText().length() > 0) {
                    MachineGroup groupToSave = MachineContentsPanel.this.resultsGroup;
                    MachineContentsPanel.this.resultsGroup = FilterResultsGroup.newResultsGroup(Language.get("SEARCH_RESULTS"));
                    MachineContentsPanel.this.machineModel.moveGroupToFinalChild(groupToSave);
                    MachineContentsPanel.this.machineModel.renameGroup(groupToSave, MachineContentsPanel.this.filterField.getText().trim());
                    if (groupToSave instanceof FilterResultsGroup) {
                        ((FilterResultsGroup)groupToSave).setTemporary(false);
                    }
                    MachineContentsPanel.this.filterField.setText(null);
                    MachineContentsPanel.this.filterField.changeIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), "SEARCH");
                    MachineContentsPanel.this.filterField.repaint();
                    MachineContentsPanel.this.accessPanelListener.renameSelectedNode(groupToSave);
                    MachineContentsPanel.this.machineModel.notifyFilterProcessorChange();
                }
            }
        });
        this.filterField.setSize(SimpleHelpLookAndFeel.scale(250), SimpleHelpLookAndFeel.scale(26));
        this.filterField.setPreferredSize(this.filterField.getSize());
        SwingUtil.setWidth(this.filterField, this.filterField.getSize().width);
        int X = 0;
        this.buttonPanel.add(this.toggleTableGridButton, X++, 0, 1, 1, 0, 1, 17, 0, new Insets(3, 3, 3, 3));
        this.buttonPanel.add(this.toggleDetailsButton, X++, 0, 1, 1, 0, 1, 17, 0, new Insets(3, 3, 3, 3));
        if (Switches.SH_raAppProfileShortcut) {
            this.buttonPanel.add(this.launchProfilePopup, X++, 0, 1, 1, 0, 1, 17, 0, new Insets(3, 3, 3, 3));
        }
        if (Switches.SH_remoteAccessReport) {
            this.buttonPanel.add(this.generateReportButton, X++, 0, 1, 1, 0, 1, 17, 0, new Insets(3, 3, 3, 3));
        }
        this.buttonPanel.add(this.filterField, X++, 0, 1, 1, 1, 1, 13, 0, new Insets(2, 0, 2, 3));
    }

    public void setSelectedGroups(MachineGroup[] selectedGroups) {
        if (Arrays.equals(selectedGroups, this.selectedGroups)) {
            return;
        }
        this.selectedGroups = selectedGroups;
        this.setSelectedMachines(MachineSelection.EMPTY);
        Runnable work = new Runnable(){

            @Override
            public void run() {
                MachineContentsPanel.this.currentContentsPanel.initUI(MachineContentsPanel.this.machineModel, MachineContentsPanel.this.selectedGroups);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            work.run();
        } else {
            SwingUtilities.invokeLater(work);
        }
    }

    public void setSelectedGroup(MachineGroup selectedGroup) {
        this.setSelectedGroups(new MachineGroup[]{selectedGroup});
    }

    public void updateSelectedView() {
        this.currentContentsPanel.setVisible(false);
        if (!this.isTableSelected) {
            this.contentsCardLayout.show(this.cardPanel, "GRID");
            this.currentContentsPanel = this.machineGrid;
            this.toggleTableGridButton.setIcon(ImageLoader.getImageIcon("images/svg/general/table.svg,16"));
            this.toggleTableGridButton.setToolTipText(Language.get("SWITCH_TABLE_VIEW"));
            this.toggleTableGridButton.repaint();
            this.currentContentsPanel.initUI(this.machineModel, this.selectedGroups);
        } else {
            this.contentsCardLayout.show(this.cardPanel, "TABLE");
            this.currentContentsPanel = this.machineTable;
            this.toggleTableGridButton.setIcon(ImageLoader.getImageIcon("images/svg/general/grid.svg,16"));
            this.toggleTableGridButton.setToolTipText(Language.get("SWITCH_GRID_VIEW"));
            this.toggleTableGridButton.repaint();
            this.currentContentsPanel.initUI(this.machineModel, this.selectedGroups);
        }
        this.currentContentsPanel.setVisible(true);
    }

    public void setDetailsButtonTooltip() {
        if (this.toggleDetailsButton.isSelected()) {
            this.toggleDetailsButton.setToolTipText(Language.get("HIDE_DETAILS_TOOLTIP"));
        } else {
            this.toggleDetailsButton.setToolTipText(Language.get("SHOW_DETAILS_TOOLTIP"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFilter(String filter, boolean immediately) {
        Object object = this.setFilterLock;
        synchronized (object) {
            if (this.delayedFilterSetter != null) {
                this.delayedFilterSetter.setFilter(filter, immediately);
            } else {
                this.delayedFilterSetter = new FilterSetter(filter, immediately);
            }
        }
    }

    public void clearSearchResults() {
        TreeGroup[] groupsIn = (MachineGroup[])this.machineModel.getGroupsIn(this.resultsGroup);
        if (groupsIn != null) {
            this.machineModel.removeGroups(groupsIn);
        }
    }

    public void groupsRemoved(MachineGroup parentGroup, MachineGroup[] removedChildren, int[] removedIndices) {
        if (this.isSelectedGroup(parentGroup)) {
            this.setSelectedGroups(this.selectedGroups);
        }
    }

    public void groupsAdded(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
        if (this.isSelectedGroup(parentGroup)) {
            this.setSelectedGroups(this.selectedGroups);
        }
    }

    public void groupsChanged(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    private boolean isSelectedGroup(MachineGroup group) {
        if (this.selectedGroups == null || group == null) {
            return false;
        }
        for (MachineGroup selectedGroup : this.selectedGroups) {
            if (selectedGroup.equals(group)) {
                return true;
            }
            if (!this.isSelectedGroup((MachineGroup)group.getParent())) continue;
            return true;
        }
        return false;
    }

    public void machinesChanged(MachineGroup parent, Machine[] inserted, Machine[] removed, Machine[] updated, Machine.MachineChanges updateResults) {
    }

    @Override
    public void sessionsAdded(MachineGroup parentGroup, Machine machine, AbstractSession[] addedSessions) {
    }

    @Override
    public void sessionsRemoved(MachineGroup parentGroup, Machine machine, AbstractSession[] removedSessions) {
    }

    public void setSelectedMachines(TreeSelection<MachineGroup, Machine> selection) {
        this.selection = (MachineSelection)selection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void filterProcessorChanged() {
    }

    public boolean isMachineSelected(Machine machine) {
        return this.selection.getMachineCount() == 1 && ((Machine[])this.selection.getAllElements())[0].equals(machine);
    }

    public void ensureMachineIsSelected(MachineGroup group, Machine machine) {
        this.accessPanelListener.setSelectedGroup(null, group);
        this.currentContentsPanel.ensureMachineIsSelected(group, machine);
    }

    public void debugSetSearchString(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MachineContentsPanel.this.filterField.setText(s);
                MachineContentsPanel.this.setFilter(s, true);
            }
        });
    }

    class FilterSetter
    extends Thread {
        private long endTime;
        private String filter;

        public FilterSetter(String filter, boolean immediately) {
            super("FilterSetter");
            this.setFilter(filter, immediately);
            this.start();
        }

        public void setEndTime(long time) {
            this.endTime = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFilter(String filter, boolean immediately) {
            Object object = MachineContentsPanel.this.setFilterLock;
            synchronized (object) {
                this.filter = filter;
                this.endTime = !immediately ? System.currentTimeMillis() + 500L : System.currentTimeMillis();
                MachineContentsPanel.this.setFilterLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String[] newFilter = null;
            Object object = MachineContentsPanel.this.setFilterLock;
            synchronized (object) {
                while (System.currentTimeMillis() < this.endTime) {
                    try {
                        MachineContentsPanel.this.setFilterLock.wait(this.endTime - System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.filter != null && this.filter.trim().length() != 0) {
                    if (Switches.SH_handleQuotesInAccessFilter) {
                        SearchTermSplitter sts = new SearchTermSplitter();
                        ArrayList<String> terms = sts.splitTerms(this.filter);
                        newFilter = new String[terms.size()];
                        newFilter = terms.toArray(newFilter);
                    } else {
                        newFilter = this.filter.toLowerCase().split("\\s+");
                        for (int i = 0; i < newFilter.length; ++i) {
                            newFilter[i] = newFilter[i].trim();
                        }
                    }
                }
            }
            MachineContentsPanel.this.clearSearchResults();
            if (newFilter == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MachineContentsPanel.this.machineModel.removeFilter(MachineContentsPanel.this.resultsGroup);
                    }
                });
                MachineContentsPanel.this.filterField.changeIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), "SEARCH");
                MachineContentsPanel.this.filterField.repaint();
                MachineContentsPanel.this.delayedFilterSetter = null;
                return;
            }
            final String[] finalFilter = newFilter;
            MachineContentsPanel.this.delayedFilterSetter = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MachineContentsPanel.this.filterField.changeIcon(ImageLoader.getImageIcon("images/svg/general/star.svg,16"), "SEARCH");
                    MachineContentsPanel.this.filterField.repaint();
                    MachineContentsPanel.this.machineModel.removeAllGroupsAndMachines(MachineContentsPanel.this.resultsGroup);
                    MachineContentsPanel.this.searchFilter.setRoot(MachineContentsPanel.this.resultsGroup);
                    MachineContentsPanel.this.searchFilter.setConjunctionFilters(finalFilter);
                    MachineContentsPanel.this.machineModel.addFilterProcessor(MachineContentsPanel.this.searchFilter, MachineContentsPanel.this.resultsGroup, true);
                    MachineContentsPanel.this.accessPanelListener.setSelectedGroups(MachineContentsPanel.this, new MachineGroup[]{MachineContentsPanel.this.resultsGroup});
                    MachineContentsPanel.this.currentContentsPanel.initUI(MachineContentsPanel.this.machineModel, MachineContentsPanel.this.selectedGroups);
                }
            });
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == MachineContentsPanel.this.toggleTableGridButton) {
                MachineContentsPanel.this.isTableSelected = !MachineContentsPanel.this.isTableSelected;
                MachineContentsPanel.this.updateSelectedView();
            } else if (source == MachineContentsPanel.this.generateReportButton) {
                new Thread("ReportRequestThread"){

                    @Override
                    public void run() {
                        boolean reportOnAllMachines = false;
                        boolean reportOnOnlineMachines = false;
                        boolean reportOnOfflineMachines = false;
                        ArrayList<String> machineIDs = new ArrayList<String>();
                        if (MachineContentsPanel.this.selection == null || ((MachineContentsPanel)MachineContentsPanel.this).selection.machineCount == 0) {
                            reportOnAllMachines = ArrayUtils.contains(MachineContentsPanel.this.selectedGroups, MachineContentsPanel.this.machineModel.getAvailableMachinesGroup());
                            reportOnOnlineMachines = ArrayUtils.contains(MachineContentsPanel.this.selectedGroups, MachineContentsPanel.this.machineModel.getOnlineFilterGroup());
                            reportOnOfflineMachines = ArrayUtils.contains(MachineContentsPanel.this.selectedGroups, MachineContentsPanel.this.machineModel.getOfflineFilterGroup());
                            if (!(reportOnAllMachines || reportOnOnlineMachines || reportOnOfflineMachines)) {
                                for (MachineGroup group : MachineContentsPanel.this.selectedGroups) {
                                    Iterator descendentElements = MachineContentsPanel.this.machineModel.getDescendentElements(group);
                                    while (descendentElements.hasNext()) {
                                        machineIDs.add(((Machine)descendentElements.next()).getMachineID());
                                    }
                                }
                            }
                        } else {
                            for (Machine m : MachineContentsPanel.this.selection) {
                                machineIDs.add(m.getMachineID());
                            }
                        }
                        ReportingClient.showAccessPanelReportDialog(SwingUtil.getRootPaneContainer(MachineContentsPanel.this.rootComponent), MachineContentsPanel.this.accessPanelListener.getTechClient(), reportOnAllMachines, reportOnOnlineMachines, reportOnOfflineMachines, machineIDs.toArray(new String[0]));
                    }
                }.start();
            } else if (source == MachineContentsPanel.this.launchProfilePopup) {
                MachineContentsPanel.this.accessPanelListener.showPreconfiguredAccessApps();
            } else if (source == MachineContentsPanel.this.toggleDetailsButton) {
                boolean shouldShowDetails = MachineContentsPanel.this.toggleDetailsButton.isSelected();
                MachineContentsPanel.this.accessPanelListener.setDetailsPanelVisiblity(shouldShowDetails);
                MachineContentsPanel.this.setDetailsButtonTooltip();
            }
        }
    }
}

