/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access;

import com.aem.CentralDebugging;
import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.sdesktop.SessionPerformance;
import com.aem.sgateway.common.AbstractServiceUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.PC;
import com.aem.shelp.common.properties.LocalProperties;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.common.properties.WindowBoundsUtil;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.common.toolbox.ToolBoxStatus;
import com.aem.shelp.proxy.MiniClient;
import com.aem.shelp.proxy.common.ToolBoxConstants;
import com.aem.shelp.proxy.techclient.MachineResponseListener;
import com.aem.shelp.proxy.techclient.MonitoringOnlyException;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.NetAdapter;
import com.aem.shelp.tech.TechUIInterfaceAPI;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.MachineContentsPanel;
import com.aem.shelp.tech.access.MachineDetailsPanel;
import com.aem.shelp.tech.access.MachineHierarchyPanel;
import com.aem.shelp.tech.access.MachineUIMetadata;
import com.aem.shelp.tech.access.MonitoringRequestThread;
import com.aem.shelp.tech.access.contents.ContentsMetrics;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineModelChangeAdapter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.access.model.machine.filters.RunToolMachineFilter;
import com.aem.shelp.tech.access.model.machine.filters.StopMachineFilter;
import com.aem.shelp.tech.access.model.machine.filters.UpdateMachineFilter;
import com.aem.shelp.tech.access.model.subgroups.IconnedMachineGroup;
import com.aem.shelp.tech.access.model.subgroups.RunToolMachineGroup;
import com.aem.shelp.tech.access.service.ServiceUIListener;
import com.aem.shelp.tech.access.utils.MachineMetadataUtil;
import com.aem.shelp.tech.access.utils.MachineSelection;
import com.aem.shelp.tech.alerts.alerts.model.AlertTreeModel;
import com.aem.shelp.tech.gstarted.MonitoringOnlyUtil;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.tech.hierarchy.model.TreeNodeFilterProcessor;
import com.aem.shelp.tech.hierarchy.utils.TreeSelection;
import com.aem.shelp.tech.portforward.AppTunnelUI;
import com.aem.shelp.tech.portforward.AppTunnelUIRepository;
import com.aem.tests.Testing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import jwrapper.jwutils.test.JWTesting;
import utils.message.Message;
import utils.progtools.MapOfLists;
import utils.progtools.OnDemandThreadPool;
import utils.string.SafeCmp;
import utils.swing.ScaledShadowImagePanel;
import utils.swing.SwingUtil;
import utils.swing.components.animated.arrow.ArrowAnimatedIcon;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ColorUtils;
import utils.swing.images.ImageLoader;
import utils.swing.layout.CardPanel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.HierarchyPanel;
import utils.switches.Switches;

public class AccessPanel
implements AccessPanelListener,
HierarchyPanel.HierarchyResizeListener {
    private final HierarchyPanel rootComponent = new HierarchyPanel(this);
    private final OnDemandThreadPool uiThreadPool = new OnDemandThreadPool("AccessPanel", 2, 1, 5);
    private final Icon computerPadlock = ImageLoader.getImageIcon("images/svg/general/lock.svg,16");
    private final Icon computerIconOk = ImageLoader.getImageIcon("images/svg/general/ok.svg,16");
    private final Icon computerIconError = ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16");
    private final ArrowAnimatedIcon progressBar = new ArrowAnimatedIcon();
    public static boolean TESTING = false;
    public static BufferedImage TEST_THUMB;
    public static BufferedImage TEST_SCREEN;
    private final MachineTreeModel machineModel;
    private final AlertTreeModel alertModel;
    CardPanel detailsCards = new CardPanel();
    private MachineDetailsPanel machineDetailsPanel;
    private MachineContentsPanel machineContentsPanel;
    private TechClient client;
    private MachineHierarchyPanel hierarchyPanel;
    private final TechUIInterfaceAPI techUiInterface;
    public static AccessPanel INSTANCE;
    private static MonitoringRequestThread mrt;
    private boolean bigScreenshotON = false;
    private final Object BIG_SCREEN_LOCK = new Object();
    private BigScreenRequestThread bigScreenRequestThread = null;
    private boolean isBatchSelection = false;
    private SaveXMLThread currentSaveThread = null;
    private final Object SAVE_LOCK = new Object();
    private ToolBox toolBox;

    public JComponent getRootComponent() {
        return this.rootComponent.getRootComponent();
    }

    public AccessPanel(MachineTreeModel machinesModel, AlertTreeModel alertModel, TechUIInterfaceAPI techUiInterface) {
        INSTANCE = this;
        this.machineModel = machinesModel;
        this.alertModel = alertModel;
        this.techUiInterface = techUiInterface;
        mrt = new MonitoringRequestThread();
        mrt.start();
        this.initUI();
        this.machineModel.addModelChangeListener(new SaveStateListener());
        this.rootComponent.setDetailsPanelMinimumHeight(this.machineDetailsPanel.getButtonBarHeight());
    }

    public void setTechClient(TechClient client) {
        this.client = client;
        mrt.setTechClient(client);
        this.machineDetailsPanel.updateUIWithPermissions(client.getPermissions());
        this.hierarchyPanel.updateUIWithPermissions(client.getPermissions());
        new LoadConfigurationThread().start();
    }

    public void testLaunchOneSession() {
        Machine machine;
        ArrayList<Machine> available = new ArrayList<Machine>();
        MachineGroup mg = (MachineGroup)this.machineModel.getAvailableMachinesGroup();
        Iterator it = this.machineModel.getDescendentElements(mg);
        while (it.hasNext()) {
            machine = (Machine)it.next();
            if (!machine.isAvailable()) continue;
            try {
                String name = machine.getMachineName().getName();
                if (!name.toLowerCase().contains("accepttestsessions")) continue;
                System.out.println("[TESTING] adding machine " + name + " to available list");
                available.add(machine);
            }
            catch (Exception exception) {}
        }
        Collections.shuffle(available);
        machine = (Machine)available.get(0);
        System.out.println("[TESTING] Launching session to " + machine.getMachineName());
        this.connectToMachine(machine);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCycleUi() {
        ArrayList<Machine> available = new ArrayList<Machine>();
        MachineGroup mg = (MachineGroup)this.machineModel.getAvailableMachinesGroup();
        Iterator it = this.machineModel.getDescendentElements(mg);
        while (it.hasNext()) {
            Machine machine = (Machine)it.next();
            MachineSelection sel = new MachineSelection();
            sel.addMachines(mg, new Machine[]{machine});
            System.out.println("[TESTING] selecting machine " + machine.getMachineName());
            this.setSelectedElements((Object)this, sel, true);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!machine.isAvailable()) continue;
            System.out.println("[TESTING] adding machine to available list");
            available.add(machine);
        }
        if (Testing.queryTestingBoolean("TEST_TECHUI_CYCLEUI_LAUNCH_ACCESS_SESSIONS")) {
            Collections.shuffle(available);
            for (int i = 0; i < Math.min(2, available.size()); ++i) {
                Machine machine = (Machine)available.get(i);
                System.out.println("[TESTING] Launching session to " + machine.getMachineName());
                JWTesting.reportAttempt("Launch Session", "", 300000);
                this.connectToMachine(machine);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveHierarchyPosition(int unscaledLeft, int unscaledCentre, boolean min, boolean max, boolean isUserResizing) {
        if (CentralDebugging.HIERARCHY_SAVING) {
            System.out.println("[AccessPanel][HierarchySaving] " + unscaledLeft + "," + unscaledCentre + "," + min + "," + max + "," + isUserResizing);
        }
        LocalProperties.INSTANCE.setPropNoSave(LocalProperties.PROP_ACCESS_HIERARCHY, unscaledLeft + "," + unscaledCentre);
        LocalProperties.INSTANCE.setPropAndSaveIn(LocalProperties.PROP_ACCESS_MIN_MAX, min + "," + max, 1000);
        TechProperties.INSTANCE.setPropNoSave(TechProperties.DEPRECATED_PROP_ACCESS_HIERARCHY, unscaledLeft + "," + unscaledCentre);
        TechProperties.INSTANCE.setPropAndSaveIn(TechProperties.DEPRECATED_PROP_ACCESS_MIN_MAX, min + "," + max, 3000);
        if (isUserResizing) {
            this.machineDetailsPanel.userResizing();
        }
    }

    private void loadAndSetHierarchyLayoutSize() {
        String[] sizes;
        String minMax;
        String property;
        String isVisible = TechProperties.INSTANCE.getProp(TechProperties.ACCESS_PANEL_DETAILS_VISIBLE);
        if (isVisible != null && !Boolean.parseBoolean(isVisible)) {
            this.setDetailsPanelVisiblity(false);
        }
        if ((property = LocalProperties.INSTANCE.getProp(LocalProperties.PROP_ACCESS_HIERARCHY)) == null) {
            property = TechProperties.INSTANCE.getProp(TechProperties.DEPRECATED_PROP_ACCESS_HIERARCHY);
        }
        if ((minMax = LocalProperties.INSTANCE.getProp(LocalProperties.PROP_ACCESS_MIN_MAX)) == null) {
            minMax = TechProperties.INSTANCE.getProp(TechProperties.DEPRECATED_PROP_ACCESS_MIN_MAX);
        }
        System.out.println("[AccessPanel] Layout sizes are " + property + " [" + minMax + "]");
        if (property != null && (sizes = property.split(",")).length == 2) {
            try {
                int leftSize = Integer.parseInt(sizes[0]);
                int centreSize = Integer.parseInt(sizes[1]);
                this.rootComponent.setDividerLocations(SimpleHelpLookAndFeel.scale(leftSize), SimpleHelpLookAndFeel.scale(centreSize));
            }
            catch (Throwable t) {
                System.out.println("[AccessPanel] Unable to load hierarchy size configuration '" + property + "'");
            }
        }
        if (minMax != null && (sizes = minMax.split(",")).length == 2) {
            try {
                boolean min = Boolean.parseBoolean(sizes[0]);
                boolean max = Boolean.parseBoolean(sizes[1]);
                max = false;
                this.machineDetailsPanel.setMinMax(min, max);
            }
            catch (Throwable t) {
                System.out.println("[AccessPanel] Unable to load hierarchy size configuration '" + property + "'");
            }
        }
    }

    @Override
    public void setDetailsPanelScrollPaneEnabled(boolean enabled) {
        if (this.rootComponent.getDetailsPanel().getComponentCount() > 0) {
            Component component = this.rootComponent.getDetailsPanel().getComponent(0);
            if (enabled && component instanceof JScrollPane) {
                return;
            }
            if (!enabled && !(component instanceof JScrollPane)) {
                return;
            }
            if (component instanceof JScrollPane) {
                Component view = ((JScrollPane)component).getViewport().getView();
                if (view == null) {
                    view = ((JScrollPane)component).getViewport().getView();
                }
                this.rootComponent.getDetailsPanel().removeAll();
                this.rootComponent.getDetailsPanel().add(view);
            } else {
                JScrollPane detailsScrollPane = new JScrollPane(component);
                detailsScrollPane.setBorder(null);
                this.rootComponent.getDetailsPanel().removeAll();
                this.rootComponent.getDetailsPanel().add(detailsScrollPane);
            }
            this.rootComponent.getDetailsPanel().revalidate();
            this.rootComponent.getDetailsPanel().repaint();
        }
    }

    @Override
    public void showInHistoryPanel(AbstractSession abstractSession) {
    }

    private void initUI() {
        this.machineContentsPanel = new MachineContentsPanel(this.machineModel, this);
        this.machineDetailsPanel = new MachineDetailsPanel(this, this.machineModel, this.alertModel);
        this.machineModel.addModelChangeListener(this.machineDetailsPanel);
        this.machineModel.addModelChangeListener(this.machineContentsPanel);
        this.rootComponent.getContentsPanel().setLayout(new GridLayout(1, 1));
        this.rootComponent.getContentsPanel().add(this.machineContentsPanel.getRootComponent());
        this.detailsCards.add(this.machineDetailsPanel.getRootComponent());
        JScrollPane detailsScrollPane = new JScrollPane(this.detailsCards);
        detailsScrollPane.setBorder(null);
        this.rootComponent.getDetailsPanel().setLayout(new GridLayout(1, 1));
        this.rootComponent.getDetailsPanel().add(detailsScrollPane);
        this.hierarchyPanel = new MachineHierarchyPanel(this.machineModel, this);
        this.setSelectedGroups((Object)null, new MachineGroup[]{(MachineGroup)this.machineModel.getAvailableMachinesGroup()});
        this.rootComponent.getHierarchyPanel().setLayout(new GridLayout(1, 1));
        this.rootComponent.getHierarchyPanel().add(this.hierarchyPanel.getRootComponent());
    }

    @Override
    public void setSelectedElements(Object source, TreeSelection<MachineGroup, Machine> selection, boolean updateUI) {
        if (this.isBatchSelection) {
            return;
        }
        this.machineContentsPanel.setSelectedMachines(selection);
        if (selection == null || selection.getMachineCount() == 0) {
            this.machineDetailsPanel.initUIWithNoSelection();
        } else if (this.getTechClient().amOverMachineLimit()) {
            this.machineDetailsPanel.setSelectedMachines(selection);
        } else if (selection.getMachineCount() == 1) {
            this.machineDetailsPanel.setSelectedMachine(selection);
            mrt.setDetailsRequiredFor(selection.iterator().next());
        } else {
            this.machineDetailsPanel.setSelectedMachines(selection);
        }
    }

    public void setSelectedGroups(final Object source, final MachineGroup[] selectedGroups) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccessPanel.this.setSelectedGroups(source, selectedGroups);
                }
            });
            return;
        }
        if (source != this.machineContentsPanel) {
            this.machineContentsPanel.setSelectedGroups(selectedGroups);
        }
        if (source != this.hierarchyPanel) {
            this.hierarchyPanel.setSelectedGroups(selectedGroups);
        }
        TreeNodeFilterProcessor selectedFilterProcessor = null;
        if (selectedGroups.length > 0) {
            selectedFilterProcessor = this.machineModel.getFilterAncestor(selectedGroups[0]);
        }
        this.machineDetailsPanel.setAncestorFilterProcessor(selectedFilterProcessor);
        this.machineDetailsPanel.setSelectedMachine(null);
    }

    @Override
    public void setSelectedGroup(final Object source, final MachineGroup selectedGroup) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (source != this.machineContentsPanel) {
                this.machineContentsPanel.setSelectedGroup(selectedGroup);
            }
            if (source != this.hierarchyPanel) {
                this.hierarchyPanel.setSelectedGroup(selectedGroup);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccessPanel.this.setSelectedGroup(source, selectedGroup);
                }
            });
        }
    }

    @Override
    public TechClient getTechClient() {
        return this.client;
    }

    @Override
    public void renameSelectedNode(MachineGroup nodeValue) {
        this.hierarchyPanel.renameSelectedNode(nodeValue);
    }

    private String saveStateToXML() {
        StringBuffer xml = new StringBuffer();
        this.machineModel.saveToXML(xml);
        return xml.toString();
    }

    private boolean checkAndShowWarnings(Machine machine) {
        String warnings = machine.getMachineInfo().getWarnings();
        if (warnings != null && warnings.length() > 0) {
            return SHGlassOptionPane.showConfirmDialog((RootPaneContainer)((Object)this.getRootComponent().getRootPane().getParent()), warnings, Language.get("NOTIFICATIONS"), null, Language.get("YES"));
        }
        return true;
    }

    @Override
    public void connectToMachine(Machine machine) {
        if (machine.isHeadless()) {
            this.connectToMachine(machine, null, 4, false, false);
        } else {
            this.connectToMachine(machine, null, 0, false, false);
        }
    }

    @Override
    public void connectToMachine(Machine machine, String windowsSessionID) {
        this.connectToMachine(machine, windowsSessionID, 0, false, false);
    }

    @Override
    public void connectToMachine(Machine machine, String windowsSessionIDRequested, int mode, boolean requestConnection, boolean viewOnly) {
        this.connectToMachine(machine, windowsSessionIDRequested, mode, requestConnection, viewOnly, null);
    }

    @Override
    public void connectToMachine(final Machine machine, final String windowsSessionIDRequested, final int mode, final boolean requestConnection, final boolean viewOnly, final TechClient.PortForwardRequest portForwardRequest) {
        if (this.client.amOverMachineLimit()) {
            TrialUtils.overMachineLimitPopup((RootPaneContainer)((Object)this.getRootComponent().getRootPane().getParent()), this.getRootComponent(), this.client);
            return;
        }
        new Thread("ConnectMachineThread"){

            @Override
            public void run() {
                if (!machine.isAvailable() || machine.needsUpgrading()) {
                    return;
                }
                if (!AccessPanel.this.checkAndShowWarnings(machine)) {
                    return;
                }
                String windowsSessionID = windowsSessionIDRequested;
                if (windowsSessionID != null && windowsSessionID.length() == 0) {
                    windowsSessionID = null;
                }
                try {
                    boolean mustRequestConnection = requestConnection || AccessPanel.this.client.getTechUser().getPermissions().mustRequestConnection();
                    long timeout = ((AccessPanel)AccessPanel.this).client.getTechUser().requestConnectionTimeout;
                    AccessPanel.this.client.startClient(machine.getMachineID(), true, true, mode, mustRequestConnection, timeout, viewOnly, WindowBoundsUtil.getDesiredWindowBounds(), windowsSessionID, portForwardRequest);
                }
                catch (MonitoringOnlyException x) {
                    MonitoringOnlyUtil.disallowedPopup((RootPaneContainer)((Object)AccessPanel.this.getRootComponent().getRootPane().getParent()), AccessPanel.this.getRootComponent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)((Object)AccessPanel.this.getRootComponent().getRootPane().getParent()), Language.get("CONNECTION_FAILED") + ": " + e, Language.get("CONNECTION_FAILED"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
                }
            }
        }.start();
    }

    @Override
    public void terminateSession(AbstractSession object) {
        block5: {
            try {
                AccessSession session;
                block6: {
                    if (!(object instanceof AccessSession)) break block5;
                    session = (AccessSession)object;
                    try {
                        AppTunnelUI.AppTunnelMessageListener[] allListeners;
                        if (!session.isAppTunnelSession()) break block6;
                        System.out.println("[AccessPanel] Terminating app tunnel first");
                        for (AppTunnelUI.AppTunnelMessageListener listener : allListeners = AppTunnelUIRepository.INSTANCE.getAllListenersFor(session.getMachine().getMachineID())) {
                            if (!listener.matches(session)) continue;
                            System.out.println("[AccessPanel] App tunnel match found. Terminating now.");
                            listener.terminate();
                            break;
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                this.client.killSession(session);
                Machine machine = session.getMachine();
                machine.getActiveSessions().remove(session);
                this.machineModel.updateMachine(machine);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void notifyOfContentsStatsChange(ContentsMetrics stats) {
        if (this.machineContentsPanel != null) {
            this.machineContentsPanel.updateUIWithMetrics(stats);
        }
    }

    @Override
    public void setElementName(MachineGroup parent, Machine machine, MachineName newMachineName) {
        this.client.renameMachine(machine.getMachineID(), newMachineName);
        boolean restoreSelection = this.machineContentsPanel.isMachineSelected(machine);
        this.machineModel.renameElement(parent, machine, newMachineName);
        if (restoreSelection) {
            this.machineContentsPanel.ensureMachineIsSelected(parent, machine);
        }
    }

    @Override
    public void setMonitoring(MachineSelection selection, boolean on) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Machine machine : selection) {
            ids.add(machine.getMachineID());
        }
        try {
            this.client.switchMonitoring(on, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveElements(Machine[] machines, MachineGroup group) {
        System.out.println("[AccessPanel] Moving " + machines.length + " machines to " + group);
        this.client.moveMachines(machines, this.machineModel.getGroupPath(group));
    }

    @Override
    public boolean isDetailsPanelVisible() {
        return this.rootComponent.isDetailsPanelVisible();
    }

    @Override
    public void setDetailsPanelVisiblity(boolean isVisible) {
        this.rootComponent.setDetailsPanelVisible(isVisible);
        this.machineContentsPanel.setDetailsPanelIsShowing(isVisible);
        TechProperties.INSTANCE.setPropAndSave(TechProperties.ACCESS_PANEL_DETAILS_VISIBLE, Boolean.toString(isVisible));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showBigScreenshot(Machine machine) {
        System.out.println("[AccessPanel] Showing large screenshot");
        JRootPane rootPane = SwingUtilities.getRootPane(this.rootComponent.getRootComponent());
        RootPaneContainer container = (RootPaneContainer)((Object)rootPane.getParent());
        final JLayeredPane layeredPane = container.getLayeredPane();
        layeredPane.setOpaque(true);
        final GbPanel test = new GbPanel(){

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(new Color(100, 100, 100, 150));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        ArrowedProgressBar bar = new ArrowedProgressBar(Color.WHITE);
        bar.getRootComponent().setOpaque(false);
        bar.on();
        test.setLayout(new GridLayout(1, 1));
        test.add(bar.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        test.setOpaque(false);
        test.setBounds(container.getContentPane().getBounds());
        container.getLayeredPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                test.setBounds(e.getComponent().getBounds());
            }
        });
        test.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                AccessPanel.this.bigScreenshotON = false;
                layeredPane.remove(test);
                layeredPane.revalidate();
                layeredPane.repaint();
            }
        });
        this.bigScreenshotON = true;
        layeredPane.add((Component)test, JLayeredPane.MODAL_LAYER);
        layeredPane.revalidate();
        layeredPane.repaint();
        Object object = this.BIG_SCREEN_LOCK;
        synchronized (object) {
            if (this.bigScreenRequestThread != null) {
                this.bigScreenRequestThread.die();
            }
            this.bigScreenRequestThread = new BigScreenRequestThread(machine, test, this.machineDetailsPanel.getSelectedScreen());
        }
    }

    @Override
    public void upgradeMachines(Machine[] machine) {
        ArrayList<Machine> machineList = new ArrayList<Machine>(machine.length);
        Collections.addAll(machineList, machine);
        MachineGroup updateGroup = IconnedMachineGroup.newIconnedGroup(Language.get("UPGRADING") + "...", ImageLoader.getImageIcon("images/svg/machine-state/upgrade.svg,16"));
        StopOrUpdateServiceListener upgradeListener = new StopOrUpdateServiceListener(updateGroup, false);
        UpdateMachineFilter filter = new UpdateMachineFilter(this.getTechClient(), machineList, updateGroup, upgradeListener);
        this.machineModel.addFilterProcessor(filter, updateGroup, false);
    }

    @Override
    public void setAutoUpdating(final Machine[] machines, final boolean autoUpdate) {
        System.out.println("[AccessPanel] Auto restart " + machines.length + " machines is " + autoUpdate);
        new Thread("AutoRestartThread"){

            @Override
            public void run() {
                try {
                    AccessPanel.this.client.setAutoUpdateServices(machines, autoUpdate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    public void configureRemoteMachinesNotification(Machine[] availableMachines) {
        this.machineDetailsPanel.configureNotification(availableMachines);
    }

    @Override
    public void configureRemoteMachine(Machine machine) {
        this.machineDetailsPanel.configureMachine(machine);
    }

    @Override
    public void showPreconfiguredAccessApps() {
        this.machineDetailsPanel.showPreconfiguredAccessApps();
    }

    @Override
    public void setContentsPanelVisible(boolean visible) {
        this.rootComponent.setContentsPanelVisible(visible);
    }

    @Override
    public void setHierarchyPanelVisible(boolean visible) {
        this.rootComponent.setHierarchyPanelVisible(visible);
    }

    @Override
    public void doRemoteMachinesNotification(Machine[] machines, String heading, String message) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Machine machine : machines) {
            ids.add(machine.getMachineID());
        }
        try {
            this.client.doRemoteMachineNotifications(ids, heading, message);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private String getWanID(String wan, NetAdapter[] lans) {
        for (NetAdapter lan : lans) {
            if (!SafeCmp.equal(wan, lan.ip)) continue;
            return "(server network)";
        }
        if (wan != null && wan.equals("127.0.0.1")) {
            return "(server network)";
        }
        return wan;
    }

    @Override
    public void doWakeOnLan(Machine[] offlineMachines) {
        MapOfLists<String, Machine> map = new MapOfLists<String, Machine>(true);
        Iterator onlines = this.machineModel.getDescendentElements(this.machineModel.getOnlineFilterGroup());
        while (onlines.hasNext()) {
            Machine online = (Machine)onlines.next();
            MachineInfo info = online.getMachineInfo();
            if (info == null) continue;
            String wanip = info.getWanIP();
            NetAdapter[] na = info.getNetAdapters();
            String wanID = this.getWanID(wanip, na);
            if (CentralDebugging.MUPLOAD_WOL) {
                System.out.println("[WOL] Online machine " + online.getMachineName() + " = " + wanID);
            }
            map.add(wanID, online);
        }
        Random r = new Random();
        for (Machine offline : offlineMachines) {
            MachineInfo info = offline.getMachineInfo();
            if (info != null) {
                List possible;
                NetAdapter[] na;
                if (CentralDebugging.MUPLOAD_WOL) {
                    System.out.println("[WOL] Asked to wake " + offline.getMachineName());
                }
                String wanip = info.getWanIP();
                for (NetAdapter aNa : na = info.getNetAdapters()) {
                    if (!CentralDebugging.MUPLOAD_WOL) continue;
                    System.out.println("[WOL] Will wake " + aNa.ip + " / " + aNa.mac);
                }
                String wanID = this.getWanID(wanip, na);
                if (CentralDebugging.MUPLOAD_WOL) {
                    System.out.println("[WOL] target WAN ID is " + wanID);
                }
                if ((possible = map.get(wanID)) == null) {
                    if (!CentralDebugging.MUPLOAD_WOL) continue;
                    System.out.println("[WOL] no online machines that appear to be able to wake target");
                    continue;
                }
                for (int z = 0; z < 3; ++z) {
                    Machine from = (Machine)possible.get(r.nextInt(possible.size()));
                    this.client.bufferWolRequest(from, na);
                }
                continue;
            }
            if (!CentralDebugging.MUPLOAD_WOL) continue;
            System.out.println("[WOL] No machine info for " + offline.getMachineName());
        }
        try {
            this.client.doBufferedWolsNow();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void setStopWhenNextOnline(Machine[] machines, boolean stop) {
        boolean isOK;
        if (stop && !(isOK = SHGlassOptionPane.showOkCancelDialog(SwingUtil.getRootPaneContainer(this.rootComponent.getRootComponent()), Language.get("DISABLE_SG_SERVICE_CONFIRM2"), Language.get("DISABLE_SG_SERVICE2"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("KICK_USER"), Language.get("CANCEL")))) {
            return;
        }
        ArrayList<String> machineIDs = new ArrayList<String>();
        for (Machine m : machines) {
            machineIDs.add(m.getMachineID());
        }
        try {
            this.client.setStopOnNextRegister(machineIDs.toArray(new String[0]), stop);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void stopOrForgetMachines(Machine[] machines) {
        int availableCount = 0;
        int offlineCount = 0;
        for (Machine m : machines) {
            if (m.isAvailable()) {
                ++availableCount;
                continue;
            }
            ++offlineCount;
        }
        boolean allForget = offlineCount == machines.length;
        boolean isOK = false;
        isOK = !allForget ? SHGlassOptionPane.showOkCancelDialog(SwingUtil.getRootPaneContainer(this.rootComponent.getRootComponent()), Language.get("DISABLE_SG_SERVICE_CONFIRM2"), Language.get("DISABLE_SG_SERVICE2"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("KICK_USER"), Language.get("CANCEL")) : SHGlassOptionPane.showOkCancelDialog(SwingUtil.getRootPaneContainer(this.rootComponent.getRootComponent()), Language.get("FORGET_SG_SERVICE_CONFIRM2"), Language.get("FORGET_SG_SERVICE2"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("ACCESS_FORGET"), Language.get("CANCEL"));
        if (!isOK) {
            return;
        }
        ArrayList<Machine> offline = new ArrayList<Machine>();
        ArrayList<Machine> stop = new ArrayList<Machine>();
        for (Machine machine : machines) {
            if (!machine.isAvailable()) {
                offline.add(machine);
                continue;
            }
            stop.add(machine);
        }
        final Machine[] offlineMachineArray = offline.toArray(new Machine[0]);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AccessPanel.this.machineModel.removeElements(offlineMachineArray);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            this.uiThreadPool.runAsync(task);
        } else {
            task.run();
        }
        try {
            this.client.removeOfflineMachine(offlineMachineArray);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (stop.size() > 0) {
            MachineGroup stopGroup = IconnedMachineGroup.newIconnedGroup(Language.get("STOP_SG_STOPPING") + "...", ImageLoader.getImageIcon("images/svg/computing/power-off.svg,16"));
            StopOrUpdateServiceListener stopListener = new StopOrUpdateServiceListener(stopGroup, true);
            StopMachineFilter filter = new StopMachineFilter(this.getTechClient(), stop, stopGroup, stopListener);
            this.machineModel.addFilterProcessor(filter, stopGroup, false);
        }
    }

    @Override
    public void setBatchSelection(boolean isBatchSelection) {
        this.isBatchSelection = isBatchSelection;
    }

    @Override
    public JPopupMenu getMachineConnectionMenu(Machine machine) {
        return this.getMachineConnectionMenu(machine, null);
    }

    @Override
    public JPopupMenu getMachineConnectionMenu(final Machine machine, final String sessionID) {
        final boolean isHeadless = machine.isHeadless();
        JPopupMenu popup = new JPopupMenu();
        boolean diagnosticsEnabled = this.client.getPermissions().canUseDiagnostics();
        boolean fileTransferEnabled = this.client.getPermissions().canUseFileTransfer();
        if (!isHeadless) {
            popup.add(new JMenuItem(new AbstractAction(Language.get("CONNECT_OPTION_VIEW_ONLY"), ImageLoader.getImageIcon("images/svg/technology/screen.svg,20")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccessPanel.this.connectToMachine(machine, sessionID, 0, false, true);
                }
            }));
        }
        JMenuItem item = new JMenuItem(new AbstractAction(Language.get("CONNECT_OPTION_FILE_TRANSFER"), ImageLoader.getImageIcon("images/svg/files-folders/copy-files.svg,20")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPanel.this.connectToMachine(machine, sessionID, !isHeadless ? 1 : 6, false, false);
            }
        });
        popup.add(item);
        if (!fileTransferEnabled) {
            item.setEnabled(false);
        }
        if (!GroupAccessKeyset.isEnabled()) {
            item = new JMenuItem(new AbstractAction(Language.get("CONNECT_OPTION_DIAGNOSTICS"), ImageLoader.getImageIcon("images/svg/charts/meter.svg,20")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccessPanel.this.connectToMachine(machine, sessionID, !isHeadless ? 2 : 7, false, false);
                }
            });
            popup.add(item);
            if (!diagnosticsEnabled) {
                item.setEnabled(false);
            }
        }
        item = new JMenuItem(new AbstractAction(Language.get("CONNECT_OPTION_TERMINAL"), ImageLoader.getImageIcon("images/svg/computing/terminal.svg,20")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessPanel.this.connectToMachine(machine, sessionID, 4, false, false);
            }
        });
        popup.add(item);
        if (!diagnosticsEnabled) {
            item.setEnabled(false);
        }
        if (!GroupAccessKeyset.isEnabled() && !isHeadless) {
            popup.add(new JPopupMenu.Separator());
            popup.add(new JMenuItem(new AbstractAction(Language.get("CONNECT_OPTION_REQUEST"), ImageLoader.getImageIcon("O[images/svg/chat/chat-question.svg,20 | images/svg/dialogs/question.svg,10]")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccessPanel.this.connectToMachine(machine, sessionID, 0, true, false);
                }
            }));
        }
        return popup;
    }

    @Override
    public void setNotes(Machine machine, String newText) {
        try {
            this.client.setNotes(machine, newText);
        }
        catch (Throwable t) {
            System.out.println("[WARNING] Unable to save notes for " + machine.getMachineID());
            t.printStackTrace();
        }
    }

    @Override
    public void setWarnings(Machine machine, String newText) {
        try {
            this.client.setWarnings(machine, newText);
        }
        catch (Throwable t) {
            System.out.println("[WARNING] Unable to save warnings for " + machine.getMachineID());
            t.printStackTrace();
        }
    }

    @Override
    public void setMonitoring(MachineGroup group, boolean on) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Machine machine : group.getElements()) {
            ids.add(machine.getMachineID());
        }
        try {
            this.client.switchMonitoring(on, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setMonitoring(Machine machine, boolean on) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(machine.getMachineID());
        try {
            this.client.switchMonitoring(on, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void testMiniSession(Machine machine) {
        try {
            System.out.println("TESTING - requesting mini session to " + machine.getMachineID());
            MiniClient mc = this.client.startMiniSession(machine.getMachineID());
            System.out.println("TESTING - got back MiniClient");
            System.out.println(mc.isElevated());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public byte[] getServiceLogsFor(Machine machine, String password) throws Exception {
        return this.client.getLogsViaSecMsg(machine.getMachineID(), password);
    }

    public void hierarchyResized(int leftSplitLocation, int centreSplitLocation) {
        if (centreSplitLocation > 0) {
            int unscaledLeft = SimpleHelpLookAndFeel.unscale(leftSplitLocation);
            int unscaledCentre = SimpleHelpLookAndFeel.unscale(centreSplitLocation);
            LocalProperties.INSTANCE.setPropAndSaveIn(LocalProperties.PROP_ACCESS_HIERARCHY, unscaledLeft + "," + unscaledCentre, 1000);
            TechProperties.INSTANCE.setPropAndSaveIn(TechProperties.DEPRECATED_PROP_ACCESS_HIERARCHY, unscaledLeft + "," + unscaledCentre, 3000);
        }
    }

    @Override
    public void setBlockMachine(Machine[] machines) {
        boolean isOK = SHGlassOptionPane.showOkCancelDialog(SwingUtil.getRootPaneContainer(this.rootComponent.getRootComponent()), Language.get("BLOCK_DESC"), Language.get("BLOCK_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("ACCESS_BLOCK"), Language.get("CANCEL"));
        if (!isOK) {
            return;
        }
        try {
            this.client.addBlockedMachines(machines);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setRunToolBoxWhenNextOnline(Machine[] machines, boolean enable, ToolBoxItem item, int maximumSessionsToUse) {
        try {
            System.out.println("[AccessPanel] Asked to queue toolbox run for " + machines.length + " machines");
            this.client.setRunToolWhenNextOnline(machines, enable, item, maximumSessionsToUse);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setMigrateWhenNextOnline(Machine[] offlineMachines, boolean enable, String add, String remove) {
        try {
            System.out.println("[AccessPanel] Asked to queue migrate offline services.");
            System.out.println("[AccessPanel] Migration count is " + offlineMachines.length + " add:" + add + ", remote:" + remove);
            this.client.setMigrateWhenNextOnline(offlineMachines, enable, add, remove);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void migrateServices(Machine[] availableMachines, String add, String remove) {
        try {
            System.out.println("[AccessPanel] Asked to migrate services.");
            System.out.println("[AccessPanel] Migration count is " + availableMachines.length + " add:" + add + ", remote:" + remove);
            this.client.migrateServices(availableMachines, add, remove);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setToolBox(ToolBox toolBox) {
        this.toolBox = toolBox;
    }

    @Override
    public ToolBox getCurrentToolBox() {
        return this.toolBox;
    }

    @Override
    public void runToolBoxItem(Machine[] machines, ToolBoxItem item, int maximumSessionsToUse) {
        ArrayList<Machine> machineList = new ArrayList<Machine>(machines.length);
        for (Machine m : machines) {
            if (item.getTargetOperatingSystem() != m.getOsBaseType()) continue;
            machineList.add(m);
        }
        RunToolMachineGroup updateGroup = RunToolMachineGroup.newRunToolMachineGroup(item.getName() + "...", ImageLoader.getImageIcon("images/svg/general/box.svg,16"));
        String suffix = " ";
        while (this.machineModel.groupExistsEquals(null, updateGroup)) {
            updateGroup = RunToolMachineGroup.newRunToolMachineGroup(item.getName() + "..." + suffix, ImageLoader.getImageIcon("images/svg/general/box.svg,16"));
            suffix = suffix + " ";
        }
        RunToolServiceListener runToolListener = new RunToolServiceListener(updateGroup);
        RunToolMachineFilter filter = new RunToolMachineFilter(this.getTechClient(), machineList, updateGroup, runToolListener, item);
        this.machineModel.addFilterProcessor(filter, updateGroup, false);
        System.out.println("[AccessPanel] Requesting toolbox item " + item.getName() + " to be run on " + machines.length + " machines");
        this.setSelectedGroup((Object)this, updateGroup);
        ToolboxItemResponseListener listener = new ToolboxItemResponseListener(machines, runToolListener);
        ToolBoxConstants.syncResources(this.client, null, item, null);
        try {
            long runID = this.client.runToolboxItem(machines, item, listener, maximumSessionsToUse);
            filter.setRunID(runID);
        }
        catch (Exception x) {
            x.printStackTrace();
            listener.endProcessingOfUnfinishedMachines(x);
        }
    }

    @Override
    public void showAlertInUI(LocatedAlert alert) {
        this.techUiInterface.showAlert(alert);
    }

    @Override
    public void ensureElementSelected(MachineGroup group, Machine element) {
        this.machineContentsPanel.ensureMachineIsSelected(group, element);
    }

    @Override
    public void setDetailsPanelState(boolean min, boolean max) {
        this.rootComponent.setDetailsPanelState(min, max, this.machineDetailsPanel.getButtonBarHeight() + 1);
        if (min) {
            this.machineDetailsPanel.setShowOnlyButtonBar(true);
        } else {
            this.machineDetailsPanel.setShowOnlyButtonBar(false);
        }
    }

    @Override
    public boolean isMachineFavourite(Machine machine) {
        return this.machineModel.isMachineFavourite(machine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMachineFavourite(Machine machine, boolean favourite) {
        this.machineModel.setMachineFavourite(machine, favourite);
        Object object = this.SAVE_LOCK;
        synchronized (object) {
            if (this.currentSaveThread == null) {
                this.currentSaveThread = new SaveXMLThread();
            }
        }
    }

    public void debugSetSearchString(String s) {
        this.machineContentsPanel.debugSetSearchString(s);
    }

    @Override
    public void subscribeToExpensiveThumbs(ArrayList<Machine> paintedMachines) {
        if (this.client != null) {
            this.client.subscribeToMachinesExpensive(paintedMachines, this.machineDetailsPanel.getSelectedMachine());
        }
    }

    @Override
    public void changeMonitoredScreen(String machineID, boolean next, boolean big) {
        this.client.switchMonitoredScreen(machineID, next, big);
    }

    @Override
    public SessionPerformance[] getPerformanceStatsFor(String[] allIDS) throws Exception {
        return this.client.getPerformanceStatsFor(allIDS);
    }

    private class ToolboxItemResponseListener
    implements MachineResponseListener {
        private final ArrayList<Machine> machinesList = new ArrayList();
        private final RunToolServiceListener runToolListener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ToolboxItemResponseListener(Machine[] machines, RunToolServiceListener runToolListener) {
            this.runToolListener = runToolListener;
            for (Machine m : machines) {
                ArrayList<Machine> arrayList = this.machinesList;
                synchronized (arrayList) {
                    this.machinesList.add(m);
                }
                runToolListener.startedProcessing(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endProcessingOfUnfinishedMachines(Exception reason) {
            ArrayList<Machine> arrayList = this.machinesList;
            synchronized (arrayList) {
                ToolBoxResult error = ToolBoxResult.createErrorResult(reason);
                for (Machine m : this.machinesList) {
                    this.runToolListener.endedProcessing(m, error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void machineResponse(String machineID, Message response) {
            if (CentralDebugging.MUPLOAD_RUN_RESPONSE_VERBOSE_TC) {
                System.out.println("[MUpload] Machine " + machineID + " responded with " + response.toPretty(PC.REFS));
            }
            if (response.getType() == 1589706790) {
                ToolBoxStatus statusUpdate = ToolBoxStatus.fromMessage(response);
                Machine m2 = (Machine)AccessPanel.this.machineModel.getElementWithID(machineID);
                this.runToolListener.updateProcessing(m2, statusUpdate);
            } else {
                Machine m = (Machine)AccessPanel.this.machineModel.getElementWithID(machineID);
                ArrayList<Machine> m2 = this.machinesList;
                synchronized (m2) {
                    this.machinesList.remove(m);
                }
                ToolBoxResult responseResult = ToolBoxResult.fromMessage(response);
                this.runToolListener.endedProcessing(m, responseResult);
            }
        }
    }

    private class SaveXMLThread
    extends Thread {
        public SaveXMLThread() {
            super("Access Panel Save Thread");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("[AccessPanel] Requested state save.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Object object = AccessPanel.this.SAVE_LOCK;
            synchronized (object) {
                String xml = AccessPanel.this.saveStateToXML();
                System.out.println(xml);
                TechProperties.INSTANCE.setPropAndSave(TechProperties.ACCESS_PANEL_CONFIG, xml);
                AccessPanel.this.currentSaveThread = null;
            }
        }
    }

    private class SaveStateListener
    extends MachineModelChangeAdapter {
        private SaveStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void filterProcessorChanged() {
            Object object = AccessPanel.this.SAVE_LOCK;
            synchronized (object) {
                if (AccessPanel.this.currentSaveThread == null) {
                    AccessPanel.this.currentSaveThread = new SaveXMLThread();
                }
            }
        }
    }

    private class RunToolServiceListener
    implements ServiceUIListener {
        private MachineGroup machineGroup;
        private TreeNodeFilterProcessor filterProcessor;

        public RunToolServiceListener(MachineGroup machineGroup) {
            this.machineGroup = machineGroup;
        }

        @Override
        public void startedProcessing(Machine machine) {
            MachineUIMetadata metadata = MachineMetadataUtil.getMetadataFor(machine);
            metadata.setIcon(AccessPanel.this.progressBar);
        }

        @Override
        public void setRoot(MachineGroup group) {
            this.machineGroup = group;
        }

        @Override
        public void endedProcessing(Machine machine, Object resultObject) {
            ToolBoxResult result = (ToolBoxResult)resultObject;
            ((RunToolMachineFilter)this.filterProcessor).getUi().setResult(machine, result);
            MachineUIMetadata metadata = MachineMetadataUtil.getMetadataFor(machine);
            if (result.preLaunchError != null && result.preLaunchError.length() > 0) {
                metadata.setIcon(AccessPanel.this.computerIconError);
            } else {
                metadata.setIcon(AccessPanel.this.computerIconOk);
            }
            AccessPanel.this.machineContentsPanel.getRootComponent().repaint();
        }

        @Override
        public void finish() {
            AccessPanel.this.machineModel.removeAllGroupsAndMachines(this.machineGroup);
            AccessPanel.this.setSelectedGroup((Object)AccessPanel.this, (MachineGroup)AccessPanel.this.machineModel.getAvailableMachinesGroup());
        }

        @Override
        public void setFilterProcessor(TreeNodeFilterProcessor filterProcessor) {
            this.filterProcessor = filterProcessor;
        }

        @Override
        public void removeMachineFromList(Machine machine) {
            machine.setUIMetadata(null);
            AccessPanel.this.machineContentsPanel.getRootComponent().repaint();
            AccessPanel.this.machineModel.removeMachineFromFilter(machine, this.filterProcessor);
            ((RunToolMachineFilter)this.filterProcessor).removeMachine(machine);
            if (!AccessPanel.this.machineModel.groupExistsEquals(null, this.machineGroup)) {
                this.finish();
            }
        }

        public void updateProcessing(Machine machine, ToolBoxStatus statusUpdate) {
            ((RunToolMachineFilter)this.filterProcessor).getUi().updateStatus(machine, statusUpdate);
        }
    }

    private class StopOrUpdateServiceListener
    implements ServiceUIListener {
        private MachineGroup machineGroup;
        private TreeNodeFilterProcessor filterProcessor;
        private final boolean isStop;

        public StopOrUpdateServiceListener(MachineGroup machineGroup, boolean isStop) {
            this.isStop = isStop;
            this.machineGroup = machineGroup;
        }

        @Override
        public void setRoot(MachineGroup group) {
            this.machineGroup = group;
        }

        @Override
        public void startedProcessing(Machine machine) {
            MachineUIMetadata metadata = MachineMetadataUtil.getMetadataFor(machine);
            metadata.setIcon(AccessPanel.this.progressBar);
        }

        @Override
        public void endedProcessing(final Machine machine, Object resultObject) {
            int result = (Integer)resultObject;
            if (result == AbstractServiceUtil.RESULT_OK) {
                MachineUIMetadata metadata = MachineMetadataUtil.getMetadataFor(machine);
                metadata.setIcon(AccessPanel.this.computerIconOk);
                AccessPanel.this.machineContentsPanel.getRootComponent().repaint();
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        StopOrUpdateServiceListener.this.clearMachine(machine);
                    }
                }, 2000L);
            } else {
                MachineUIMetadata metadata = MachineMetadataUtil.getMetadataFor(machine);
                if (result == AbstractServiceUtil.RESULT_CREDENTIALS) {
                    metadata.setIcon(AccessPanel.this.computerPadlock);
                } else if (result == AbstractServiceUtil.RESULT_MACHINE_PASSWORD) {
                    metadata.setIcon(AccessPanel.this.computerPadlock);
                } else if (result == AbstractServiceUtil.RESULT_ERROR) {
                    metadata.setIcon(AccessPanel.this.computerIconError);
                }
                AccessPanel.this.machineContentsPanel.getRootComponent().repaint();
            }
        }

        private void clearMachine(final Machine machine) {
            if (this.isStop) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        AccessPanel.this.machineModel.removeElements(new Machine[]{machine});
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    AccessPanel.this.uiThreadPool.runAsync(task);
                } else {
                    task.run();
                }
            } else {
                machine.setUIMetadata(null);
                AccessPanel.this.machineContentsPanel.getRootComponent().repaint();
                AccessPanel.this.machineModel.removeMachineFromFilter(machine, this.filterProcessor);
                ((UpdateMachineFilter)this.filterProcessor).removeMachine(machine);
            }
        }

        @Override
        public void finish() {
            AccessPanel.this.machineModel.removeAllGroupsAndMachines(this.machineGroup);
            AccessPanel.this.setSelectedGroup((Object)AccessPanel.this, (MachineGroup)AccessPanel.this.machineModel.getAvailableMachinesGroup());
        }

        @Override
        public void setFilterProcessor(TreeNodeFilterProcessor filterProcessor) {
            this.filterProcessor = filterProcessor;
        }

        @Override
        public void removeMachineFromList(Machine machine) {
            this.clearMachine(machine);
        }
    }

    private class BigScreenRequestThread
    extends Thread {
        private final Machine machine;
        private boolean die;
        private final GbPanel contentPanel;
        private final int screenSelectionStart;

        BigScreenRequestThread(Machine machine, GbPanel test, int screenSelectionStart) {
            super("BigScreenRequestThread");
            this.die = false;
            this.contentPanel = test;
            this.machine = machine;
            this.screenSelectionStart = screenSelectionStart;
            this.start();
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            final ScaledShadowImagePanel imagePanel = new ScaledShadowImagePanel(null);
            imagePanel.useDarkerBorder();
            imagePanel.setCenter(true);
            imagePanel.setShowHoverZoom(false);
            imagePanel.setColor(AccessStyle.TREE_SELECTION_COLOR, ColorUtils.getTransparentVersion(AccessStyle.TREE_SELECTION_COLOR, 150));
            MachineInfo info = this.machine.getMachineInfo();
            if (info != null) {
                imagePanel.setShowArrows(info.getScreenCount() > 1, info.getScreenCount(), this.screenSelectionStart);
            } else {
                imagePanel.setShowArrows(false, 0, this.screenSelectionStart);
            }
            imagePanel.setOpaque(false);
            imagePanel.setBackground(new Color(0, 0, 0, 0));
            imagePanel.setShadowPanelListener(new ScaledShadowImagePanel.ShadowPanelListener(){

                @Override
                public void zoomPressed() {
                    AccessPanel.this.bigScreenshotON = false;
                    Container layeredPane = BigScreenRequestThread.this.contentPanel.getParent();
                    if (layeredPane != null) {
                        layeredPane.remove(BigScreenRequestThread.this.contentPanel);
                        layeredPane.repaint();
                    }
                }

                @Override
                public void leftPressed() {
                    AccessPanel.this.changeMonitoredScreen(BigScreenRequestThread.this.machine.getMachineID(), false, true);
                }

                @Override
                public void rightPressed() {
                    AccessPanel.this.changeMonitoredScreen(BigScreenRequestThread.this.machine.getMachineID(), true, true);
                }
            });
            while (AccessPanel.this.bigScreenshotON && !this.die) {
                long T = System.currentTimeMillis();
                try {
                    System.out.println("[AccessPanel] Requesting big screenshot");
                    Image bigScreen = AccessPanel.this.client.getBigScreen(this.machine.getMachineID());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BigScreenRequestThread.this.contentPanel.removeAll();
                            BigScreenRequestThread.this.contentPanel.add(imagePanel, 0, 0, 1, 1, 1, 1, 10, 0);
                            BigScreenRequestThread.this.contentPanel.revalidate();
                            BigScreenRequestThread.this.contentPanel.repaint();
                        }
                    });
                    imagePanel.setImage(bigScreen);
                    imagePanel.setWidth(bigScreen.getWidth(null));
                    if (this.die) {
                        return;
                    }
                    this.contentPanel.revalidate();
                    this.contentPanel.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                T = System.currentTimeMillis() - T;
                System.out.println("[AccessPanel] Took " + T + "ms to fetch big screenshot");
                try {
                    if (Switches.SH_1575_bigScreensAsap) {
                        long delta = 20L - T;
                        if (delta <= 0L) continue;
                        Thread.sleep(delta);
                        continue;
                    }
                    Thread.sleep(Math.max(500L, T));
                }
                catch (Exception exception) {}
            }
        }
    }

    private class LoadConfigurationThread
    extends Thread {
        private LoadConfigurationThread() {
        }

        @Override
        public void run() {
            String accessPanelConfigXML = TechProperties.INSTANCE.getProp(TechProperties.ACCESS_PANEL_CONFIG);
            try {
                AccessPanel.this.machineModel.loadFromXML(accessPanelConfigXML);
            }
            catch (Throwable t) {
                System.out.println("[AccessPanel] Load of access panel state failed: " + t.getMessage());
                t.printStackTrace();
            }
            try {
                AccessPanel.this.loadAndSetHierarchyLayoutSize();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

