/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.utils.LanguagePanel;
import com.aem.shelp.util.font.GlyphIconsLabel;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import jwrapper.jwutils.JWInstallApp;
import jwrapper.jwutils.JWSystem;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.FadedHorizontalLine;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public abstract class TechWelcomePane
extends ColorPropagatingGBPanel
implements ActionListener,
AbstractField.ChangeListener {
    private final TechClient client;
    private JButton passwordButton;
    private JLabel titleLabel;
    private JTextPane messageTextArea;
    private JTextField newPassword1;
    private JTextField newPassword2;
    private GbPanel passwordPanel;
    private JLabel passwordsMatchLabel;
    private boolean restartRequired = false;
    private boolean showPasswordMessage = false;

    public TechWelcomePane(TechClient client) {
        super(new Insets(5, 5, 5, 5));
        this.initUI();
        this.client = client;
    }

    public boolean getRestartRequired() {
        return this.restartRequired;
    }

    private void setAllText() {
        this.titleLabel.setText(Language.get("DEFAULT_PASSWORD_TITLE_SH"));
        if (this.showPasswordMessage) {
            this.messageTextArea.setText(Language.get("PASSWORD_FIRST_MESSAGE").trim());
        } else {
            this.messageTextArea.setText(Language.get("DEFAULT_PASSWORD_MESSAGE").trim());
        }
        this.passwordButton.setText(Language.get("ADMIN_PASSWORD"));
    }

    protected void initUI() {
        System.out.println("[TechUI] Creating default password dialog.");
        this.setBorder(SHBorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.setBackground(SHStyle.TECH_BACKGROUND);
        FadedHorizontalLine line = new FadedHorizontalLine();
        SwingUtil.setWidth(line, 400);
        this.titleLabel = new JLabel();
        this.messageTextArea = new JTextPane();
        this.messageTextArea.setFont(this.titleLabel.getFont());
        this.messageTextArea.setBackground(this.getBackground());
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setEnabled(false);
        this.messageTextArea.setDisabledTextColor(this.titleLabel.getForeground());
        StyledDocument doc = this.messageTextArea.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(SHStyle.LARGE_FONT_SIZE));
        this.titleLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.titleLabel.setHorizontalAlignment(0);
        int Y = 0;
        LanguagePanel languagePanel = new LanguagePanel(){

            @Override
            protected void selectLanguage(final String languageCode) {
                super.selectLanguage(languageCode);
                try {
                    JWInstallApp.setChosenLanguage(languageCode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                File appFolder = JWSystem.getAppFolder();
                try {
                    Language.loadTranslationsFrom(appFolder, languageCode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        Language.loadTranslationsFrom(appFolder, "en");
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                TechWelcomePane.this.setRestartButtonText(Language.get("SWITCH_LANGUAGE"));
                TechWelcomePane.this.restartRequired = true;
                TechWelcomePane.this.setAllText();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            TechWelcomePane.this.client.setServerLanguage(languageCode);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
            }
        };
        this.passwordPanel = new ColorPropagatingGBPanel();
        TextField tf = new TextField(null, this, 7);
        tf.setExampleValue(Language.get("PASSWORD_DIALOG_NEW1"));
        this.newPassword1 = (JTextField)tf.getComponent();
        tf = new TextField(null, this, 7);
        tf.setExampleValue(Language.get("PASSWORD_DIALOG_NEW2"));
        this.newPassword2 = (JTextField)tf.getComponent();
        this.passwordsMatchLabel = new GlyphIconsLabel();
        SwingUtil.setWidth(this.passwordsMatchLabel, 48);
        this.passwordsMatchLabel.setBorder(SHBorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.passwordPanel.add(new JPanel(), 0, 0, 1, 2, 1, 1, 10, 1);
        this.passwordPanel.add(this.newPassword1, 1, 0, 1, 1, 0, 0, 10, 0, new Insets(0, 0, 5, 0));
        this.passwordPanel.add(this.newPassword2, 1, 1, 1, 1, 0, 0, 10, 0, new Insets(5, 0, 0, 0));
        this.passwordPanel.add(this.passwordsMatchLabel, 2, 0, 1, 2, 1, 1, 17, 1);
        this.passwordPanel.setVisible(false);
        SwingUtil.setWidth(this.newPassword1, 200);
        SwingUtil.setWidth(this.newPassword2, 200);
        this.passwordButton = new JButton(ImageLoader.getImageIcon("images/svg/general/lock.svg,16"));
        this.add(new JLabel(ImageLoader.getImageIcon(Icons.SH_LOGO_LARGE)), 0, Y++, 2, 1, 1, 0, 11, 2, new Insets(20, 0, 10, 0));
        this.add(line, 0, Y++, 2, 1, 1, 0, 11, 2);
        this.add(this.titleLabel, 0, Y++, 2, 1, 1, 0, 11, 2);
        this.add(this.messageTextArea, 0, Y++, 2, 1, 1, 0, 11, 2, new Insets(15, 15, 0, 15));
        this.add(this.passwordButton, 0, Y++, 2, 1, 1, 0, 11, 0, new Insets(15, 0, 0, 0));
        this.add(this.passwordPanel, 0, Y++, 2, 1, 1, 0, 11, 2, new Insets(10, 30, 0, 0));
        this.add(line, 0, Y++, 1, 1, 1, 0, 11, 2, new Insets(15, 0, 15, 0));
        this.add(languagePanel.getRootComponent(), 0, Y++, 1, 1, 1, 0, 10, 1, new Insets(0, 0, 0, 0));
        this.add(new JPanel(), 0, Y++, 1, 1, 1, 1000, 10, 1, new Insets(0, 0, 0, 0));
        this.passwordButton.addActionListener(this);
        this.setAllText();
        this.setBackground(Color.white);
    }

    protected abstract void setRestartButtonText(String var1);

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showPasswordMessage = true;
        this.messageTextArea.setText(Language.get("PASSWORD_FIRST_MESSAGE"));
        this.passwordButton.setVisible(false);
        this.passwordPanel.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void changed(AbstractField source) {
        if (this.newPassword1.getText().equals(this.newPassword2.getText())) {
            this.passwordsMatchLabel.setText("\ue194");
            this.passwordsMatchLabel.setForeground(SHStyle.JPANEL_BACKGROUND_COLOR_BLUE_DARKER);
            try {
                this.client.setTechnicianPassword(this.newPassword1.getText());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.passwordsMatchLabel.setText("\ue197");
            this.passwordsMatchLabel.setForeground(SHStyle.WARNING_TEXT_COLOR);
            try {
                this.client.setTechnicianPassword("password");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        File appFolder = JWSystem.getAppFolder();
        Language.loadTranslationsFrom(appFolder, "gb");
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        new TechUi.WelcomeDialog(frame, null).showDialog();
    }
}

