/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.SHPreloadUI;
import com.aem.ServerManagement;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.profiles.keysets.PresentKeyset;
import com.aem.sdemo.ui.DemoConfigPanel;
import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.util.DualNodeLinkStatus;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.ServerAuthenticityErrorDialog;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.login.TechUiLoginGlassDialog;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.video.VideoUtils;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.logging.targets.notifytech.NotifyTechTarget;
import com.aem.shelp.proxy.logging.targets.runtool.RunToolTarget;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.ActionableResourceContainer;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.ClientNotificationUtil;
import com.aem.shelp.tech.DisconnectedDialog;
import com.aem.shelp.tech.SideNotificationPanel;
import com.aem.shelp.tech.TechOptionsPanel;
import com.aem.shelp.tech.TechUIInterfaceAPI;
import com.aem.shelp.tech.TechWelcomePane;
import com.aem.shelp.tech.access.AccessPanel;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.access.utils.MachineSelection;
import com.aem.shelp.tech.admin.AdministrationTab;
import com.aem.shelp.tech.alerts.AlertsPanel;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.model.AlertTreeModel;
import com.aem.shelp.tech.alerts.alerts.utils.LocatedAlertSelection;
import com.aem.shelp.tech.alerts.events.server.model.ServerEventsTreeModel;
import com.aem.shelp.tech.appprofile.AppProfileUI;
import com.aem.shelp.tech.authentication.TOTPCodeEntryGlassDialog;
import com.aem.shelp.tech.authentication.TOTPRegistrationPanel;
import com.aem.shelp.tech.authentication.TwoTierCodeEntryGlassDialog;
import com.aem.shelp.tech.customer.CustomerQueuePanel;
import com.aem.shelp.tech.gstarted.GrayedOutTab;
import com.aem.shelp.tech.gstarted.NoLicensePane;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.tech.history.HistoryPanel;
import com.aem.shelp.tech.history.SessionUploader;
import com.aem.shelp.tech.invitations.InvitationClient;
import com.aem.shelp.tech.notifiers.NotifierController;
import com.aem.shelp.tech.properties.ToolBoxPropertiesPanel;
import com.aem.shelp.tech.utils.FailoverDialog;
import com.aem.shelp.tech.video.TechVideoRepository;
import com.aem.shelp.util.ErrorDialogs;
import com.aem.shelp.util.HostStripper;
import com.aem.shelp.util.LogGatherer;
import com.aem.shelp.util.NodeLinkStatus;
import com.aem.shelp.util.TaggedPrintStream;
import com.aem.shelp.util.TimerPanel;
import com.aem.shelp.util.notifications.NotificationPanel;
import com.aem.shelp.util.progress.SHProgressIcons;
import com.aem.shelp.util.swing.ShPopupMenuButton;
import com.aem.tests.TestUtils;
import com.aem.tests.Testing;
import com.aem.utils.Debugger;
import com.aem.utils.NativeLibraryLoader;
import com.jw.SHJWUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jwrapper.failover.FailoverListener;
import jwrapper.failover.FailoverMonitor;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.swing.JWAutomate;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileLockUtil;
import utils.loggingframework.targets.TargetRepository;
import utils.message.Message;
import utils.progtools.BatchingTimedThread;
import utils.progtools.BatchingTimedThreadLock;
import utils.progtools.StackTracer;
import utils.progtools.time.Time;
import utils.site.transact.TrialUtil;
import utils.string.HexData;
import utils.swing.SwingUtil;
import utils.swing.borders.LeftShadowBorder;
import utils.swing.components.SHSplitPane;
import utils.swing.components.SimpleTabbedPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.switches.Switches;

public class TechUi
implements GC,
TechClientListener,
ActionListener,
WindowListener,
TechUIInterfaceAPI,
FailoverListener,
ComponentListener {
    JFrame rpc;
    Container top;
    JPanel main = new JPanel();
    AdministrationTab adminTab;
    private Object CUSTOMER_LIST_LOCK = new Object();
    private Object CUSTOMER_CONNECTED_LOCK = new Object();
    Customer[] customersWaiting = new Customer[0];
    SupportSession[] customersConnected = new SupportSession[0];
    ShPopupMenuButton binvite;
    private AccessPanel accessPanel;
    private MachineTreeModel machineModel;
    private AlertsPanel alertPanel;
    private AlertTreeModel alertModel;
    private SideNotificationPanel notificationPanel;
    CustomerQueuePanel customerQueuePanel;
    CustomerQueuePanel customerConnectedPanel;
    private static int NOTIFICATION_PANEL_WIDTH;
    DemoConfigPanel demoPanel;
    InvitationClient invitationClient;
    SimpleTabbedPanel tabs = new SimpleTabbedPanel();
    JComponent tabsHolder = this.tabs.getRootComponent();
    private LogoutListener logoutListener;
    private boolean isTestOrDebug = false;
    private Thread asyncUIThread;
    private Thread timerUpdaterThread;
    Throwable preloaderFailed = null;
    final Runnable asyncUILoader = new Runnable(){

        @Override
        public void run() {
            try {
                TechUi.this.initUIPreTechClientConnect();
            }
            catch (Throwable t) {
                TechUi.this.preloaderFailed = t;
            }
        }
    };
    TechClient client;
    private JSplitPane customerSplitPane;
    private TechUIConnectListener connectListener;
    private HistoryPanel historyPanel;
    protected NotificationPanel mainPanelWithNotification;
    private DualNodeLinkStatus dualNodeLinkStatus;
    private SessionUploader sessionUploader;
    private TechOptionsPanel preferencesTab;
    private ToolBoxPropertiesPanel toolboxTab;
    private JComponent historyPanelRoot;
    private JPanel sdemoPanel;
    private JPanel lower;
    private ToolBox toolBox;
    private ServerEventsTreeModel eventsModel;
    private boolean isDefaultPassword;
    boolean showingMainUi = false;
    static boolean testRun;
    private JLabel shLabel = new JLabel();
    private JLabel alertLabel = new JLabel();
    private Color alertOrigColor;
    private JLabel evaluationLabel = new JLabel();
    int dups = 0;
    HashMap<String, Machine> machinesToUpdate = new HashMap();
    BatchingTimedThreadLock machineUpdates = new BatchingTimedThreadLock(500L);
    Object machinesToUpdate_LOCK = this.machineUpdates.getLOCK();
    PanelGlassDialog totpAuthenticationPanelHandle = null;
    TOTPRegistrationPanel registrationPanel = null;

    public void disconnect(String reason) {
        try {
            this.client.disconnect(reason);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            NotifierController.INSTANCE.tray.disable();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TechUi(JFrame rpc, Container top, String host, String port, boolean isDefaultPassword, TechCredentials defaultCredentials, LogoutListener logoutListener) {
        NOTIFICATION_PANEL_WIDTH = SimpleHelpLookAndFeel.scale(300);
        this.logoutListener = logoutListener;
        this.init(rpc, top, host, port, isDefaultPassword, defaultCredentials);
    }

    public void logoutTechnician(final boolean forgetCredentials) {
        new Thread("LogoutThread"){

            @Override
            public void run() {
                TechUi.this.connectListener.setIgnore(true);
                try {
                    if (forgetCredentials) {
                        TechUiLoginGlassDialog.forgetCredentials();
                    }
                    TechUi.this.disconnect("techui logout");
                    TechUi.this.logoutListener.logout();
                }
                finally {
                    TechUi.this.connectListener.setIgnore(false);
                }
            }
        }.start();
    }

    private JPopupMenu getInviteOptionsMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem(new AbstractAction(Language.get("INVITE_OPTION_DEFAULT"), ImageLoader.getImageIcon("images/svg/general/magic.svg,20")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TechUi.this.doDefaultInvitation();
            }
        }));
        popup.add(new JMenuItem(new AbstractAction(Language.get("INVITE_OPTION_CREATE"), ImageLoader.getImageIcon("images/svg/arrows/right-moving.svg,20")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TechUi.this.doInvitation();
            }
        }));
        return popup;
    }

    private void doDefaultInvitation() {
        this.invitationClient.showDefaultInvitation();
    }

    private void init(JFrame rpc, final Container top, String host, String port, boolean isDefaultPassword, TechCredentials defaultCredentials) {
        this.rpc = rpc;
        this.top = top;
        this.main.addComponentListener(this);
        if (JWTesting.amTesting()) {
            rpc.setTitle(JWSystem.getMyLogFile().getName() + " " + rpc.getTitle());
        }
        FailoverMonitor.setListener(this);
        this.asyncUIThread = new Thread(this.asyncUILoader);
        this.asyncUIThread.start();
        rpc.addWindowListener(this);
        TechCredentials credentials = new TechCredentials();
        boolean success = false;
        boolean first = true;
        boolean wrongPassword = false;
        while (!success) {
            if (isDefaultPassword && first) {
                first = false;
                credentials.setUsername(OemBranding.OEM_ADMIN_USERNAME);
                credentials.setPassword("password");
            } else if (credentials == null || !credentials.hasUsername() || !credentials.hasPassword()) {
                System.out.println("[TechUI] no password specified, launching TechUiLoginDialog with default credentials " + defaultCredentials);
                System.out.println("[TechUI] Launching Login dialog");
                TechUiLoginGlassDialog login = new TechUiLoginGlassDialog(rpc, defaultCredentials, first, wrongPassword);
                first = false;
                host = HostStripper.strip(host);
                port = port.trim();
                credentials = login.getCredentials();
                System.out.println("[TechUI] Login Host: " + host);
                System.out.println("[TechUI] Login Port: " + port);
                System.out.println("[TechUI] Login: " + credentials);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    top.removeAll();
                }
            });
            System.out.println("[TechUI] Got connection details, connecting now...");
            try {
                wrongPassword = false;
                Time.time();
                if (defaultCredentials != null) {
                    credentials.setSessionToken(defaultCredentials.getSessionToken());
                }
                this.init(Language.DEFLANG_ID, host, port, credentials, isDefaultPassword);
                success = true;
            }
            catch (Exception ex) {
                System.out.println(Time.time());
                System.out.println("[TechUI] Login failed - " + ex);
                ex.printStackTrace();
                success = false;
                wrongPassword = ex instanceof TechClient.WrongPasswordException;
                credentials = null;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TechUi.this.main.removeAll();
                    }
                });
            }
        }
    }

    public NotificationPanel getNotificationPanel() {
        return this.mainPanelWithNotification;
    }

    private void initUIPreTechClientConnect() {
        new NotifierController(Language.DEFLANG);
        if (Switches.TECH_NOTIFY_ACTION) {
            TargetRepository.INSTANCE.addTarget("NotifyTechTarget", NotifyTechTarget.class);
        }
        if (Switches.TECH_RUN_TOOL_ACTION) {
            TargetRepository.INSTANCE.addTarget("RunToolTarget", RunToolTarget.class);
        }
        this.binvite = new ShPopupMenuButton(Language.get("INVITE_USER"), ImageLoader.getImageIcon("images/svg/general/invite.svg,20")){

            @Override
            public JPopupMenu getPopupMenu() {
                return TechUi.this.getInviteOptionsMenu();
            }
        };
        this.binvite.addActionListener(this);
        this.customerQueuePanel = new CustomerQueuePanel(true);
        JPanel leftButtonsPanel = this.customerQueuePanel.getLeftButtonsPanel();
        GbPanelWrapper wrapper = new GbPanelWrapper(leftButtonsPanel);
        wrapper.add(this.binvite, 0, 0, 1, 1, 1, 0, 17, 0);
        this.customerConnectedPanel = new CustomerQueuePanel(false);
        TimerPanel timer = new TimerPanel(SHPreloadUI.PRELOADING);
        timer.showZeroData(false);
        timer.setFont(timer.getFont().deriveFont(0));
        NodeLinkStatus nodelinkStatus = new NodeLinkStatus(Language.DEFLANG, SHPreloadUI.PRELOADING);
        DualNodeLinkStatus dualNodeLinkStatus_temp = new DualNodeLinkStatus(nodelinkStatus, timer);
        this.connectListener = new TechUIConnectListener();
        this.dualNodeLinkStatus = new DualNodeLinkStatus(dualNodeLinkStatus_temp, this.connectListener);
        this.lower = new JPanel();
        this.lower.setBorder(new CompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, SHStyle.BORDER_COLOR), new EmptyBorder(1, 1, 1, 1)));
        this.lower.setLayout(new GridLayout(1, 3));
        String version = ClientBranding.get().getApplicationName(false);
        version = version + " " + Version.getExtendedUserFacing() + " ";
        JLabel versionLabel = new JLabel(version, 4);
        version = version + " [" + Version.getBuildDate() + "]";
        versionLabel.setToolTipText(version);
        JPanel licensePanel = this.getLicenseInfoPanel();
        this.lower.add(timer);
        this.lower.add(licensePanel);
        this.lower.add(versionLabel);
        GbPanel shCustomerPanel = new GbPanel();
        GbPanel shConnectedPanel = new GbPanel();
        this.sdemoPanel = new JPanel();
        this.customerSplitPane = new SHSplitPane(0);
        this.customerSplitPane.setDividerLocation(0.6);
        this.customerSplitPane.setLeftComponent(shCustomerPanel);
        this.customerSplitPane.setRightComponent(shConnectedPanel);
        this.customerSplitPane.setBorder(null);
        this.customerSplitPane.setResizeWeight(0.5);
        this.customerSplitPane.setOneTouchExpandable(false);
        this.customerSplitPane.setContinuousLayout(true);
        System.out.println("[TechUI] Creating customer table");
        shCustomerPanel.add(this.customerQueuePanel.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        shConnectedPanel.add(this.customerConnectedPanel.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        this.machineModel = new MachineTreeModel();
        this.alertModel = new AlertTreeModel();
        this.eventsModel = new ServerEventsTreeModel();
        this.historyPanelRoot = this.createHistoryPanel(this.machineModel);
        try {
            this.accessPanel = new AccessPanel(this.machineModel, this.alertModel, this);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        this.alertPanel = new AlertsPanel(this.alertModel, this.eventsModel, this.machineModel, this);
        this.sdemoPanel.setLayout(new GridLayout(1, 1));
        this.demoPanel = new DemoConfigPanel(this.rpc);
        this.sdemoPanel.add(this.demoPanel);
        System.out.println("[TechUI] Creating tech preferences");
        this.preferencesTab = new TechOptionsPanel(this);
        System.out.println("[TechUI] Creating toolbox preferences");
        this.toolboxTab = new ToolBoxPropertiesPanel();
        System.out.println("[TechUI] Creating admin tab");
        this.adminTab = new AdministrationTab(this.rpc);
        this.tabs.setBorder(SHBorderFactory.createEmptyBorder());
        this.tabs.addChangeListener(new ChangeListener(){
            JComponent previousSelectedTabComponent;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.previousSelectedTabComponent != null && this.previousSelectedTabComponent == TechUi.this.adminTab.getRootComponent()) {
                    TechUi.this.adminTab.saveIfRequired();
                }
                if (TechUi.this.tabs.getSelectedComponent() == TechUi.this.adminTab.getRootComponent()) {
                    TechUi.this.adminTab.tabActive();
                }
                if (TechUi.this.tabs.getSelectedComponent() == TechUi.this.historyPanel.getRootComponent()) {
                    TechUi.this.historyPanel.refreshCurrentSearch();
                }
                this.previousSelectedTabComponent = TechUi.this.tabs.getSelectedComponent();
            }
        });
        this.timerUpdaterThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        TechUi.this.incrementCustomerWaitingTimes();
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        this.timerUpdaterThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String curlang, String host, String port, TechCredentials credentials, boolean isDefaultPassword) throws Exception {
        try {
            System.out.println("[TechUi] Initialising Technician UI");
            long start = System.currentTimeMillis();
            this.isDefaultPassword = isDefaultPassword;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TechUi.this.mainPanelWithNotification = new NotificationPanel(TechUi.this.main);
                    TechUi.this.mainPanelWithNotification.setDefaultWidth(SimpleHelpLookAndFeel.scale(800));
                    TechUi.this.top.setLayout(new GridLayout(1, 1));
                    TechUi.this.top.add(TechUi.this.mainPanelWithNotification.getRootComponent());
                    TechUi.this.top.setBackground(SHStyle.TECH_BACKGROUND);
                    TechUi.this.main.setLayout(new BorderLayout());
                    CircularProgressLabel connectingLabel = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_48);
                    connectingLabel.setFont(SHStyle.mediumFont);
                    connectingLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
                    connectingLabel.setIconTextGap(20);
                    String s = Language.get("CONNECTING");
                    s = s.replace("...", "");
                    connectingLabel.setText(s);
                    connectingLabel.setHorizontalTextPosition(0);
                    connectingLabel.setVerticalTextPosition(3);
                    GbPanel progressPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
                    progressPanel.setBackground(SHStyle.TECH_BACKGROUND);
                    progressPanel.add(connectingLabel, 1, 0, 1, 1, 0, 0, 17, 0);
                    TechUi.this.main.add("Center", progressPanel);
                    TechUi.this.main.setBackground(SHStyle.TECH_BACKGROUND);
                    TechUi.this.mainPanelWithNotification.getRootComponent().revalidate();
                    TechUi.this.mainPanelWithNotification.getRootComponent().repaint();
                }
            });
            System.out.println("[TechUI] Creating TechClient");
            int[] messageIDsToPrefetch = new int[]{12000, 13000, 15000, 14000, 7000, 40000, 16000, 100000, 108000, 34200};
            this.client = new TechClient(curlang, Language.DEFLANG, host, Integer.parseInt(port), credentials, false, this, this.dualNodeLinkStatus, messageIDsToPrefetch);
            LogGatherer.loadListener();
            LogGatherer.setTechClient(this.client);
            LogGatherer.setFrame(this.rpc);
            this.asyncUIThread.join();
            this.customerQueuePanel.setTechClient(this.client);
            this.customerConnectedPanel.setTechClient(this.client);
            System.out.println("[TechUI] Updating server management");
            this.client.updateServerManagement();
            String[] customerDetails = this.client.getCurrentlyConfiguredDetails();
            System.out.println("[TechUI] Populating invitation client");
            this.invitationClient = new InvitationClient(this.rpc, this.client, this.client.getVirtualServerHostname());
            if (this.dualNodeLinkStatus != null) {
                this.client.setLinkStatusListener(this.dualNodeLinkStatus);
            }
            Object object = this.CUSTOMER_LIST_LOCK;
            synchronized (object) {
                this.customersWaiting = this.client.getAdvancedCustomerList();
                this.customerQueuePanel.setCoreDetails(customerDetails);
                this.customerQueuePanel.setCustomers(this.customersWaiting);
            }
            System.out.println("[TechUI] Populating customer connected table");
            object = this.CUSTOMER_CONNECTED_LOCK;
            synchronized (object) {
                this.customersConnected = this.client.getAdvancedConnectedList();
                String[] appendedDetails = new String[customerDetails.length + 1];
                System.arraycopy(customerDetails, 0, appendedDetails, 0, customerDetails.length);
                appendedDetails[customerDetails.length] = Language.get("TECHNICIAN");
                this.customerConnectedPanel.setCoreDetails(appendedDetails);
                this.customersConnected = this.filterListAccordingToPermissions(this.customersConnected);
                this.customerConnectedPanel.setSessions(this.customersConnected);
            }
            System.out.println("[TechUI] Populating available machine tree");
            this.machineModel.setTechClient(this.client);
            this.accessPanel.setTechClient(this.client);
            this.alertModel.setTechClient(this.client);
            this.alertPanel.setTechClient(this.client);
            System.out.println("[TechUI] Populating demo UI");
            this.demoPanel.setTechClient(this.client);
            System.out.println("[TechUI] Populating tech preferences");
            this.preferencesTab.setTechClient(this.client);
            this.adminTab.setTechClient(this.client, this.machineModel);
            this.toolboxTab.setTechClient(this.client);
            this.toolBox = this.client.fetchToolBox();
            if (CentralDebugging.TOOLBOX_TECH) {
                System.out.println("[TechUI] Loaded toolbox:");
                System.out.println(this.toolBox.toXML());
            }
            this.toolboxTab.setToolBox(this.toolBox);
            this.accessPanel.setToolBox(this.toolBox);
            this.sessionUploader = new SessionUploader(this.client);
            if (this.client.getPermissions().mustAlwaysUpload()) {
                new ContinualVideoQueuer().start();
            }
            this.historyPanel.setTechClient(this.sessionUploader, this.client);
            this.configureTabs();
            if (this.client.getServerLicenseMode() == 3) {
                this.switchToMainUi();
            } else {
                this.switchToLicenseUi();
            }
            System.out.println("[TechUI] Total UI init time: " + (System.currentTimeMillis() - start) + "ms");
            try {
                this.client.ignoreSubscribeSends(true);
                object = this.machineModel;
                synchronized (object) {
                    this.machineModel.addElements(this.client.getEntireMachineList_Expensive());
                }
            }
            finally {
                this.client.ignoreSubscribeSends(false);
                this.client.sendSubscribeList();
            }
            this.machineModel.addSessions(this.client.getRemoteAccessSessions_Expensive());
            try {
                ResourceContainer[] entireAlertList_Expensive = this.client.getEntireAlertList_Expensive();
                ArrayList<LocatedAlert> alertList = new ArrayList<LocatedAlert>();
                ArrayList<ServerEvent> eventList = new ArrayList<ServerEvent>();
                for (ResourceContainer rc : entireAlertList_Expensive) {
                    if (rc instanceof LocatedAlert) {
                        alertList.add((LocatedAlert)rc);
                        continue;
                    }
                    if (!(rc instanceof ServerEvent)) continue;
                    eventList.add((ServerEvent)rc);
                }
                System.out.println("[TechUI] Loaded Alert List of size: " + alertList.size());
                System.out.println("[TechUI] Loaded Event List of size: " + eventList.size());
                this.alertModel.addElements(alertList.toArray(new LocatedAlert[0]));
                this.eventsModel.addElements(eventList.toArray(new ServerEvent[0]));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.startPostLoginThread();
            if (Testing.amTesting()) {
                new Thread(new TestingThread()).start();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            SHGlassOptionPane.showErrorDialog(this.rpc, Language.get("INVALID_LOGIN_PORT") + " (port=" + port + ")", Language.get("INVALID_LOGIN_PORT"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            throw e;
        }
        catch (TechClient.WrongPasswordException e) {
            throw e;
        }
        catch (TechClient.QuitLoginException e) {
            throw e;
        }
        catch (ConnectException e) {
            e.printStackTrace();
            ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(this.rpc, Language.get("ERROR_WHILE_CONNECTING"), null, true, true);
            dialog.setText("The technician console failed to connect.", "The technician console could not establish a connection to " + host + ":" + port + ".", null);
            dialog.setVisible(true);
            throw e;
        }
        catch (BCUtil.ServerAuthenticityException e) {
            e.printStackTrace();
            new ServerAuthenticityErrorDialog(this.rpc);
        }
        catch (TwoTierCodeEntryGlassDialog.SwitchUserException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            String reason = null;
            if (this.preloaderFailed != null) {
                reason = StackTracer.getStacktrace(this.preloaderFailed);
            }
            ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(this.rpc, Language.get("ERROR_WHILE_CONNECTING"), null, true, true);
            String msg = e.getMessage();
            if (msg == null) {
                dialog.setText("The technician console failed to load.", "An unexpected error has been encountered. Please notify contact@simple-help.com.<BR>(" + e.getClass().getSimpleName() + ")", reason);
            } else {
                dialog.setText("The technician console failed to load.", "An unexpected error has been encountered. Please notify contact@simple-help.com.<BR>(" + e.getClass().getSimpleName() + "," + msg + ")", reason);
            }
            dialog.setVisible(true);
            e.printStackTrace();
            throw e;
        }
    }

    private void startPostLoginThread() {
        new Thread("TechUI-PostLogin"){

            @Override
            public void run() {
                try {
                    Notification[] notifications;
                    for (Notification n : notifications = TechUi.this.client.loadAllNotifications()) {
                        ClientNotificationUtil.localiseNotification(n);
                    }
                    TechUi.this.notificationPanel.load(notifications);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }.start();
    }

    public void configureTabs() {
        Icon selectedIcon = this.tabs.getSelectedIcon();
        this.tabs.removeAll();
        if (PresentKeyset.isEnabled()) {
            System.out.println("[TechUI] Setting presentation tab to primary view (no tabs - Present Only app profile)");
            this.tabsHolder = this.sdemoPanel;
        } else {
            boolean showLogoutButton;
            if (!GroupAccessKeyset.isEnabled()) {
                if (this.client.isMonitoringOnly()) {
                    System.out.println("[TechUI] Adding support tab (forced)");
                    this.tabs.addTab(Language.get("SUPPORT_TAB"), ImageLoader.getImageIcon("images/svg/users/queue.svg,24"), new GrayedOutTab(this.customerSplitPane, Language.get("UPSELL_NO_SESSION")));
                } else if (ServerManagement.isSimpleHelp() && this.client.getPermissions().canRemoteSupport()) {
                    System.out.println("[TechUI] Adding support tab");
                    this.tabs.addTab(Language.get("SUPPORT_TAB"), ImageLoader.getImageIcon("images/svg/users/queue.svg,24"), this.customerSplitPane);
                }
            }
            if (ServerManagement.isSimpleGateway() && this.client.getPermissions().canRemoteAccess()) {
                System.out.println("[TechUI] Adding access tab");
                this.tabs.addTab(Language.get("ACCESS_TAB"), ImageLoader.getImageIcon("images/svg/technology/screen.svg,24"), this.accessPanel.getRootComponent());
            }
            if (!GroupAccessKeyset.isEnabled()) {
                if (this.client.getPermissions().canManageAlerts() || this.client.getPermissions().canManageServerEvents() || this.client.getPermissions().canViewAllAlerts()) {
                    System.out.println("[TechUI] Adding alert tab");
                    this.tabs.addTab(Language.get("ALERT_TAB"), ImageLoader.getImageIcon("images/svg/alert-flags/yellow.svg,24"), this.alertPanel.getRootComponent());
                }
                if (OemBranding.OEM_IS_SH) {
                    if (this.client.isMonitoringOnly()) {
                        System.out.println("[TechUI] Adding presentation tab (forced)");
                        this.tabs.addTab(Language.get("PRESENT"), ImageLoader.getImageIcon("images/svg/general/bullhorn.svg,24"), new GrayedOutTab(this.sdemoPanel, Language.get("UPSELL_NO_PRESENT")));
                    } else if (ServerManagement.isSimpleDemo() && this.client.getPermissions().canPresent()) {
                        System.out.println("[TechUI] Adding presentation tab");
                        this.tabs.addTab(Language.get("PRESENT"), ImageLoader.getImageIcon("images/svg/general/bullhorn.svg,24"), this.sdemoPanel);
                    }
                }
                if (this.client.getPermissions().showHistoryTab()) {
                    if (this.client.isMonitoringOnly()) {
                        this.tabs.addTab(Language.get("HISTORY"), ImageLoader.getImageIcon("images/svg/general/clock-simple.svg,24"), new GrayedOutTab(this.historyPanelRoot, Language.get("UPSELL_NO_HISTORY")));
                    } else {
                        this.tabs.addTab(Language.get("HISTORY"), ImageLoader.getImageIcon("images/svg/general/clock-simple.svg,24"), this.historyPanelRoot);
                    }
                }
            }
            if (!GroupAccessKeyset.isEnabled() && this.client.canAdministerServer() && (this.client.allowsProvider() || TrialUtils.amTriallingBizOrEnt())) {
                AppProfileUI apu = new AppProfileUI(this.rpc, this.client);
                this.tabs.addTab(Language.get("PROVIDER_TAB"), ImageLoader.getImageIcon("images/svg/general/buildings.svg,24"), apu.getRootComponent(), false, false);
            }
            if (!GroupAccessKeyset.isEnabled()) {
                System.out.println("[TechUI] Adding toolbox");
                this.tabs.addTab(Language.get("TOOLBOX_TAB"), ImageLoader.getImageIcon("images/svg/general/box.svg,24"), this.toolboxTab.getRootComponent(), false, false);
            }
            this.notificationPanel = new SideNotificationPanel(this);
            this.notificationPanel.getRootComponent().setBorder(new LeftShadowBorder());
            this.notificationPanel.getRootComponent().setOpaque(false);
            if (this.notificationPanel != null) {
                this.notificationPanel.setTechClient(this.client);
            }
            boolean bl = showLogoutButton = !this.isDefaultPassword;
            if (!showLogoutButton) {
                this.preferencesTab.hideLogoutButton();
            }
            System.out.println("[TechUI] Adding technician preferences console");
            if (GroupAccessKeyset.isEnabled()) {
                this.tabs.addTab(Language.get("PREFERENCES"), ImageLoader.getImageIcon("images/svg/general/preferences.svg,24"), this.preferencesTab);
            } else {
                this.tabs.addTab(Language.get("PREFERENCES"), ImageLoader.getImageIcon("images/svg/general/preferences.svg,24"), this.preferencesTab, false, false);
            }
            if (!GroupAccessKeyset.isEnabled()) {
                this.tabs.addRightButton(Language.get("NOTIFICATIONS"), ImageLoader.getImageIcon("images/svg/chat/chat-single.svg,24"), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TechUi.this.flipNotificationPanel();
                    }
                });
            }
        }
        if (!GroupAccessKeyset.isEnabled() && (this.client.canAdministerServer() || this.client.getTechUser().canAdministerGroup)) {
            System.out.println("[TechUI] Adding administration console");
            this.tabs.addTab(Language.get("ADMINISTRATION_TAB"), ImageLoader.getImageIcon("images/svg/general/gear.svg,24"), this.adminTab.getRootComponent());
        }
        this.tabs.selectTab(selectedIcon);
    }

    private void switchToLicenseUi() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("[TechUI] Switching to License Setup UI");
                System.out.println("[TechUI] Updating Frame");
                System.out.flush();
                System.err.flush();
                TechUi.this.main.removeAll();
                TechUi.this.main.add("Center", new NoLicensePane(TechUi.this.client, TechUi.this.client.getServerLicenseMode(), TechUi.this));
                TechUi.this.main.revalidate();
                TechUi.this.top.validate();
                TechUi.this.top.repaint();
            }
        });
    }

    public void switchToMainUi() {
        if (this.showingMainUi) {
            return;
        }
        this.showingMainUi = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("[TechUI] Switching to Standard Tabs UI");
                System.out.println("[TechUI] Updating Frame");
                System.out.flush();
                System.err.flush();
                TechUi.this.main.removeAll();
                TechUi.this.main.add("Center", TechUi.this.tabsHolder);
                TechUi.this.main.add("South", TechUi.this.lower);
                TechUi.this.main.revalidate();
                TechUi.this.top.repaint();
                if (TechUi.this.isDefaultPassword) {
                    TechUi.this.showDefaultPasswordDialog();
                }
                if (TechUi.this.client.shouldShowBackupWarning()) {
                    TechUi.this.getNotificationPanel().showWarning(Language.get("ADMIN_BACKUP_TC_WARNING"), null, true);
                }
            }
        });
    }

    public void reconnectTechnician() throws Exception {
        System.out.println("[TechUI] Forced reconnect");
        this.client.reconnect(false, this.dualNodeLinkStatus);
        try {
            this.machineModel.addElements(this.client.getEntireMachineList_Expensive());
            this.machineModel.addSessions(this.client.getRemoteAccessSessions_Expensive());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void testCycleUi() {
        int N = this.tabs.getTabCount();
        for (int i = 0; i < N; ++i) {
            this.tabs.setSelectedIndex(i);
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!JWTestControl.amDeferred()) {
                JWTesting.reportScreenshot("TechUI Tab " + i, this.main, true);
            }
            if (this.tabs.getSelectedComponent() == this.accessPanel.getRootComponent()) {
                this.accessPanel.testCycleUi();
                continue;
            }
            if (this.tabs.getSelectedComponent() != this.historyPanel.getRootComponent()) continue;
            this.historyPanel.testCycleUi();
        }
        JWTesting.reportSuccess("TechUI Cycle UI");
    }

    private JComponent createHistoryPanel(MachineTreeModel machineModel) {
        this.historyPanel = new HistoryPanel(machineModel);
        return this.historyPanel.getRootComponent();
    }

    private SupportSession[] filterListAccordingToPermissions(SupportSession[] shConnectedList_metadata2) {
        if (this.client.getPermissions().canViewOtherConnectedSessions()) {
            return shConnectedList_metadata2;
        }
        if (this.client.getTechUser().isServerAdmin()) {
            return shConnectedList_metadata2;
        }
        ArrayList<SupportSession> filteredList = new ArrayList<SupportSession>();
        for (int i = 0; i < shConnectedList_metadata2.length; ++i) {
            SupportSession session = shConnectedList_metadata2[i];
            if (session == null || session.getTechnicianUsername() == null || !session.getTechnicianUsername().equals(this.client.getTechUser().username)) continue;
            filteredList.add(session);
        }
        SupportSession[] result = new SupportSession[filteredList.size()];
        filteredList.toArray(result);
        return result;
    }

    private JPanel getLicenseInfoPanel() {
        this.evaluationLabel.setForeground(Color.RED.darker());
        int X = 0;
        GbPanel panel = new GbPanel(new ScaledInsets(0, 3, 0, 3));
        panel.add(this.shLabel, X++, 0, 1, 1, 0, 1, 10, 3);
        panel.add(this.alertLabel, X++, 0, 1, 1, 0, 1, 10, 3);
        panel.add(this.evaluationLabel, X++, 0, 1, 1, 0, 1, 10, 3, new Insets(0, 7, 0, 0));
        this.alertOrigColor = this.alertLabel.getForeground();
        return panel;
    }

    private void showDefaultPasswordDialog() {
        WelcomeDialog dialog = new WelcomeDialog(this.rpc, this.client);
        dialog.showDialog();
        if (dialog.isOK() && dialog.restartRequired()) {
            try {
                JWSystem.forkVirtualApp(JWSystem.getMyAppName(), null, null, false, true);
                Thread.sleep(1000L);
                System.exit(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customerLiveListChanged() {
        Debugger.info("Live list changed");
        if (this.client == null) {
            return;
        }
        if (this.isTestOrDebug) {
            return;
        }
        try {
            Object object = this.CUSTOMER_CONNECTED_LOCK;
            synchronized (object) {
                this.customersConnected = this.client.getAdvancedConnectedList();
                this.customersConnected = this.filterListAccordingToPermissions(this.customersConnected);
                if (this.customersConnected != null) {
                    this.customerConnectedPanel.setSessions(this.customersConnected);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setWarningMessage(Language.get("ERROR_FETCHING_CUSTOMER_LIST") + ": " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customerListChanged() {
        Debugger.info("Customer list changed");
        try {
            if (this.client == null) {
                return;
            }
            if (this.isTestOrDebug) {
                return;
            }
            Object object = this.CUSTOMER_LIST_LOCK;
            synchronized (object) {
                this.customersWaiting = this.client.getAdvancedCustomerList();
            }
            SwingUtilities.invokeAndWait(new SetCustomers());
            object = this.CUSTOMER_LIST_LOCK;
            synchronized (object) {
                NotifierController.INSTANCE.updateCustomerList(this.customersWaiting);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setWarningMessage(Language.get("ERROR_FETCHING_CUSTOMER_LIST") + ": " + e);
        }
    }

    @Override
    public void setWarningMessage(String text) {
        text = text.replace("CONNECTED_SESSIONS", Language.get("CONNECTED_SESSIONS"));
        text = text.replace("EVAL_ALLOWED_NOLIMIT", Language.get("EVAL_ALLOWED_NOLIMIT"));
        text = text.replace("LIC_ALLOWED_NOLIMIT", Language.get("LIC_ALLOWED_NOLIMIT"));
        text = text.replace("EVAL_ALLOWED_LIMIT", Language.get("EVAL_ALLOWED_LIMIT"));
        text = text.replace("LIC_ALLOWED_LIMIT", Language.get("LIC_ALLOWED_LIMIT"));
        text = text.replace("VALID_LICENSE_EXPIRED", Language.get("VALID_LICENSE_EXPIRED"));
        Debugger.info("Set warning message - " + text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.binvite.getSourceButton()) {
            this.doInvitation();
        }
    }

    private void doInvitation() {
        this.invitationClient.showInvitationRepository();
    }

    @Override
    public void demoListChanged() {
        if (this.demoPanel != null) {
            this.demoPanel.demoListChanged();
        }
    }

    @Override
    public void updateSessionCounts(boolean isJoinedSessionCounts, boolean isEvaluation, boolean isPlan2, int allSessions, int maxSHSessions, int maxSGSessions, int alertedMachines, int alertLimit, int regMachines, int machineLimit) {
        if (isEvaluation) {
            this.evaluationLabel.setText(Language.get("EVALUATION"));
        } else {
            this.evaluationLabel.setText("");
        }
        String previous = this.shLabel.getText();
        this.shLabel.setText(allSessions + "/" + maxSHSessions + "   ");
        if (previous == null || !previous.equals(this.shLabel.getText())) {
            System.out.println("[TechClient] Received new session limits (active: " + allSessions + " sh:" + maxSHSessions + ")");
        }
        this.shLabel.setIcon(ImageLoader.getImageIcon("images/svg/security/key.svg,16"));
        if (this.client != null && !GroupAccessKeyset.isEnabled()) {
            if (alertLimit == 0 && TrialUtils.getTU().amTrialling(TrialUtil.FEATURE_BIZ)) {
                alertLimit = 5000;
            }
            if (isPlan2) {
                this.alertLabel.setIcon(ImageLoader.getImageIcon("images/svg/technology/screen.svg,16"));
                if (machineLimit > 1000000) {
                    this.alertLabel.setText("" + regMachines);
                    this.alertLabel.setForeground(this.shLabel.getForeground());
                } else {
                    this.alertLabel.setText(regMachines + "/" + machineLimit);
                    if (regMachines > machineLimit) {
                        this.alertLabel.setForeground(Color.red.darker());
                    } else {
                        this.alertLabel.setForeground(this.shLabel.getForeground());
                    }
                }
            } else if (this.client.getServerLicense().isPlan1Management()) {
                this.alertLabel.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/yellow.svg,16"));
                this.alertLabel.setText(alertedMachines + "/" + alertLimit);
                if (alertedMachines > alertLimit) {
                    this.alertLabel.setForeground(Color.red.darker());
                } else {
                    this.alertLabel.setForeground(this.shLabel.getForeground());
                }
            }
        }
        if (this.adminTab != null) {
            this.adminTab.updateSessionLimit();
        }
    }

    @Override
    public TechClientListener.TwoTierResponse processAuthenticationChallenge(boolean showIncorrectWarning, String replyMessage) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
        TOTPCodeEntryGlassDialog dialog = new TOTPCodeEntryGlassDialog(this.rpc, showIncorrectWarning, false, replyMessage);
        return dialog.getCode();
    }

    @Override
    public TechClientListener.TwoTierResponse requestTwoTierCode(boolean showIncorrectWarning, String techEmailAddress, boolean allowRemember) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
        if (techEmailAddress != null) {
            TwoTierCodeEntryGlassDialog dialog = new TwoTierCodeEntryGlassDialog(this.rpc, showIncorrectWarning, techEmailAddress, allowRemember);
            return dialog.getCode();
        }
        TOTPCodeEntryGlassDialog dialog = new TOTPCodeEntryGlassDialog(this.rpc, showIncorrectWarning, allowRemember);
        return dialog.getCode();
    }

    @Override
    public void machineAdded(Machine machine) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] Added: " + machine);
        }
        this.machineModel.addElements(new Machine[]{machine});
    }

    @Override
    public void machineRemoved(Machine machine) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] Removed: " + machine);
        }
        this.machineModel.removeElements(new Machine[]{machine});
    }

    @Override
    public void machinesAdded(Machine[] machine) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] Added: " + machine.length + " machines");
        }
        this.machineModel.addElements(machine);
    }

    @Override
    public void machinesRemoved(Machine[] machine) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] Removed: " + machine.length + " machines");
        }
        this.machineModel.removeElements(machine);
    }

    @Override
    public void machineOnline(Machine machine) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] Online: " + machine);
        }
        this.updateMachine(machine);
    }

    @Override
    public void machineOffline(Machine machine) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] Offline: " + machine);
        }
        this.updateMachine(machine);
    }

    @Override
    public void machineDataChanged(Machine machine) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] DataChanged: " + machine);
        }
        this.updateMachine(machine);
    }

    @Override
    public void machineFilterableInfoChanged(Machine machine) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] FilterableInfo: " + machine);
        }
        this.updateMachine(machine);
    }

    @Override
    public void sessionAdded(AccessSession session) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] SessionAdded: " + session);
        }
        this.machineModel.addSessions(new AccessSession[]{session});
    }

    @Override
    public void sessionRemoved(AccessSession session) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Machine] SessionRemoved: " + session);
        }
        this.machineModel.removeSessions(new AccessSession[]{session});
    }

    @Override
    public void alertAdded(ResourceContainer alert) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Alert] Added: " + alert);
        }
        if (alert instanceof LocatedAlert) {
            this.alertModel.addElements(new ResourceContainer[]{alert});
        } else if (alert instanceof ServerEvent) {
            this.eventsModel.addElements(new ResourceContainer[]{alert});
        } else {
            System.out.println("[TechUI] WARNING: Unknown alert type added " + alert.getClass());
        }
    }

    @Override
    public void alertRemoved(ResourceContainer alert) {
        if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
            System.out.println("[TechUI][Alert] Removed: " + alert);
        }
        if (alert instanceof LocatedAlert) {
            this.alertModel.removeElements(new ResourceContainer[]{alert});
        } else if (alert instanceof ServerEvent) {
            this.eventsModel.removeElements(new ResourceContainer[]{alert});
        } else {
            System.out.println("[TechUI] WARNING: Unknown alert type removed " + alert.getClass());
        }
    }

    public void updateMachine(String id) {
        this.updateMachine((Machine)this.machineModel.getElementWithID(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMachine(Machine machine) {
        if (machine == null) {
            return;
        }
        Object object = this.machinesToUpdate_LOCK;
        synchronized (object) {
            int size = this.machinesToUpdate.size();
            this.machinesToUpdate.put(machine.getID(), machine);
            size = this.machinesToUpdate.size() - size;
            if (size == 0) {
                ++this.dups;
            }
            new BatchingTimedThread(this.machineUpdates){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runNow() {
                    int mydups = TechUi.this.dups;
                    long Tupdate = System.currentTimeMillis();
                    Object[] objectArray = TechUi.this.machinesToUpdate_LOCK;
                    synchronized (TechUi.this.machinesToUpdate_LOCK) {
                        int mysize = TechUi.this.machinesToUpdate.size();
                        Object[] machines = TechUi.this.machinesToUpdate.values().toArray();
                        TechUi.this.machinesToUpdate.clear();
                        TechUi.this.dups = 0;
                        // ** MonitorExit[var6_3] (shouldn't be in output)
                        for (Object oid : machines) {
                            Machine machine = (Machine)oid;
                            try {
                                TechUi.this.machineModel.updateMachine(machine);
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                        }
                        Tupdate = System.currentTimeMillis() - Tupdate;
                        if (Tupdate > 200L) {
                            System.out.println("[TechUI] Machine updates took " + Tupdate + "ms, " + mysize + " machines, " + mydups + " dups");
                        }
                        return;
                    }
                }
            }.startIfNecessary();
        }
    }

    @Override
    public void alertChanged(ResourceContainer alert) {
        if (alert instanceof LocatedAlert) {
            this.alertModel.updateMachine(alert);
            this.alertPanel.alertChanged((LocatedAlert)alert);
            if (!Switches.SH_machineAlertUpdatesNotifiedSeparately) {
                ArrayList<String> ids = ((LocatedAlert)alert).getTriggeredMachines();
                for (String id : ids) {
                    this.updateMachine(id);
                }
            }
        } else if (alert instanceof ServerEvent) {
            this.eventsModel.updateMachine(alert);
        } else {
            System.out.println("[TechUI] WARNING: Unknown alert type changed " + alert.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementCustomerWaitingTimes() {
        Object object = this.CUSTOMER_LIST_LOCK;
        synchronized (object) {
            if (this.customersWaiting != null && this.customersWaiting.length > 0) {
                for (Customer customer : this.customersWaiting) {
                    customer.setWaitingFor(customer.getWaitingFor() + 1000L);
                }
                this.customerQueuePanel.update();
            }
        }
        object = this.CUSTOMER_CONNECTED_LOCK;
        synchronized (object) {
            if (this.customersConnected != null && this.customersConnected.length > 0) {
                this.customerConnectedPanel.update();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        NativeLibraryLoader.loadLibrary(new File("lib"));
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        CentralDebugging.loadDebugSettings("TechUITesting", true);
        JPanel main = new JPanel(new GridLayout(1, 1));
        main.setBackground(SHStyle.TECH_BACKGROUND);
        frame.getContentPane().add(main);
        frame.setVisible(true);
        TechUi techUi = new TechUi(frame, main, "localhost", "5401", false, null, null);
        System.out.println("TOOK " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        System.out.println("To create web transactor took " + (System.currentTimeMillis() - start));
        TaggedPrintStream outputStream = new TaggedPrintStream(System.out);
        System.setOut(outputStream);
        techUi.isTestOrDebug = true;
        techUi.isTestOrDebug = true;
        int size = 10;
        ArrayList testMachines = new ArrayList();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        try {
            System.out.println("[TechUI] Close detected. Cleaning up.");
            this.client.disconnect("techui window closed");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void peersChanged() {
        try {
            this.adminTab.peersChanged();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void licenseChanged() {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                System.out.println("[TechUi] License changed, configuring tabs");
                TechUi.this.configureTabs();
                if (TechUi.this.client.getServerLicenseMode() == 3 && !TechUi.this.showingMainUi) {
                    System.out.println("[TechUi] Switching to main UI");
                    TechUi.this.switchToMainUi();
                }
            }
        });
        try {
            this.adminTab.loadExistingConfigIntoUI();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void showAlert(LocatedAlert alert) {
        ResourceContainerGroup alertGroup = (ResourceContainerGroup)this.alertModel.getOrCreateGroup(alert.getName().getGroup());
        LocatedAlertSelection selection = new LocatedAlertSelection();
        selection.addMachines(alertGroup, new LocatedAlert[]{alert});
        this.alertPanel.setSelectedElements((Object)this, selection, true);
        this.alertPanel.ensureElementSelected(alertGroup, alert);
        this.tabs.setSelectedComponent(this.alertPanel.getRootComponent());
    }

    public void showMachine(String machineID) {
        Machine machine = (Machine)this.machineModel.getElementWithID(machineID);
        if (machine != null) {
            this.showMachine(machine);
        }
    }

    @Override
    public void showMachine(final Machine machine) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MachineGroup machineGroup = (MachineGroup)TechUi.this.machineModel.getOrCreateGroup(machine.getName().getGroup());
                MachineSelection selection = new MachineSelection();
                selection.addMachines(machineGroup, new Machine[]{machine});
                TechUi.this.accessPanel.setSelectedElements((Object)this, selection, true);
                TechUi.this.accessPanel.ensureElementSelected(machineGroup, machine);
                TechUi.this.tabs.setSelectedComponent(TechUi.this.accessPanel.getRootComponent());
            }
        });
    }

    @Override
    public long mustFailoverTo(String newURL, long maxDelay, long autoSwitchTimeMS) {
        System.out.println("[Tech-HAF] Asked to fail over to " + newURL);
        FailoverDialog dialog = new FailoverDialog(this.rpc, maxDelay, autoSwitchTimeMS);
        dialog.showDialog();
        long option = dialog.getSelectedDelay();
        if (option < 0L) {
            option = 0L;
        }
        System.out.println("[Tech-HAF] User requested delay of " + option);
        return option;
    }

    @Override
    public void prepareForRelaunch(String newURL) {
        System.out.println("[TechUi] Failover switch about to happen - setting properties");
        if (this.client != null) {
            TechCredentials techCredentials = this.client.getTechCredentials();
            JWLaunchProperties.overrideDynamicProperty("technician", techCredentials.getUsername());
            JWLaunchProperties.overrideDynamicProperty("password", techCredentials.getPassword());
            JWLaunchProperties.overrideDynamicProperty("sid", HexData.byteArrayToHexString(techCredentials.getSessionToken()));
        }
    }

    private void flipNotificationPanel() {
        JLayeredPane parentLayeredPane = SwingUtil.getParentLayeredPane(this.main);
        if (this.notificationPanel == null) {
            this.notificationPanel = new SideNotificationPanel(this);
            this.notificationPanel.getRootComponent().setBorder(SHBorderFactory.createMatteBorder(0, 1, 0, 0, SHStyle.BORDER_COLOR));
        } else if (SwingUtil.containsComponent(parentLayeredPane, this.notificationPanel.getRootComponent())) {
            parentLayeredPane.remove(this.notificationPanel.getRootComponent());
            parentLayeredPane.repaint();
            return;
        }
        Rectangle r = this.tabs.getContentPanel().getBounds();
        this.notificationPanel.getRootComponent().setBounds(r.x + r.width - NOTIFICATION_PANEL_WIDTH, r.y, NOTIFICATION_PANEL_WIDTH, r.height);
        this.notificationPanel.getRootComponent().revalidate();
        parentLayeredPane.add((Component)this.notificationPanel.getRootComponent(), JLayeredPane.MODAL_LAYER);
        parentLayeredPane.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.notificationPanel == null) {
            return;
        }
        Rectangle r = this.tabs.getContentPanel().getBounds();
        this.notificationPanel.getRootComponent().setBounds(r.x + r.width - NOTIFICATION_PANEL_WIDTH, r.y, NOTIFICATION_PANEL_WIDTH, r.height);
        this.notificationPanel.getRootComponent().revalidate();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void newNotificationReceived(Notification newNotification) {
        this.notificationPanel.addNotification(newNotification);
        this.updateUnreadNotificationCount();
    }

    public void updateUnreadNotificationCount() {
        int unreadCount = this.notificationPanel.getUnreadCount();
        this.tabs.setTabCounter(Language.get("NOTIFICATIONS"), unreadCount);
    }

    @Override
    public void sgUpdatingDuringConnect() {
    }

    @Override
    public long requestAppAuthenticationSetup(String totpKey, String totpUsername, String hostname, int length) {
        if (this.totpAuthenticationPanelHandle == null) {
            this.totpAuthenticationPanelHandle = new PanelGlassDialog(this.rpc, Language.get("GROUP_APP"), 650, null, null);
            this.registrationPanel = new TOTPRegistrationPanel(totpKey, length, totpUsername, hostname, ClientBranding.get().getApplicationName(true));
            this.totpAuthenticationPanelHandle.setContentPanel(this.registrationPanel.getRootComponent());
            this.totpAuthenticationPanelHandle.showDialog();
        } else {
            this.registrationPanel.setError();
        }
        String enteredCode = this.registrationPanel.getEnteredCode();
        if (enteredCode != null) {
            return Long.parseLong(enteredCode);
        }
        return -1L;
    }

    @Override
    public void closeAppAuthenticationSetup() {
        this.registrationPanel.setOK();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.totpAuthenticationPanelHandle.okPressed();
        this.registrationPanel = null;
        this.totpAuthenticationPanelHandle = null;
    }

    @Override
    public void configChanged() {
        this.adminTab.fetchConfigFromServer();
    }

    @Override
    public void waitingForRemoteUserToAccept() {
    }

    static {
        testRun = false;
    }

    class ContinualVideoQueuer
    extends Thread {
        ContinualVideoQueuer() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                TechVideoRepository.TechVideoIterator videoIterator = TechVideoRepository.getVideoIterator();
                while (true) {
                    if (!videoIterator.hasNext()) continue block4;
                    File target = videoIterator.next();
                    System.out.println("[TechUI] Found video file " + target);
                    File fileToLock = TechVideoRepository.getLockFileFor(target);
                    System.out.println("[TechUI] Found lock file " + fileToLock);
                    if (!FileLockUtil.isFileCurrentlyLocked(fileToLock)) {
                        String sessionID = VideoUtils.getSessionIDFromFileName(target);
                        try {
                            long startTime = VideoUtils.getStartTimeFromFileName(target);
                            TechUi.this.sessionUploader.addFileToUpload(sessionID, startTime, target);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        continue;
                    }
                    System.out.println("[TechUI] " + target + " is locked. Skipping for now...");
                }
                break;
            }
        }
    }

    class TechUIConnectListener
    implements NodeLinkStatusListener,
    DisconnectedDialog.DisconnectedListener {
        private DisconnectedDialog dialog = null;
        private final Object DIALOG_LOCK = new Object();
        private boolean ignore = false;

        TechUIConnectListener() {
        }

        public void setIgnore(boolean ignore) {
            this.ignore = ignore;
        }

        @Override
        public void linkDown(NodeLink link, Throwable reason) {
            this.show(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void show(boolean isDead) {
            Object object = this.DIALOG_LOCK;
            synchronized (object) {
                if (this.ignore) {
                    return;
                }
                if (this.dialog != null) {
                    this.dialog.setIsDead(isDead);
                } else {
                    this.dialog = new DisconnectedDialog(TechUi.this.rpc, this, isDead, SHJWUtil.getUpdateURLProtocol() + "://" + TechUi.this.client.getHost() + ":" + TechUi.this.client.getPort() + "/version");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void linkOK(NodeLink link) {
            Object object = this.DIALOG_LOCK;
            synchronized (object) {
                if (this.dialog != null) {
                    this.dialog.setVisible(false);
                    this.dialog = null;
                }
            }
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            this.show(true);
        }

        @Override
        public void doReconnect() throws Exception {
            TechUi.this.reconnectTechnician();
        }

        @Override
        public void doLogout() {
            TechUi.this.logoutTechnician(false);
            this.dialog.setVisible(false);
        }
    }

    public static interface LogoutListener {
        public void logout();
    }

    class SetCustomers
    implements Runnable {
        SetCustomers() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = TechUi.this.CUSTOMER_LIST_LOCK;
            synchronized (object) {
                TechUi.this.customerQueuePanel.setCustomers(TechUi.this.customersWaiting);
            }
        }
    }

    public static class WelcomeDialog
    extends PanelGlassDialog {
        private final TechWelcomePane welcomePane;

        public boolean showDecoration() {
            return false;
        }

        public WelcomeDialog(RootPaneContainer rootPane, TechClient client) {
            super(rootPane, Language.get("DEFAULT_PASSWORD_TITLE_SH"), 600, Language.get("GET_STARTED"), null);
            this.setBackground(Color.white);
            this.welcomePane = new TechWelcomePane(client){

                @Override
                protected void setRestartButtonText(String text) {
                    WelcomeDialog.this.setOkButtonText(text);
                }
            };
            this.setContentPanel(this.welcomePane);
        }

        public boolean restartRequired() {
            return this.welcomePane.getRestartRequired();
        }
    }

    class TestingThread
    implements Runnable,
    JWTestable {
        TestingThread() {
        }

        @Override
        public void run() {
            block19: {
                if (testRun) {
                    return;
                }
                testRun = true;
                try {
                    System.out.println("[Testing] Testing TechUI");
                    JWTesting.reportSuccess("TechUI Login");
                    JWTesting.reportScreenshot("TechUI Login", TechUi.this.main, false);
                    if (Testing.queryTestingBoolean("TEST_QUIT_TECHUI_AFTER_LOGIN")) {
                        int sleep = (int)(Math.random() * 60000.0);
                        System.out.println("[Testing] TechUI, will quit after " + sleep);
                        JWAutomate.sleep(sleep);
                        System.out.println("[Testing] TechUI, quitting");
                        System.exit(0);
                        break block19;
                    }
                    if (Testing.queryTestingBoolean("TEST_CLOSE_TECHUI_AFTER_LOGIN")) {
                        int sleep = (int)(Math.random() * 60000.0);
                        System.out.println("[Testing] TechUI, will close gracefully after " + sleep);
                        JWAutomate.sleep(sleep);
                        try {
                            System.out.println("[Testing] TechUI closing gracefully now");
                            TechUi.this.client.disconnect("test techUI closing gracefully");
                            JWAutomate.sleep(5000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        System.out.println("[Testing] TechUI, quitting");
                        System.exit(0);
                        break block19;
                    }
                    if (Testing.queryTestingBoolean("TEST_TECHUI_LOGIN_DEFER_CONTROL")) {
                        String deferHost = JWLaunchProperties.getProperty("TEST_TECHUI_LOGIN_DEFER_TO_HOST");
                        System.out.println("[Testing] Deferring control to " + deferHost);
                        JWTestControl.shareJWT(this, deferHost, TestUtils.TESTCONTROL_PORT);
                        break block19;
                    }
                    System.out.println("[Testing] TechUI left in control...");
                    JWTesting.reportScreenshot("TechUI Window", TechUi.this.main, true);
                    if (Testing.queryTestingBoolean("TEST_TECHUI_CYCLEUI_LAUNCH_ONE_ACCESS_SESSION") || Testing.queryTestingBoolean("TEST_TECHUI_LAUNCH_ONE_ACCESS_SESSION_QUIT")) {
                        System.out.println("[Testing] Launching one access session");
                        JWTesting.reportAttempt("Launch Session", "", 300000);
                        TechUi.this.accessPanel.testLaunchOneSession();
                    }
                    if (Testing.queryTestingBoolean("TEST_TECHUI_CHURN_ALERTS")) {
                        System.out.println("[Testing] Churning alerts");
                        ResourceContainer[] entireAlertList_Expensive = TechUi.this.client.getEntireAlertList_Expensive();
                        ArrayList<LocatedAlert> alertList = new ArrayList<LocatedAlert>();
                        ArrayList<ServerEvent> eventList = new ArrayList<ServerEvent>();
                        for (ResourceContainer rc : entireAlertList_Expensive) {
                            ActionableResourceContainer la;
                            if (rc instanceof LocatedAlert) {
                                la = (LocatedAlert)rc;
                                if (((LocatedAlert)la).getName().getName().toLowerCase().indexOf("notest") != -1) continue;
                                alertList.add((LocatedAlert)rc);
                                continue;
                            }
                            if (!(rc instanceof ServerEvent) || ((ServerEvent)(la = (ServerEvent)rc)).getName().getName().toLowerCase().indexOf("notest") != -1) continue;
                            eventList.add((ServerEvent)rc);
                        }
                        System.out.println("[Testing] " + alertList.size() + " total alerts to churn");
                        boolean active = true;
                        while (true) {
                            try {
                                for (LocatedAlert la : alertList) {
                                    la.setActive(active);
                                    System.out.println("[Testing] Churning " + la.getName().getName());
                                    TechUi.this.client.updateAlerts(new ResourceContainer[]{la});
                                    JWTesting.reportStandaloneSuccess("Alert " + la.getName().getName() + " to " + (active ? "active" : "inactive"));
                                }
                                JWTesting.reportStandaloneSuccess("Alerts switched to " + (active ? "active" : "inactive"));
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                            Thread.sleep(30000L);
                            active = !active;
                        }
                    }
                    if (Testing.queryTestingBoolean("TEST_TECHUI_CYCLEUI")) {
                        System.out.println("[Testing] Cycling UI");
                        TechUi.this.testCycleUi();
                    }
                    if (Testing.queryTestingBoolean("TEST_TECHUI_WAIT_FOREVER")) {
                        System.out.println("[Testing] Waiting forever");
                        while (true) {
                            Thread.sleep(5000L);
                        }
                    }
                    System.out.println("[Testing] Logging out, exiting in 3...");
                    TechUi.this.logoutTechnician(false);
                    Thread.sleep(3000L);
                    System.exit(0);
                }
                catch (Exception x) {
                    System.out.println("[Testing] ERROR: " + x);
                    x.printStackTrace();
                    System.exit(0);
                }
            }
        }

        @Override
        public String getTestableAppName() {
            return TestUtils.APP_TECH_UI;
        }

        @Override
        public void call(String str, Message m) throws IOException {
            System.out.println("[JWTestable] command " + str + " " + m);
            if (str.equals(TestUtils.TU_CMD_launchAccessSession)) {
                TechUi.this.accessPanel.testLaunchOneSession();
            } else if (str.equals(TestUtils.TU_CMD_launchCustomerSession)) {
                TechUi.this.customerQueuePanel.testLaunchOneSession();
            } else if (str.equals(TestUtils.TU_CMD_testCycleUi)) {
                TechUi.this.testCycleUi();
            }
        }

        @Override
        public void testControlConnectionFailed() {
            System.out.println("[Testing] JWTestControl connection failed, exiting");
            try {
                JWTesting.reportFail("JWTestControl connection failed to TechUI", "");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.exit(1);
        }
    }
}

