/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.notifiers.NotificationOptionsPanel;
import com.aem.shelp.tech.properties.LayoutPreferencesPanel;
import com.aem.shelp.tech.properties.SessionPreferencesPanel;
import com.aem.shelp.tech.properties.TechAccountProperties;
import com.aem.shelp.tech.properties.TechPropertiesPanel;
import com.aem.shelp.tech.properties.ToolsPropertiesPanel;
import utils.progtools.SaverUtil;
import utils.swing.images.ImageLoader;
import utils.switches.Switches;

public class TechOptionsPanel
extends TechPropertiesPanel
implements SaverUtil.SaveListener {
    private final TechAccountProperties accountPage;
    private final NotificationOptionsPanel notificationPage;
    private final LayoutPreferencesPanel layoutPage;
    private final SessionPreferencesPanel sessionPage;
    private final ToolsPropertiesPanel toolsPage;
    private final SaverUtil saveUtil = new SaverUtil("TechOptions", 2000, this, false);
    private boolean skipSave = true;

    public TechOptionsPanel(TechUi techui) {
        this.accountPage = new TechAccountProperties(this, techui);
        this.notificationPage = new NotificationOptionsPanel(this);
        this.layoutPage = new LayoutPreferencesPanel(this);
        this.sessionPage = new SessionPreferencesPanel(this);
        this.toolsPage = new ToolsPropertiesPanel(this);
        this.addPropertiesPage(Language.get("TECH_UI_ACCOUNT"), ImageLoader.getImageIcon("images/svg/users/account.svg,48"), ImageLoader.getOverlayedIcon(ImageLoader.getImageIcon("images/svg/users/account.svg,48"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,16")), this.accountPage);
        if (!GroupAccessKeyset.isEnabled()) {
            this.addPropertiesPage(Language.get("NOTIFICATIONS"), ImageLoader.getImageIcon("images/svg/general/bell.svg,48"), ImageLoader.getOverlayedIcon(ImageLoader.getImageIcon("images/svg/general/bell.svg,48"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,16")), this.notificationPage);
        }
        this.addPropertiesPage(Language.get("TECH_UI_VISUAL_PROPERTIES"), ImageLoader.getImageIcon("images/svg/computing/window.svg,48"), ImageLoader.getOverlayedIcon(ImageLoader.getImageIcon("images/svg/computing/window.svg,48"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,16")), this.layoutPage);
        if (!Switches.SH_updatedConnectionTuning) {
            this.addPropertiesPage(Language.get("TECH_UI_SESSION_PROPERTIES"), ImageLoader.getImageIcon("images/svg/computing/wifi.svg,48"), ImageLoader.getOverlayedIcon(ImageLoader.getImageIcon("images/svg/computing/wifi.svg,48"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,16")), this.sessionPage);
        }
        if (!GroupAccessKeyset.isEnabled()) {
            this.addPropertiesPage(Language.get("TECH_UI_TOOLS_PROPERTIES"), ImageLoader.getImageIcon("images/svg/computing/sliders.svg,48"), ImageLoader.getOverlayedIcon(ImageLoader.getImageIcon("images/svg/computing/sliders.svg,48"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,16")), this.toolsPage);
        }
    }

    public void hideLogoutButton() {
        this.accountPage.hideLogoutButton();
    }

    public void setTechClient(TechClient client) {
        this.reloadProperties();
        this.accountPage.setTechClient(client);
        this.sessionPage.setTechClient(client);
        this.skipSave = false;
    }

    @Override
    public void contentChanged(boolean enableSave) {
        this.requestSave();
    }

    public void requestSave() {
        if (!this.skipSave) {
            this.saveUtil.queueSave();
        }
    }

    @Override
    public void performSave() {
        System.out.println("[TechOptionsPanel] Saving technician properties");
        this.saveProperties();
    }
}

