/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.shelp.common.properties.WindowBoundsUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import jwrapper.updater.JWLaunchProperties;
import utils.string.HexData;

public class TechHelpUIArguments {
    private Properties properties;
    public static final String KEY_LANGUAGE = "TechHelpUiLanguage";
    public static final String KEY_ISMACHINE = "TechHelpUiIsMachine";
    public static final String KEY_HOST = "TechHelpUiHost";
    public static final String KEY_PORT = "TechHelpUiPort";
    public static final String KEY_USERNAME = "TechHelpUiUsername";
    public static final String KEY_PASSWORD = "TechHelpUiPassword";
    public static final String KEY_MACHINE_PASSWORD = "TechHelpMachPassword";
    public static final String KEY_CONNECT_TO_ID = "TechHelpUiId";
    public static final String KEY_CONNECT_MACHINE_FILTER = "TechHelpUiMFilter";
    public static final String KEY_CONNECT_CUSTOMER_FILTER = "TechHelpUiCFilter";
    public static final String KEY_TECHNAME = "TechHelpUiTechName";
    public static final String KEY_TECHNAMEHEX = "TechHelpUiHexTechName";
    public static final String KEY_SH_RETRY = "TechHelpUiRetry";
    public static final String KEY_INIT_SESSION_TYPE = "TechHelpUiSessionType";
    public static final String KEY_REQUEST_ACCESS = "TechHelpUiRequestAccess";
    public static final String KEY_REQUEST_ACCESS_TIMEOUT = "TechHelpUiRequestAccessTimeout";
    public static final String KEY_VIEW_ONLY = "TechHelpUiViewOnly";
    public static final String KEY_TT_SESSION_ID = "TechHelpUiTTSessionID";
    public static final String KEY_PRE_CONNECTED_ID = "TechHelpUiPreConnectedID";
    public static final String KEY_PROXYHOST = "TechHelpUiProxyHost";
    public static final String KEY_PROXYPORT = "TechHelpUiProxyPort";
    public static final String KEY_USE_CACHED_TRANSLATIONS = "TechHelpUiCachedTrans";
    public static final String KEY_WINDOW_BOUNDS = "TechHelpUiWindowBounds";
    public static final String KEY_REQUESTED_WINDOWS_SESSION = "TechHelpUiWinSession";
    public static final String KEY_PF_HOSTNAME = "TechHelpUiPFHost";
    public static final String KEY_PF_PORT = "TechHelpUiPFPort";
    boolean loadDataFromLocalProperties = false;

    public TechHelpUIArguments(Properties properties) {
        this.properties = properties;
    }

    public TechHelpUIArguments() {
        this(new Properties());
    }

    public TechHelpUIArguments(byte[] serialisedProperties) throws IOException {
        this.properties = TechHelpUIArguments.deserialiseProperties(serialisedProperties);
        this.loadDataFromLocalProperties = true;
    }

    private String getRelevantProperty(boolean allowNull, String name) {
        if (this.loadDataFromLocalProperties) {
            String value = this.properties.getProperty(name);
            if (!allowNull && value == null) {
                value = "";
            }
            return value;
        }
        if (allowNull) {
            return JWLaunchProperties.getPropertyPossiblyNull(name);
        }
        return JWLaunchProperties.getProperty(name);
    }

    public Properties getPopulatedProperties() {
        return this.properties;
    }

    public byte[] getSerialisedProperties() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.properties.storeToXML(bout, "");
        return bout.toByteArray();
    }

    private static Properties deserialiseProperties(byte[] dat) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(dat);
        Properties props = new Properties();
        props.loadFromXML(in);
        return props;
    }

    public byte[] getTTSessionID() {
        String val = this.getRelevantProperty(false, KEY_TT_SESSION_ID);
        if (val != null && val.length() > 0) {
            return HexData.hexStringToByteArray(val);
        }
        return null;
    }

    public void setWindowBounds(WindowBoundsUtil.DesiredWindowBounds windowBounds) {
        if (windowBounds != null && windowBounds.getStringRepresentation() != null) {
            this.properties.setProperty(KEY_WINDOW_BOUNDS, windowBounds.getStringRepresentation());
        }
    }

    public WindowBoundsUtil.DesiredWindowBounds getWindowBounds() {
        String val = this.getRelevantProperty(false, KEY_WINDOW_BOUNDS);
        System.out.println("[TechClient] Retrieving window bounds as " + val);
        if (val == null || val.length() == 0) {
            return null;
        }
        return WindowBoundsUtil.DesiredWindowBounds.fromStringRepresentation(val);
    }

    public void setTTSessionID(byte[] sessionID) {
        if (sessionID != null) {
            this.properties.setProperty(KEY_TT_SESSION_ID, HexData.byteArrayToHexString(sessionID));
        }
    }

    public void setInitialSessionScreen() {
        this.setInitialSessionType(0);
    }

    public void setInitialSessionFiles() {
        this.setInitialSessionType(1);
    }

    public void setInitialSessionDiagnostics() {
        this.setInitialSessionType(2);
    }

    public void setInitialSessionType(int type) {
        this.properties.setProperty(KEY_INIT_SESSION_TYPE, Integer.toString(type));
    }

    public int getInitialSessionType() {
        String val = this.getRelevantProperty(false, KEY_INIT_SESSION_TYPE);
        if (val != null && val.length() > 0) {
            return Integer.parseInt(val);
        }
        return -1;
    }

    public void setUseCachedTranslations(boolean useCached) {
        this.properties.setProperty(KEY_USE_CACHED_TRANSLATIONS, Boolean.toString(useCached));
    }

    public boolean isUseCachedTranslations() {
        String val = this.getRelevantProperty(false, KEY_USE_CACHED_TRANSLATIONS);
        if (val != null && val.length() > 0) {
            return Boolean.parseBoolean(val);
        }
        return true;
    }

    public static void main(String[] args) {
    }

    public void setViewOnly(boolean viewOnly) {
        this.properties.setProperty(KEY_VIEW_ONLY, Boolean.toString(viewOnly));
    }

    public boolean isViewOnly() {
        String val = this.getRelevantProperty(false, KEY_VIEW_ONLY);
        if (val != null && val.length() > 0) {
            return Boolean.parseBoolean(val);
        }
        return false;
    }

    public void setPortForwardSettings(String hostname, int port) {
        if (hostname != null) {
            this.properties.setProperty(KEY_PF_HOSTNAME, hostname);
            this.properties.setProperty(KEY_PF_PORT, Integer.toString(port));
        }
    }

    public String getPortForwardHostname() {
        return this.getRelevantProperty(true, KEY_PF_HOSTNAME);
    }

    public int getPortForwardPort() {
        String val = this.getRelevantProperty(true, KEY_PF_PORT);
        if (val == null) {
            return -1;
        }
        return Integer.parseInt(val);
    }

    public void setRequestAccess(boolean request) {
        this.properties.setProperty(KEY_REQUEST_ACCESS, Boolean.toString(request));
    }

    public void setRequestTimeout(long requestTimeout) {
        this.properties.setProperty(KEY_REQUEST_ACCESS_TIMEOUT, Long.toString(requestTimeout));
    }

    public boolean isRequestAccess() {
        String val = this.getRelevantProperty(false, KEY_REQUEST_ACCESS);
        if (val != null && val.length() > 0) {
            return Boolean.parseBoolean(val);
        }
        return false;
    }

    public long getRequestAccessTimeout() {
        String val = this.getRelevantProperty(false, KEY_REQUEST_ACCESS_TIMEOUT);
        try {
            if (val != null && val.length() > 0) {
                return Long.parseLong(val);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return 0L;
    }

    public void setSHRetry(boolean retry) {
        this.properties.setProperty(KEY_SH_RETRY, Boolean.toString(retry));
    }

    public boolean isSHRetry() {
        String val = this.getRelevantProperty(false, KEY_SH_RETRY);
        if (val != null && val.length() > 0) {
            return Boolean.parseBoolean(val);
        }
        return false;
    }

    public void setTechName(String name) {
        if (name != null) {
            try {
                String hexEncodedVersion = HexData.byteArrayToHexString(name.getBytes("UTF-8"));
                this.properties.setProperty(KEY_TECHNAMEHEX, hexEncodedVersion);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public String getTechName() {
        String val;
        String hexName = this.getRelevantProperty(true, KEY_TECHNAMEHEX);
        if (hexName == null) {
            val = this.getRelevantProperty(false, KEY_TECHNAME);
        } else {
            try {
                val = new String(HexData.hexStringToByteArray(hexName), "UTF-8");
            }
            catch (Throwable t) {
                t.printStackTrace();
                val = null;
            }
        }
        if (val != null && val.length() > 0) {
            return val;
        }
        return "";
    }

    public void setConnectCustomerOrMachineByID(String id) {
        if (id != null) {
            this.properties.setProperty(KEY_CONNECT_TO_ID, id);
        }
    }

    public String getConnectCustomerOrMachineID() {
        return this.getRelevantProperty(false, KEY_CONNECT_TO_ID);
    }

    public void setConnectMachineFilter(String filter) {
        if (filter != null) {
            this.properties.setProperty(KEY_CONNECT_MACHINE_FILTER, filter);
        }
    }

    public void setConnectCustomerFilter(String filter) {
        if (filter != null) {
            this.properties.setProperty(KEY_CONNECT_CUSTOMER_FILTER, filter);
        }
    }

    public String getMachineFilter() {
        return this.getRelevantProperty(false, KEY_CONNECT_MACHINE_FILTER);
    }

    public String getCustomerFilter() {
        return this.getRelevantProperty(false, KEY_CONNECT_CUSTOMER_FILTER);
    }

    public String getMachinePassword() {
        String val = this.getRelevantProperty(false, KEY_MACHINE_PASSWORD);
        if (val != null && val.length() > 0) {
            return val;
        }
        return null;
    }

    public void setMachinePassword(String password) {
        if (password != null) {
            this.properties.setProperty(KEY_MACHINE_PASSWORD, password);
        }
    }

    public void setUsername(String username) {
        if (username != null) {
            this.properties.setProperty(KEY_USERNAME, username);
        }
    }

    public String getUsername() {
        String val = this.getRelevantProperty(false, KEY_USERNAME);
        if (val != null && val.length() > 0) {
            return val;
        }
        return "";
    }

    public void setPassword(String password) {
        if (password != null) {
            this.properties.setProperty(KEY_PASSWORD, password);
        }
    }

    public String getPassword() {
        return this.getRelevantProperty(false, KEY_PASSWORD);
    }

    public void setPort(int port) {
        this.properties.setProperty(KEY_PORT, Integer.toString(port));
    }

    public int getPort() {
        String val = this.getRelevantProperty(false, KEY_PORT);
        if (val != null && val.length() > 0) {
            return Integer.parseInt(val);
        }
        return -1;
    }

    public void setHostAndPortFromURL(String url) throws MalformedURLException {
        if (url == null || url.length() == 0) {
            System.out.println("[TechHelpUiArguments] Skipping host and port setting given '" + url + "'. Defaulting to " + this.getHost() + ":" + this.getPort() + ".");
            return;
        }
        System.out.println("[TechHelpUiArguments] (setHostAndPortFromURL) Server URL is '" + url + "'");
        if (!url.startsWith("http")) {
            url = "http://" + url;
        }
        URL zurl = new URL(url);
        String host = zurl.getHost();
        int port = zurl.getPort() == -1 ? (zurl.getProtocol().equalsIgnoreCase("https") ? 443 : 80) : zurl.getPort();
        this.setHost(host);
        this.setPort(port);
    }

    public void setHost(String host) {
        if (host != null) {
            this.properties.setProperty(KEY_HOST, host);
        }
    }

    public String getHost() {
        return this.getRelevantProperty(false, KEY_HOST);
    }

    public void setIsMachine(boolean isMachine) {
        this.properties.setProperty(KEY_ISMACHINE, Boolean.toString(isMachine));
    }

    public boolean isMachine() {
        String val = this.getRelevantProperty(false, KEY_ISMACHINE);
        if (val != null && val.length() > 0) {
            return Boolean.parseBoolean(val);
        }
        return false;
    }

    public void setLanguage(String language) {
        if (language != null) {
            this.properties.setProperty(KEY_LANGUAGE, language);
        }
    }

    public String getLanguage() {
        return this.getRelevantProperty(false, KEY_LANGUAGE);
    }

    public void setPreConnectedID(String ID) {
        if (ID != null) {
            this.properties.setProperty(KEY_PRE_CONNECTED_ID, ID);
        }
    }

    public String getPreConnectedID() {
        return this.getRelevantProperty(false, KEY_PRE_CONNECTED_ID);
    }

    public void setProxyHost(String proxyHost) {
        if (proxyHost != null) {
            this.properties.setProperty(KEY_PROXYHOST, proxyHost);
        }
    }

    public String getProxyHost() {
        return this.getRelevantProperty(false, KEY_PROXYHOST);
    }

    public void setProxyPort(String proxyPort) {
        if (proxyPort != null) {
            this.properties.setProperty(KEY_PROXYPORT, proxyPort);
        }
    }

    public String getProxyPort() {
        return this.getRelevantProperty(false, KEY_PROXYPORT);
    }

    public void setRequestedWindowsSessionID(String requestedWindowsSessionID) {
        if (requestedWindowsSessionID != null) {
            this.properties.setProperty(KEY_REQUESTED_WINDOWS_SESSION, requestedWindowsSessionID);
        }
    }

    public String getRequestedWindowsSessionID() {
        return this.getRelevantProperty(false, KEY_REQUESTED_WINDOWS_SESSION);
    }
}

