/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.shelp.common.Language;
import com.aem.shelp.util.RequestFocusListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UnsupportedLookAndFeelException;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.animated.arrow.ArrowAnimatedIcon;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class DisconnectedDialog
extends ScaledGlassDialog {
    private JButton logoutButton;
    private JButton reconnectButton;
    private JWrapLabel descriptionLabel;
    private JLabel iconLabel;
    private JLabel titleLabel;
    private boolean isDead = false;
    private String reconnectURL;
    private DisconnectedListener logoutListener;
    private static ConnectionMonitorThread monitorThread = null;
    private static final Object LOCK = new Object();

    public DisconnectedDialog(RootPaneContainer rootPane, DisconnectedListener logoutListener, boolean isDead, String reconnectURL) {
        super(rootPane, 470, 160, false, true, true);
        this.reconnectURL = reconnectURL;
        this.isDead = isDead;
        this.setTitle(Language.get("CONNECTION_FAILED"));
        this.initUI(logoutListener);
    }

    public void setIsDead(final boolean isDead) {
        this.isDead = isDead;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (isDead) {
                    DisconnectedDialog.this.iconLabel.setIcon(ImageLoader.getOverlayedIcon(ImageLoader.getImageIcon("images/svg/general/world.svg,48"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,16")));
                    DisconnectedDialog.this.titleLabel.setText(Language.get("DISCONNECTED_DEAD_TITLE"));
                    DisconnectedDialog.this.descriptionLabel.setText(Language.get("DISCONNECTED_DEAD_MSG"));
                    DisconnectedDialog.this.descriptionLabel.setIcon(null);
                } else {
                    DisconnectedDialog.this.iconLabel.setIcon(ImageLoader.getOverlayedIcon(ImageLoader.getImageIcon("images/svg/general/world.svg,48"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16")));
                    DisconnectedDialog.this.titleLabel.setText(Language.get("DISCONNECTED_DOWN_TITLE"));
                    DisconnectedDialog.this.descriptionLabel.setText(Language.get("DISCONNECTED_DOWN_MSG"));
                    DisconnectedDialog.this.descriptionLabel.setIcon(new ArrowAnimatedIcon());
                }
                if (isDead && DisconnectedDialog.this.reconnectURL != null) {
                    Object object = LOCK;
                    synchronized (object) {
                        if (monitorThread != null) {
                            monitorThread.die();
                        }
                        monitorThread = new ConnectionMonitorThread(DisconnectedDialog.this.reconnectURL, DisconnectedDialog.this.logoutListener);
                    }
                }
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private void initUI(final DisconnectedListener logoutListener) {
        this.logoutListener = logoutListener;
        this.setModal(false);
        GbPanel main = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        main.setBorder(SHBorderFactory.createEmptyBorder(20, 20, 20, 10));
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.descriptionLabel = new JWrapLabel();
        this.logoutButton = new JButton(Language.get("LOGOUT"));
        this.logoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisconnectedDialog.this.logoutButton.setEnabled(false);
                logoutListener.doLogout();
            }
        });
        this.reconnectButton = new JButton(Language.get("DISCONNECTED_RECONNECT"));
        this.reconnectButton.addAncestorListener(new RequestFocusListener());
        SHButtonUI.makeButtonBlue(this.reconnectButton);
        this.reconnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisconnectedDialog.this.requestReconnect();
            }
        });
        this.iconLabel = new JLabel();
        this.iconLabel.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 0, 20));
        main.add(this.iconLabel, 0, 0, 1, 2, 0, 0, 18, 0);
        main.add(this.titleLabel, 1, 0, 1, 1, 1, 0, 17, 2);
        main.add(this.descriptionLabel, 1, 1, 1, 1, 1, 0, 17, 2);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)this.logoutButton, "West");
        buttonsPanel.add((Component)this.reconnectButton, "East");
        SwingUtil.setSizesToWidest(this.logoutButton, this.reconnectButton);
        main.add(buttonsPanel, 1, 2, 1, 1, 1, 1, 15, 2);
        this.getContentPane().add(main);
        this.setIsDead(this.isDead);
        this.setVisible(true);
    }

    private void requestReconnect() {
        new ReconnectThread().start();
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException, IOException, InterruptedException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        Thread.sleep(1000L);
        DisconnectedDialog dialog = new DisconnectedDialog(frame, null, false, "http://google.com");
        Thread.sleep(3000L);
        dialog.setIsDead(true);
        Thread.sleep(3000L);
        dialog.setVisible(false);
        dialog = new DisconnectedDialog(frame, null, false, "http://google.com");
    }

    class ReconnectThread
    extends Thread {
        ReconnectThread() {
        }

        @Override
        public void run() {
            DisconnectedDialog.this.reconnectButton.setEnabled(false);
            DisconnectedDialog.this.logoutButton.setEnabled(false);
            DisconnectedDialog.this.descriptionLabel.setText(Language.get("RECONNECTING") + "...");
            DisconnectedDialog.this.descriptionLabel.setIcon(new ArrowAnimatedIcon());
            try {
                DisconnectedDialog.this.logoutListener.doReconnect();
            }
            catch (Throwable t) {
                DisconnectedDialog.this.reconnectButton.setEnabled(true);
                DisconnectedDialog.this.logoutButton.setEnabled(true);
                DisconnectedDialog.this.descriptionLabel.setText(Language.get("UNABLE_RECONNECT_MESSAGE"));
                DisconnectedDialog.this.descriptionLabel.setIcon(null);
            }
        }
    }

    class ConnectionMonitorThread
    extends Thread {
        private boolean die = false;
        private String reconnectURL;
        private DisconnectedListener listener;

        public ConnectionMonitorThread(String reconnectURL, DisconnectedListener listener) {
            this.reconnectURL = reconnectURL;
            this.listener = listener;
            System.out.println("[ConnectionMonitorThread] Starting...");
            this.start();
        }

        public void die() {
            this.die = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long endTime = System.currentTimeMillis() + 60000L;
            int reconnectCount = 0;
            while (!this.die && reconnectCount < 3 && System.currentTimeMillis() < endTime) {
                System.out.println("[ConnectionMonitorThread] Checking " + this.reconnectURL + "...");
                try {
                    URL url = new URL(this.reconnectURL);
                    try {
                        URLConnection openConnection = url.openConnection();
                        openConnection.setConnectTimeout(10000);
                        openConnection.connect();
                        if (openConnection instanceof HttpURLConnection) {
                            ((HttpURLConnection)openConnection).disconnect();
                        }
                        try {
                            ++reconnectCount;
                            this.listener.doReconnect();
                            Object object = LOCK;
                            synchronized (object) {
                                this.die = true;
                                monitorThread = null;
                            }
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (IOException iOException) {}
                }
                catch (MalformedURLException exx) {
                    exx.printStackTrace();
                    this.die();
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static interface DisconnectedListener {
        public void doReconnect() throws Exception;

        public void doLogout();
    }
}

