/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.filters;

import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.filters.Filter;

public class CustomerFilter
extends Filter {
    public static final String FIELD_COUNTRY = "Filter_Country";
    public static final String FIELD_CONNECT_URL = "Filter_URL";
    public static final String FIELD_CONNECT_DOMAIN = "Filter_Domain";
    public static final String FIELD_ALL_DETAILS = "Filter_Details";

    public CustomerFilter() {
        super(false);
    }

    public CustomerFilter(boolean isShow, String field, int selectedIndex, String text) {
        super(false, isShow, field, selectedIndex, text);
    }

    @Override
    public boolean include(AbstractMachine customerOrMachine) {
        if (!(customerOrMachine instanceof Customer)) {
            return false;
        }
        Customer customer = (Customer)customerOrMachine;
        if (this.fieldNameToFilter.equals(FIELD_COUNTRY)) {
            return this.checkIsIncludedByFilter(customer.getCountry());
        }
        if (this.fieldNameToFilter.equals(FIELD_CONNECT_URL)) {
            return this.checkIsIncludedByFilter(customer.getRequestURL());
        }
        if (this.fieldNameToFilter.equals(FIELD_CONNECT_DOMAIN)) {
            return this.checkIsIncludedByFilter(customer.getRequestDomain());
        }
        if (this.fieldNameToFilter.equals(FIELD_ALL_DETAILS)) {
            return this.checkIsIncludedByFilter(customer.toString(false));
        }
        String value = customer.getValue(this.fieldNameToFilter, true);
        if (value != null) {
            return this.checkIsIncludedByFilter(value);
        }
        return false;
    }

    @Override
    public String getRootTag() {
        return "CustomerFilter";
    }
}

