/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.threshold.WindowsEventLogFollower;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.jwutils.eventlog.JWWindowsEventLogRecord;
import utils.message.Message;

public class WindowsEventLogThreshold
extends Alert {
    public static final Object ID = "EventLogTrigger";
    private static final ArrayList<FollowerTracker> trackerList = new ArrayList();
    private String logName = "Application";
    private int eventType;
    private String message;
    private String user;
    private String source;
    private String computer;
    private boolean triggerIfEventReceived = true;
    private long timeEventLastFound = 0L;
    private WindowsEventLogFollower logFollower;

    public int getEventType() {
        return this.eventType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUser() {
        return this.user;
    }

    public String getSource() {
        return this.source;
    }

    public String getComputer() {
        return this.computer;
    }

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public Alert createCorollary() {
        WindowsEventLogThreshold clone = (WindowsEventLogThreshold)this.cloneWithNewID();
        clone.logName = this.logName;
        clone.eventType = this.eventType;
        clone.message = this.message;
        clone.user = this.user;
        clone.source = this.source;
        clone.computer = this.computer;
        clone.triggerIfEventReceived = !this.triggerIfEventReceived;
        return clone;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_EVENT_LOG_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_EVENT_LOG_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/files-folders/files.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/os/windows.svg,24";
    }

    @Override
    public String getDefaultName() {
        return Language.get("ALERT_EVENT_LOG_NAME");
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.logName);
        m.append(this.eventType);
        m.append(this.message);
        m.append(this.user);
        m.append(this.source);
        m.append(this.computer);
        m.append(this.triggerIfEventReceived);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.logName = m.getNextString();
        this.eventType = m.getNextInt();
        this.message = m.getNextString();
        this.user = m.getNextString();
        this.source = m.getNextString();
        this.computer = m.getNextString();
        if (m.hasNext()) {
            this.triggerIfEventReceived = m.getNextBoolean();
        }
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timePassed() {
        ArrayList<JWWindowsEventLogRecord> newEvents;
        if (this.logFollower == null) {
            if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
                System.out.println("[WindowsEventLogThreshold] Initialising (logName:" + this.logName + " eventType:" + this.eventType + " message:" + this.message + " user:" + this.user + " source:" + this.source + " computer:" + this.computer + ")");
            }
            try {
                this.logFollower = new WindowsEventLogFollower(this.logName);
                ArrayList<FollowerTracker> arrayList = trackerList;
                synchronized (arrayList) {
                    for (int i = trackerList.size() - 1; i >= 0; --i) {
                        FollowerTracker t = trackerList.get(i);
                        if (t.ref != null) continue;
                        try {
                            JWWindowsOS.getWindowsInstance().closeEventLog(t.eventID);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        trackerList.remove(i);
                    }
                    FollowerTracker t = new FollowerTracker();
                    t.ref = new WeakReference<WindowsEventLogFollower>(this.logFollower);
                    trackerList.add(t);
                }
                if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
                    System.out.println("[WindowsEventLogThreshold] Tracking " + this.logName + " (trackerList.size: " + trackerList.size() + ")");
                }
            }
            catch (WindowsEventLogFollower.NoSuchLogException e) {
                System.out.println("[WindowsEventLogThreshold] Unable to find log with name '" + this.logName + "'");
                return;
            }
        }
        if ((newEvents = this.logFollower.getNewEvents()) != null) {
            if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
                System.out.println("[WindowsEventLogThreshold] Got " + newEvents.size() + " new events.");
            }
            for (JWWindowsEventLogRecord record : newEvents) {
                if (!this.includeWindowsEventLog(record)) continue;
                this.eventFound();
                return;
            }
        } else if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
            System.out.println("[WindowsEventLogThreshold] Got no new events.");
        }
        this.eventNotFound();
    }

    private void eventNotFound() {
        if (this.timeEventLastFound > 0L && System.currentTimeMillis() - this.timeEventLastFound > 60000L) {
            this.timeEventLastFound = 0L;
            this.updateTriggeredState(!this.triggerIfEventReceived);
        }
    }

    private void eventFound() {
        this.timeEventLastFound = System.currentTimeMillis();
        this.updateTriggeredState(this.triggerIfEventReceived);
    }

    private boolean includeWindowsEventLog(JWWindowsEventLogRecord eventLogRecord) {
        if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
            System.out.println("[WindowsEventLogThreshold] New event log entry (eventType:" + eventLogRecord.getEventType() + " message:" + eventLogRecord.getMessage() + " user:" + eventLogRecord.getQualifiedUsername() + " source:" + eventLogRecord.getSource() + " computer:" + eventLogRecord.getComputerName() + ")");
        }
        if (this.eventType != 0 && eventLogRecord.getEventType() != this.eventType) {
            if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
                System.out.println("[WindowsEventLogThreshold] Event type mismatch. Ignoring.");
            }
            return false;
        }
        if (this.message != null && this.message.length() > 0 && !eventLogRecord.getMessage().toLowerCase().contains(this.message.toLowerCase())) {
            if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
                System.out.println("[WindowsEventLogThreshold] Message mismatch. Ignoring.");
            }
            return false;
        }
        if (this.user != null && this.user.length() > 0 && !eventLogRecord.getQualifiedUsername().toLowerCase().contains(this.user.toLowerCase())) {
            if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
                System.out.println("[WindowsEventLogThreshold] User mismatch. Ignoring.");
            }
            return false;
        }
        if (this.source != null && this.source.length() > 0 && !eventLogRecord.getSource().toLowerCase().contains(this.source.toLowerCase())) {
            if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
                System.out.println("[WindowsEventLogThreshold] Source mismatch. Ignoring.");
            }
            return false;
        }
        if (this.computer != null && this.computer.length() > 0 && !eventLogRecord.getComputerName().toLowerCase().contains(this.computer.toLowerCase())) {
            if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
                System.out.println("[WindowsEventLogThreshold] Computer mismatch. Ignoring.");
            }
            return false;
        }
        return true;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String editorValue) {
        this.logName = editorValue;
    }

    public void setEventType(int i) {
        this.eventType = i;
    }

    public void setEventMessage(String eventMessage) {
        this.message = eventMessage;
    }

    public void setEventUser(String user) {
        this.user = user;
    }

    public void setEventSource(String source) {
        this.source = source;
    }

    public void setEventComputer(String computer) {
        this.computer = computer;
    }

    public boolean triggerIfEventReceived() {
        return this.triggerIfEventReceived;
    }

    public void setTriggerIfEventReceived(boolean triggerIfEventReceived) {
        this.triggerIfEventReceived = triggerIfEventReceived;
    }

    class FollowerTracker {
        long eventID;
        WeakReference<WindowsEventLogFollower> ref;

        FollowerTracker() {
        }
    }
}

