/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import java.util.ArrayList;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.jwutils.eventlog.JWWindowsEventLogRecord;

public class WindowsEventLogFollower {
    private String logNameToFollow;
    private long currentLogCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowsEventLogFollower(String logNameToFollow) throws NoSuchLogException {
        this.logNameToFollow = logNameToFollow;
        long eventLogHandle = JWWindowsOS.getWindowsInstance().openEventLog(null, logNameToFollow);
        if (eventLogHandle > 0L) {
            try {
                this.currentLogCount = JWWindowsOS.getWindowsInstance().getNumberOfEventLogRecords(eventLogHandle);
            }
            finally {
                JWWindowsOS.getWindowsInstance().closeEventLog(eventLogHandle);
            }
        } else {
            throw new NoSuchLogException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JWWindowsEventLogRecord> getNewEvents() {
        long eventLogHandle = JWWindowsOS.getWindowsInstance().openEventLog(null, this.logNameToFollow);
        ArrayList<JWWindowsEventLogRecord> events = null;
        if (eventLogHandle > 0L) {
            try {
                long newCount = JWWindowsOS.getWindowsInstance().getNumberOfEventLogRecords(eventLogHandle);
                if (this.currentLogCount != newCount) {
                    if (newCount > this.currentLogCount) {
                        events = JWWindowsOS.getWindowsInstance().readEventLog(eventLogHandle, 9, 0, (int)(newCount - this.currentLogCount));
                    }
                    if (CentralDebugging.ALERT_WINDOWS_EVENT_LOG) {
                        System.out.println("[WindowsEventLog] Number of logging events changed (" + newCount + ")");
                    }
                    this.currentLogCount = newCount;
                }
            }
            finally {
                JWWindowsOS.getWindowsInstance().closeEventLog(eventLogHandle);
            }
        }
        return events;
    }

    class NoSuchLogException
    extends Exception {
        NoSuchLogException() {
        }
    }
}

