/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.InputStream;
import java.net.URL;
import utils.message.Message;
import utils.stream.StreamUtils;

public class WebsiteAccessibleThreshold
extends Alert {
    public static final Object ID = "WebsiteAccessibleTrigger";
    String site = "http://www.google.com";
    boolean accessible = true;
    String validateText = "";
    long lastChecked = 0L;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_NET_WEB_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_NET_WEB_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/network.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/ok.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.accessible) {
            return Language.get("ALERT_WEB_ACCESSIBLE", new Object[]{this.site});
        }
        return Language.get("ALERT_WEB_NOTACCESSIBLE", new Object[]{this.site});
    }

    @Override
    public Alert createCorollary() {
        WebsiteAccessibleThreshold clone = (WebsiteAccessibleThreshold)this.cloneWithNewID();
        clone.accessible = !clone.accessible;
        return clone;
    }

    public void setTriggerOn(String site, boolean isAccessible, String validateText) {
        this.site = site;
        this.accessible = isAccessible;
        this.validateText = validateText;
    }

    public String getSite() {
        return this.site;
    }

    public String getValidationText() {
        return this.validateText;
    }

    public boolean getTriggerIfAccessible() {
        return this.accessible;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.site);
        m.append(this.accessible);
        m.append(this.validateText);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.site = m.getNextString();
        this.accessible = m.getNextBoolean();
        this.validateText = m.getNextString();
    }

    @Override
    public void timePassed() {
        long now = SafeClock.currentTimeMillis();
        if (now - this.lastChecked > 20000L) {
            this.lastChecked = now;
            boolean through = false;
            try {
                String content;
                URL url = new URL(this.site);
                InputStream in = url.openStream();
                if (this.validateText != null && this.validateText.length() > 0 && (content = StreamUtils.readAllAsString(in)).indexOf(this.validateText) == -1) {
                    throw new Exception("Validation content not found");
                }
                in.close();
                through = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean state = false;
            if (through && this.accessible) {
                state = true;
            }
            if (!through && !this.accessible) {
                state = true;
            }
            this.updateTriggeredState(state);
        }
    }
}

