/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.net.Socket;
import utils.message.Message;

public class TcpAccessibleThreshold
extends Alert {
    public static final Object ID = "TcpAccessibleTrigger";
    String host = "yourserver.com, 192.168.0.1";
    int port = 80;
    boolean accessible = true;
    long lastChecked = 0L;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_NET_TCP_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_NET_TCP_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/network.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/computing/monolith.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.accessible) {
            return Language.get("ALERT_TCP_ACCESSIBLE", new Object[]{this.host + ":" + this.port});
        }
        return Language.get("ALERT_TCP_NOTACCESSIBLE", new Object[]{this.host + ":" + this.port});
    }

    @Override
    public Alert createCorollary() {
        TcpAccessibleThreshold clone = (TcpAccessibleThreshold)this.cloneWithNewID();
        clone.accessible = !clone.accessible;
        return clone;
    }

    public void setTriggerOn(String host, int port, boolean isAccessible) {
        this.host = host;
        this.port = port;
        this.accessible = isAccessible;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean getTriggerIfAccessible() {
        return this.accessible;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.host);
        m.append(this.port);
        m.append(this.accessible);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.host = m.getNextString();
        this.port = m.getNextInt();
        this.accessible = m.getNextBoolean();
    }

    @Override
    public void timePassed() {
        long now = SafeClock.currentTimeMillis();
        if (now - this.lastChecked > 30000L) {
            this.lastChecked = now;
            boolean through = false;
            try {
                new Socket(this.host, this.port);
                through = true;
                if (CentralDebugging.ALERT_TCP_VERBOSE) {
                    System.out.println("[TcpAccessible] " + this.getName() + " (" + this.accessible + ") connected OK to " + this.host + ":" + this.port + " (" + through + ")");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean state = false;
            if (through && this.accessible) {
                state = true;
                if (CentralDebugging.ALERT_TCP_VERBOSE) {
                    System.out.println("[TcpAccessible] " + this.getName() + " state is triggered (1)");
                }
            }
            if (!through && !this.accessible) {
                state = true;
                if (CentralDebugging.ALERT_TCP_VERBOSE) {
                    System.out.println("[TcpAccessible] " + this.getName() + " state is triggered (2)");
                }
            }
            if (!state && CentralDebugging.ALERT_TCP_VERBOSE) {
                System.out.println("[TcpAccessible] " + this.getName() + " state is reset");
            }
            this.updateTriggeredState(state);
        }
    }
}

