/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimplePercentThreshold;
import java.text.NumberFormat;
import utils.message.Message;
import utils.osstats.Stats;

public class CPUThreshold
extends Alert
implements SimplePercentThreshold {
    public static final String ID = "CPUTrigger";
    NumberFormat pf = NumberFormat.getPercentInstance();
    double trig = 90.0;
    boolean over = true;

    @Override
    public Alert createCorollary() {
        CPUThreshold clone = (CPUThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_CPU_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_CPU_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/technology/screen.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/charts/meter.svg,24";
    }

    @Override
    public String getResourceKey() {
        return "ALERT_CONFIG_TRIGGER_CPU_LVL";
    }

    @Override
    public String getResourceUnit() {
        return "%";
    }

    @Override
    public String getDefaultName() {
        double dVal = this.trig / 100.0;
        String value = (double)Math.round(dVal) == dVal ? this.pf.format((long)dVal) : this.pf.format(dVal);
        if (this.over) {
            return Language.get("ALERT_CPU_OVER", new Object[]{value});
        }
        return Language.get("ALERT_CPU_UNDER", new Object[]{value});
    }

    @Override
    public void setTriggerOnOver(boolean b) {
        this.over = b;
    }

    @Override
    public void setTriggerPercent(double d) {
        this.trig = d;
    }

    @Override
    public boolean getTriggerOnOver() {
        return this.over;
    }

    @Override
    public double getTriggerPercent() {
        return this.trig;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.trig);
        m.append(this.over);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.trig = m.getNextDouble();
        this.over = m.getNextBoolean();
    }

    @Override
    public void machineStats(Stats stats) {
        boolean ON = stats.getCpuUsagePercent() > this.trig ? this.over : !this.over;
        this.updateTriggeredState(ON);
    }
}

