/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts;

import com.aem.shelp.proxy.alerts.AlertCategory;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertLocation;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.proxy.types.VersionType;
import com.aem.shelp.proxy.types.alertlocs.AllMachinesAloc;
import com.aem.shelp.proxy.types.alertlocs.MachineFilterAloc;
import com.aem.shelp.proxy.types.alertlocs.ServerSideAloc;
import com.aem.shelp.proxy.types.alertlocs.StaticListAloc;
import com.aem.shelp.proxy.types.alerts.BasicAlert;
import com.aem.shelp.proxy.types.alerts.threshold.AntiVirusThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.CPUThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.DiskHealthThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.DiskSpaceThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.FileAccessibleThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.FileLengthThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.FileModifiedThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.FirewallThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.MemoryUsageThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.ProcCpuUsageThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.ProcMemoryUsageThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.ProcRunningThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.ServiceRunningThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.TcpAccessibleThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.TimerEventSource;
import com.aem.shelp.proxy.types.alerts.threshold.ToolboxDatapointThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.WebsiteAccessibleThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.WebsiteResponseTimeThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.WindowsEventLogThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.WindowsRegistryThreshold;
import java.util.ArrayList;
import java.util.HashMap;
import utils.message.Message;
import utils.switches.Switches;

public class ResourceSerialiser
extends VersionType {
    private static final Object[] ALERT_MAPPINGS;
    private static final Object[] ALERT_LOCATION_MAPPINGS;
    private static final Object[] RESOURCE_MAPPINGS;
    static HashMap<String, Class<? extends Alert>> tagsToClasses;
    static HashMap<Class<? extends Alert>, String> classesToTags;
    static HashMap<AlertCategory, ArrayList<Alert>> alertCategories;

    public static ArrayList<Alert> getCategory(AlertCategory cat) {
        if (cat == null) {
            return new ArrayList<Alert>();
        }
        ArrayList<Alert> alerts = alertCategories.get(cat);
        if (alerts == null) {
            alerts = new ArrayList();
            alertCategories.put(cat, alerts);
        }
        return alerts;
    }

    public static Class[] getAlertClasses() {
        Class[] result = new Class[ALERT_MAPPINGS.length / 3];
        int count = 0;
        for (int i = 0; i < ALERT_MAPPINGS.length; i += 3) {
            Class clazz = (Class)ALERT_MAPPINGS[i + 2];
            result[count++] = clazz;
        }
        return result;
    }

    public static Class[] getLocationClasses() {
        Class[] result = new Class[ALERT_LOCATION_MAPPINGS.length / 2];
        int count = 0;
        for (int i = 0; i < ALERT_LOCATION_MAPPINGS.length; i += 2) {
            Class clazz = (Class)ALERT_LOCATION_MAPPINGS[i + 1];
            result[count++] = clazz;
        }
        return result;
    }

    public static String getTagFor(Class clazz) {
        return classesToTags.get(clazz);
    }

    private static Class getClassFor(String tag) {
        return tagsToClasses.get(tag);
    }

    public static Alert alertFromMessage(Message m) {
        try {
            Class clazz = ResourceSerialiser.getClassFor(m.getNextString());
            Alert alert = (Alert)clazz.newInstance();
            alert.fromMessage(m);
            return alert;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public static Message alertToMessage(Alert alert) {
        Message m = new Message(14902);
        m.append(ResourceSerialiser.getTagFor(alert.getClass()));
        alert.toMessage(m);
        return m;
    }

    public static AlertLocation alocFromMessage(Message m) {
        try {
            Class clazz = ResourceSerialiser.getClassFor(m.getNextString());
            AlertLocation aloc = (AlertLocation)clazz.newInstance();
            aloc.fromMessage(m);
            return aloc;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public static Message alocToMessage(AlertLocation aloc) {
        Message m = new Message(14903);
        m.append(ResourceSerialiser.getTagFor(aloc.getClass()));
        aloc.toMessage(m);
        return m;
    }

    public static Message toMessage(ResourceContainer resourceContainer) {
        Message m = new Message();
        m.append((byte)11);
        String tag = ResourceSerialiser.getTagFor(resourceContainer.getClass());
        if (tag == null) {
            System.out.println("[ResourceSerialiser] No serialisation mapping for tag '" + resourceContainer.getClass() + "'");
        }
        m.append(tag);
        resourceContainer.toMessage(m);
        return m;
    }

    public static ResourceContainer resourceContainerFromMessage(Message m) {
        byte version = m.getNextByte();
        String tag = m.getNextString();
        Class clazz = ResourceSerialiser.getClassFor(tag);
        if (clazz == null) {
            System.out.println("[ResourceSerialiser] No deserialisation mapping for tag '" + tag + "'");
        }
        try {
            ResourceContainer rc = (ResourceContainer)clazz.newInstance();
            rc.fromMessage(version, m);
            return rc;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    static {
        Class clazz;
        String tag;
        int i;
        ALERT_MAPPINGS = new Object[]{AlertCategory.NONE, "BasicAlert", BasicAlert.class, AlertCategory.MACHINE_RESOURCES, "CPUTrigger", CPUThreshold.class, AlertCategory.MACHINE_RESOURCES, "DiskSpaceTrigger", DiskSpaceThreshold.class, AlertCategory.MACHINE_RESOURCES, MemoryUsageThreshold.ID, MemoryUsageThreshold.class, AlertCategory.MACHINE_RESOURCES, DiskHealthThreshold.ID, DiskHealthThreshold.class, AlertCategory.MACHINE_PROCESSES, ProcCpuUsageThreshold.ID, ProcCpuUsageThreshold.class, AlertCategory.MACHINE_PROCESSES, ProcMemoryUsageThreshold.ID, ProcMemoryUsageThreshold.class, AlertCategory.MACHINE_PROCESSES, ProcRunningThreshold.ID, ProcRunningThreshold.class, AlertCategory.MACHINE_PROCESSES, AntiVirusThreshold.ID, AntiVirusThreshold.class, AlertCategory.MACHINE_PROCESSES, FirewallThreshold.ID, FirewallThreshold.class, AlertCategory.MACHINE_PROCESSES, ServiceRunningThreshold.ID, ServiceRunningThreshold.class, AlertCategory.NETWORK, TcpAccessibleThreshold.ID, TcpAccessibleThreshold.class, AlertCategory.NETWORK, WebsiteAccessibleThreshold.ID, WebsiteAccessibleThreshold.class, AlertCategory.NETWORK, WebsiteResponseTimeThreshold.ID, WebsiteResponseTimeThreshold.class, AlertCategory.FILE, FileAccessibleThreshold.ID, FileAccessibleThreshold.class, AlertCategory.FILE, FileLengthThreshold.ID, FileLengthThreshold.class, AlertCategory.FILE, FileModifiedThreshold.ID, FileModifiedThreshold.class, AlertCategory.FILE, WindowsEventLogThreshold.ID, WindowsEventLogThreshold.class, AlertCategory.FILE, WindowsRegistryThreshold.ID, WindowsRegistryThreshold.class, AlertCategory.SCHEDULE, TimerEventSource.ID, TimerEventSource.class, AlertCategory.CUSTOM, ToolboxDatapointThreshold.ID, ToolboxDatapointThreshold.class};
        ALERT_LOCATION_MAPPINGS = new Object[]{AllMachinesAloc.ID, AllMachinesAloc.class, ServerSideAloc.ID, ServerSideAloc.class, StaticListAloc.ID, StaticListAloc.class, MachineFilterAloc.ID, MachineFilterAloc.class};
        RESOURCE_MAPPINGS = new Object[]{"LocatedAlert", LocatedAlert.class, "ServerEvent", ServerEvent.class};
        tagsToClasses = new HashMap();
        classesToTags = new HashMap();
        alertCategories = new HashMap();
        for (i = 0; i < ALERT_MAPPINGS.length; i += 3) {
            AlertCategory cat = (AlertCategory)ALERT_MAPPINGS[i];
            String tag2 = (String)ALERT_MAPPINGS[i + 1];
            Class clazz2 = (Class)ALERT_MAPPINGS[i + 2];
            if (!Switches.SH_service_running_alert && clazz2 == ServiceRunningThreshold.class || !Switches.SH_windows_registry_alert && clazz2 == WindowsRegistryThreshold.class) continue;
            try {
                ResourceSerialiser.getCategory(cat).add((Alert)clazz2.newInstance());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            tagsToClasses.put(tag2, clazz2);
            classesToTags.put(clazz2, tag2);
        }
        for (i = 0; i < ALERT_LOCATION_MAPPINGS.length; i += 2) {
            tag = (String)ALERT_LOCATION_MAPPINGS[i];
            clazz = (Class)ALERT_LOCATION_MAPPINGS[i + 1];
            tagsToClasses.put(tag, clazz);
            classesToTags.put(clazz, tag);
        }
        for (i = 0; i < RESOURCE_MAPPINGS.length; i += 2) {
            tag = (String)RESOURCE_MAPPINGS[i];
            clazz = (Class)RESOURCE_MAPPINGS[i + 1];
            tagsToClasses.put(tag, clazz);
            classesToTags.put(clazz, tag);
        }
    }
}

