/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertInput;
import com.aem.shelp.proxy.types.TrackedAlert;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import java.util.ArrayList;
import java.util.HashMap;
import utils.message.Message;
import utils.osstats.Stats;
import utils.osstats.av.SecurityProduct;

public class BasicAlert
extends Alert
implements TrackedAlert,
AlertInput {
    public static final String ID = "BasicAlert";
    long myStateTime = SafeClock.currentTimeMillis();
    boolean myState = false;
    boolean triggerIntraGroupsAND = false;
    boolean resetIntraGroupsAND = false;
    ArrayList<ArrayList<Alert>> triggerIDs = new ArrayList();
    ArrayList<ArrayList<Alert>> resetIDs = new ArrayList();
    long triggerMS = 30000L;
    long resetMS = 30000L;
    static Object states_LOCK = new Object();
    static HashMap<String, Boolean> states = new HashMap();

    public BasicAlert() {
        if (!Alert.isReadOnly()) {
            this.setActive(false);
        }
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString(indent));
        this.indent(sb, indent).append("  Trigger time : " + this.triggerMS).append('\n');
        this.indent(sb, indent).append("  Trigger logic : " + (this.triggerIntraGroupsAND ? "AND" : "OR")).append('\n');
        for (ArrayList<Alert> group : this.triggerIDs) {
            this.indent(sb, indent).append("  Trigger threshold Group (" + group.size() + ")").append('\n');
            for (Alert trigger : group) {
                if (!(trigger instanceof Alert)) continue;
                sb.append(trigger.toString(indent + 4)).append('\n');
            }
        }
        this.indent(sb, indent).append("  Reset time : " + this.resetMS).append('\n');
        this.indent(sb, indent).append("  Reset logic : " + (this.resetIntraGroupsAND ? "AND" : "OR")).append('\n');
        for (ArrayList<Alert> group : this.resetIDs) {
            this.indent(sb, indent).append("  Reset threshold Group (" + group.size() + ")").append('\n');
            for (Alert reset : group) {
                if (!(reset instanceof Alert)) continue;
                sb.append(reset.toString(indent + 4)).append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public void storeTriggeredStateInto(HashMap<String, Alert> store) {
        super.storeTriggeredStateInto(store);
        HashMap<String, Alert> mine = this.getSubAlertsMap();
        for (String id : mine.keySet()) {
            Alert myAlert = mine.get(id);
            myAlert.storeTriggeredStateInto(store);
        }
    }

    @Override
    public void copyTriggeredStateFrom(Alert alert) {
        super.copyTriggeredStateFrom(alert);
        BasicAlert ba = (BasicAlert)alert;
        this.myStateTime = ba.myStateTime;
        this.myState = ba.myState;
        HashMap<String, Alert> mine = this.getSubAlertsMap();
        HashMap<String, Alert> theirs = ((BasicAlert)alert).getSubAlertsMap();
        for (String id : mine.keySet()) {
            Alert theirAlert = theirs.get(id);
            if (theirAlert == null) continue;
            Alert myAlert = mine.get(id);
            myAlert.copyTriggeredStateFrom(theirAlert);
        }
    }

    private HashMap<String, Alert> getSubAlertsMap() {
        HashMap<String, Alert> map = new HashMap<String, Alert>();
        for (ArrayList<Alert> triggers : this.triggerIDs) {
            for (Alert alert : triggers) {
                map.put(alert.getID(), alert);
            }
        }
        for (ArrayList<Alert> resets : this.resetIDs) {
            for (Alert alert : resets) {
                map.put(alert.getID(), alert);
            }
        }
        return map;
    }

    @Override
    public ArrayList<Alert> getAllSubAlerts() {
        ArrayList<Alert> tmp = new ArrayList<Alert>();
        for (ArrayList<Alert> triggers : this.triggerIDs) {
            for (Alert alert : triggers) {
                tmp.add(alert);
            }
        }
        for (ArrayList<Alert> resets : this.resetIDs) {
            for (Alert alert : resets) {
                tmp.add(alert);
            }
        }
        return tmp;
    }

    public void setTrigger(boolean intraGroupsAND, ArrayList<ArrayList<Alert>> triggers, long ms) {
        this.triggerIntraGroupsAND = intraGroupsAND;
        this.triggerIDs = triggers;
        this.triggerMS = ms;
    }

    public void setReset(boolean intraGroupsAND, ArrayList<ArrayList<Alert>> resets, long ms) {
        this.resetIntraGroupsAND = intraGroupsAND;
        this.resetIDs = resets;
        this.resetMS = ms;
    }

    public static void main(String[] args) throws Exception {
        CentralDebugging.ALERT_BASIC_ALERT_LOGIC = true;
        CentralDebugging.ALERT_BASIC_ALERT = true;
        BasicAlert ba = new BasicAlert();
        ba.setName("BASIC");
        FakeAlert f1 = new FakeAlert();
        FakeAlert f2 = new FakeAlert();
        f1.setName("TRIG-1");
        f2.setName("RESET-1");
        ArrayList<ArrayList<Alert>> trigs = new ArrayList<ArrayList<Alert>>();
        ArrayList<ArrayList<Alert>> resets = new ArrayList<ArrayList<Alert>>();
        ArrayList<FakeAlert> a1 = new ArrayList<FakeAlert>();
        ArrayList<FakeAlert> a2 = new ArrayList<FakeAlert>();
        a1.add(f1);
        a2.add(f2);
        trigs.add(a1);
        resets.add(a2);
        ba.setTrigger(true, trigs, 10L);
        ba.setReset(true, resets, 10L);
        ba.alertTriggered(f1);
        Thread.sleep(100L);
        ba.timePassed();
        ba.alertReset(f1);
        ba.alertTriggered(f2);
        Thread.sleep(100L);
        ba.timePassed();
    }

    public long getTriggerTimeMS() {
        return this.triggerMS;
    }

    public long getResetTimeMS() {
        return this.resetMS;
    }

    public boolean getTriggerIntraGroupsAND() {
        return this.triggerIntraGroupsAND;
    }

    public boolean getResetIntraGroupsAND() {
        return this.resetIntraGroupsAND;
    }

    public ArrayList<ArrayList<Alert>> getTriggers() {
        return this.triggerIDs;
    }

    public ArrayList<ArrayList<Alert>> getResets() {
        return this.resetIDs;
    }

    private AlertIterator getIt() {
        return new AlertIterator(this.triggerIDs, this.resetIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getStateOf(String id) {
        Boolean b;
        Object object = states_LOCK;
        synchronized (object) {
            b = states.get(id);
        }
        if (b == null) {
            return false;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setStateOf(String id, boolean triggered) {
        Object object = states_LOCK;
        synchronized (object) {
            states.put(id, triggered);
        }
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        Message triga = m.getNextMessage();
        this.triggerMS = triga.getNextLong();
        this.triggerIntraGroupsAND = triga.getNextBoolean();
        this.triggerIDs = this.listFromMessage(triga.getNextMessage());
        Message reset = m.getNextMessage();
        this.resetMS = reset.getNextLong();
        this.resetIntraGroupsAND = reset.getNextBoolean();
        this.resetIDs = this.listFromMessage(reset.getNextMessage());
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        Message triga = new Message();
        triga.append(this.triggerMS);
        triga.append(this.triggerIntraGroupsAND);
        triga.append(this.listToMessage(this.triggerIDs));
        Message reset = new Message();
        reset.append(this.resetMS);
        reset.append(this.resetIntraGroupsAND);
        reset.append(this.listToMessage(this.resetIDs));
        m.append(triga);
        m.append(reset);
    }

    private ArrayList<ArrayList<Alert>> listFromMessage(Message m) {
        ArrayList<ArrayList<Alert>> groups = new ArrayList<ArrayList<Alert>>();
        while (m.hasNext()) {
            Message group = m.getNextMessage();
            ArrayList<Alert> list = new ArrayList<Alert>();
            while (group.hasNext()) {
                Message alert = group.getNextMessage();
                list.add(ResourceSerialiser.alertFromMessage(alert));
            }
            if (list.size() <= 0) continue;
            groups.add(list);
        }
        return groups;
    }

    private Message listToMessage(ArrayList<ArrayList<Alert>> ids) {
        Message groups = new Message();
        for (ArrayList<Alert> list : ids) {
            Message group = new Message();
            for (Alert alert : list) {
                group.append(ResourceSerialiser.alertToMessage(alert));
            }
            if (group.length() <= 0) continue;
            groups.append(group);
        }
        return groups;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void alertReset(Alert sub) {
        boolean isMine = false;
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert child = it.next();
            if (sub.getID().equals(child.getID())) {
                isMine = true;
            }
            child.alertReset(sub);
        }
        if (isMine && CentralDebugging.SG_ALERTS) {
            System.out.println("[BasicAlert] Threshold " + this.getName() + "/" + sub.getName() + " notified state is OFF (reset)");
        }
        BasicAlert.setStateOf(sub.getID(), false);
        this.updateMyState();
    }

    @Override
    public void alertTriggered(Alert sub) {
        boolean isMine = false;
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert child = it.next();
            if (sub.getID().equals(child.getID())) {
                isMine = true;
            }
            child.alertTriggered(sub);
        }
        if (isMine && CentralDebugging.SG_ALERTS) {
            System.out.println("[BasicAlert] Threshold " + this.getName() + "/" + sub.getName() + " notified state is ON (triggered)");
        }
        BasicAlert.setStateOf(sub.getID(), true);
        this.updateMyState();
    }

    private boolean getGroupState(boolean intraGroupsAND, ArrayList<Alert> ids) {
        boolean all = true;
        boolean any = false;
        for (Alert id : ids) {
            if (BasicAlert.getStateOf(id.getID())) {
                if (CentralDebugging.ALERT_BASIC_ALERT_THRESHOLDS) {
                    System.out.println("[BasicAlert] " + this.getName() + " state of child " + id.getName() + " is triggered");
                }
                any = true;
                continue;
            }
            if (CentralDebugging.ALERT_BASIC_ALERT_THRESHOLDS) {
                System.out.println("[BasicAlert] " + this.getName() + " state of child " + id.getName() + " is reset");
            }
            all = false;
        }
        boolean groupState = intraGroupsAND ? all : any;
        return groupState;
    }

    private boolean getExpressionState(boolean intraGroupsAND, ArrayList<ArrayList<Alert>> list) {
        boolean stateTriggered = false;
        boolean groupsAll = true;
        boolean groupsAny = false;
        if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
            System.out.println("[AlExpState] Begin (intraGroupsAND=" + intraGroupsAND + ")");
        }
        for (ArrayList<Alert> ids : list) {
            if (this.getGroupState(intraGroupsAND, ids)) {
                if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
                    System.out.println("[AlExpState] Group ON");
                }
                groupsAny = true;
                continue;
            }
            if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
                System.out.println("[AlExpState] Group OFF");
            }
            groupsAll = false;
        }
        if (intraGroupsAND) {
            if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
                System.out.println("[AlExpState] Expression is AND of groups");
            }
            stateTriggered = groupsAny;
        } else {
            if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
                System.out.println("[AlExpState] Expression is OR of groups");
            }
            stateTriggered = groupsAll;
        }
        if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
            System.out.println("[AlExpState] Returning " + stateTriggered);
        }
        return stateTriggered;
    }

    private void updateMyState() {
        if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
            System.out.println("[AlExpState] Init " + this.triggerIDs.size() + " trigger groups");
        }
        if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
            System.out.println("[AlExpState] Init " + this.resetIDs.size() + " reset groups");
        }
        boolean amTriggered = this.getExpressionState(this.triggerIntraGroupsAND, this.triggerIDs);
        boolean amReset = this.getExpressionState(this.resetIntraGroupsAND, this.resetIDs);
        if (CentralDebugging.ALERT_BASIC_ALERT_THRESHOLDS) {
            System.out.println("[BasicAlert] " + this.getName() + " checked thresholds (" + amTriggered + "/" + amReset + ")");
        }
        if (amTriggered) {
            if (!this.myState) {
                this.myState = true;
                this.myStateTime = SafeClock.currentTimeMillis();
            }
        } else if (amReset && this.myState) {
            this.myState = false;
            this.myStateTime = SafeClock.currentTimeMillis();
        }
        if (CentralDebugging.SG_ALERTS) {
            System.out.println("[BasicAlert] " + this.getName() + " calculated state " + (this.myState ? "TRIGGERED" : "RESET") + " (amTriggered=" + amTriggered + "/amReset=" + amReset + ")");
        }
    }

    @Override
    public void timePassed() {
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            it.next().timePassed();
        }
        long stateAge = SafeClock.currentTimeMillis() - this.myStateTime;
        if (CentralDebugging.ALERT_BASIC_ALERT) {
            System.out.println("[BasicAlert] " + this.getName() + " time passed (visibleState=" + this.isTriggered() + ") (internalState=" + this.myState + ") (cur=" + stateAge + " vs tr=" + this.triggerMS + " / re=" + this.resetMS + ")");
        }
        if (this.myState) {
            if (stateAge > this.triggerMS) {
                if (CentralDebugging.ALERT_BASIC_ALERT) {
                    System.out.println("[BasicAlert] " + this.getName() + " Updating ongoing state to triggered");
                }
                this.updateTriggeredState(true);
            }
        } else if (stateAge > this.resetMS) {
            if (CentralDebugging.ALERT_BASIC_ALERT) {
                System.out.println("[BasicAlert] " + this.getName() + " Updating ongoing state to reset");
            }
            this.updateTriggeredState(false);
        }
        super.timePassed();
    }

    @Override
    public void securityStats(ArrayList<SecurityProduct> stats) {
        if (CentralDebugging.ALERT_BASIC_ALERT_INPUTS) {
            System.out.println("[BasicAlert] " + this.getName() + " Received security stats");
        }
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert alert = it.next();
            if (CentralDebugging.ALERT_BASIC_ALERT_INPUTS) {
                System.out.println("[BasicAlert] " + this.getName() + " passing stats to " + alert);
            }
            alert.securityStats(stats);
        }
    }

    @Override
    public void machineStats(Stats stats) {
        if (CentralDebugging.ALERT_BASIC_ALERT_INPUTS) {
            System.out.println("[BasicAlert] " + this.getName() + " Received machine stats");
        }
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert alert = it.next();
            if (CentralDebugging.ALERT_BASIC_ALERT_INPUTS) {
                System.out.println("[BasicAlert] " + this.getName() + " passing stats to " + alert);
            }
            alert.machineStats(stats);
        }
    }

    @Override
    public String getTypeNameKey() {
        return null;
    }

    @Override
    public String getTypeDescKey() {
        return null;
    }

    @Override
    public String getTypeIconKey() {
        return null;
    }

    @Override
    public String getTypeOverlayKey() {
        return null;
    }

    @Override
    public String getDefaultName() {
        return "ERROR";
    }

    @Override
    public Alert createCorollary() {
        return this;
    }

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    public String getTriggersAsString() {
        String result = this.getAlertsAsString(this.triggerIDs, this.triggerIntraGroupsAND);
        if (result.length() == 0) {
            return Language.get("ALERT_TRIGGERS_NONE");
        }
        return result;
    }

    public String getResetsAsString() {
        String result = this.getAlertsAsString(this.resetIDs, this.resetIntraGroupsAND);
        if (result.length() == 0) {
            return Language.get("ALERT_RESETS_NONE");
        }
        return result;
    }

    private String getAlertsAsString(ArrayList<ArrayList<Alert>> alertIDs, boolean intraGroupAND) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < alertIDs.size(); ++i) {
            ArrayList<Alert> group;
            if (i > 0) {
                buffer.append(" ").append(!intraGroupAND ? Language.get("AND") : Language.get("OR")).append(" ");
            }
            if ((group = alertIDs.get(i)).size() > 1) {
                buffer.append(" (");
            }
            for (int j = 0; j < group.size(); ++j) {
                Alert alert = group.get(j);
                if (j > 0) {
                    buffer.append(" ").append(intraGroupAND ? Language.get("AND") : Language.get("OR")).append(" ");
                }
                buffer.append(alert.getName());
            }
            if (group.size() <= 1) continue;
            buffer.append(") ");
        }
        return buffer.toString();
    }

    static class AlertIterator {
        ArrayList<Alert> all = new ArrayList();
        int index = 0;

        public AlertIterator(ArrayList<ArrayList<Alert>> one, ArrayList<ArrayList<Alert>> two) {
            this.add(one);
            this.add(two);
        }

        void add(ArrayList<ArrayList<Alert>> one) {
            for (ArrayList<Alert> list : one) {
                for (Alert alert : list) {
                    this.all.add(alert);
                }
            }
        }

        public boolean hasNext() {
            return this.index < this.all.size();
        }

        public Alert next() {
            return this.all.get(this.index++);
        }

        public void remove() {
        }
    }

    static class FakeAlert
    extends Alert {
        FakeAlert() {
        }

        @Override
        public String getTypeNameKey() {
            return null;
        }

        @Override
        public boolean canCreateCorollary() {
            return true;
        }

        @Override
        public String getTypeDescKey() {
            return null;
        }

        @Override
        public String getTypeIconKey() {
            return null;
        }

        @Override
        public String getTypeOverlayKey() {
            return null;
        }

        @Override
        public String getDefaultName() {
            return "ERROR";
        }

        protected void subFromMessage(Message m) {
        }

        protected Message subToMessage() {
            return null;
        }

        @Override
        public boolean isServerSideOnly() {
            return false;
        }

        public void forceState(boolean triggered) {
            this.updateTriggeredState(triggered);
        }

        @Override
        public Alert createCorollary() {
            return this;
        }
    }
}

