/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.Customer;
import java.util.Properties;
import java.util.Random;
import utils.message.Message;

public class PresentationMachine
extends AbstractMachine {
    private String osSummary;
    private int osBaseType;
    private int osVariant;
    private int osLinuxArch;

    @Override
    public String getRootTag() {
        return "PresentationMachine";
    }

    @Override
    public Message toMessage() {
        Message m = new Message();
        super.toMessage(m);
        return m;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.osBaseType);
        m.append(this.osVariant);
        m.append(this.osLinuxArch);
        m.append(this.osSummary);
    }

    @Override
    public String getOsSummary() {
        return this.osSummary;
    }

    @Override
    public int getOsBaseType() {
        return this.osBaseType;
    }

    @Override
    public int getOsVariant() {
        return this.osVariant;
    }

    @Override
    public int getOsLinuxArch() {
        return this.osLinuxArch;
    }

    @Override
    public void handleXMLElement(String element, String value, String attribute) {
        if (element.equals("OSBaseType")) {
            this.osBaseType = Integer.parseInt(value);
        } else if (element.equals("OSVariant")) {
            this.osVariant = Integer.parseInt(value);
        } else if (element.equals("OSLinuxArch")) {
            this.osLinuxArch = Integer.parseInt(value);
        } else if (element.equals("OSSummary")) {
            this.osSummary = value;
        } else {
            super.handleXMLElement(element, value, attribute);
        }
    }

    public static PresentationMachine createTestMachine() {
        PresentationMachine machine = new PresentationMachine();
        Random r = new Random();
        machine.osBaseType = r.nextInt(3);
        machine.osVariant = r.nextInt(7) + 1;
        switch (machine.osBaseType) {
            case 2: {
                machine.osSummary = "Linux v" + r.nextInt(1000);
                break;
            }
            case 1: {
                machine.osSummary = "MacOS v" + r.nextInt(1000);
                break;
            }
            case 0: {
                machine.osSummary = "Windows v" + r.nextInt(1000);
            }
        }
        return machine;
    }

    public static PresentationMachine createFrom(Customer customer) {
        PresentationMachine machine = new PresentationMachine();
        machine.osSummary = customer.getOsSummary();
        machine.osBaseType = customer.getOsBaseType();
        machine.osVariant = customer.getOsVariant();
        machine.osLinuxArch = customer.getOsLinuxArch();
        return machine;
    }

    @Override
    public void toProperties(Properties properties) {
    }
}

