/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.ServerManagement;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.TypeUtil;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWWindowsOS;
import utils.message.Message;
import utils.osstats.ip.IpStats;
import utils.ostools.OS;

public class Customer
extends AbstractMachine {
    public static final byte TYPE_SH = 0;
    public static final byte TYPE_SG = 1;
    public static final byte TYPE_DEMO = 2;
    private byte type;
    private String customerID;
    private long waitingFor;
    private String remoteUsername;
    private String country;
    private String requestDomain;
    private String requestURL;
    private String[] localIPs;
    private String localHostname;
    private String wanIP;
    private String[] detailsKeys = new String[0];
    private String[] detailsValues = new String[0];
    private int osBaseType;
    private int osVariant;
    private int osLinuxArch;
    private String osSummary;
    private transient String[] requestedTechFilters = null;
    private transient String[] requestedGroupFilters = null;
    static final String[] firstNames = new String[]{"George", "Antony", "Bob", "Phil", "Megatron", "Scott", "Mark", "Tony", "Anderson", "O'Connor"};
    private static final String[] lastNames = new String[]{"Prime", "Christelis", "Miguel", "Clooney", "Optimus", "Putin", "Blair", "Bush", "Franco"};
    private static final String[] companyNames = new String[]{"SimpleHelp Ltd", "Servoyant", "Microsoft Monicles", "Byzantine Bakeries and Baggery"};
    static int prev = 0;

    public Customer(byte type) {
        if (!ServerManagement.isServerJVM()) {
            this.detectOS();
        }
        this.type = type;
        this.remoteUsername = System.getProperty("user.name");
        this.country = System.getProperty("user.country") + " (" + System.getProperty("user.timezone") + ")";
    }

    private void detectOS() {
        OS.isWindows();
        this.osBaseType = OS.base_type;
        this.osVariant = OS.variant;
        this.osLinuxArch = OS.linux_arch;
        this.osSummary = JWGenericOS.getInstance().getOSDescription().getFullName();
    }

    public Customer(Message m) {
        this(0);
        this.fromMessage(m);
    }

    @Override
    public Message toMessage() {
        Message m = new Message();
        super.toMessage(m);
        m.append(this.type);
        m.append(this.osBaseType);
        m.append(this.osVariant);
        m.append(this.osLinuxArch);
        m.append(this.osSummary);
        m.append(this.customerID);
        m.append(this.waitingFor);
        m.append(this.remoteUsername);
        m.append(this.country);
        m.append(this.requestDomain);
        m.append(this.requestURL);
        if (this.detailsKeys == null) {
            m.append(0);
        } else {
            m.append(this.detailsKeys.length);
            for (int i = 0; i < this.detailsKeys.length; ++i) {
                String key = this.detailsKeys[i];
                String value = this.detailsValues[i];
                m.append(key);
                m.append(value);
            }
        }
        m.append(this.localHostname);
        if (this.localIPs == null || this.localIPs.length == 0) {
            m.append(0);
        } else {
            m.append(this.localIPs.length);
            for (String localIP : this.localIPs) {
                m.append(localIP);
            }
        }
        m.append(this.wanIP);
        return m;
    }

    @Override
    public void fromMessage(Message m) {
        int i;
        super.fromMessage(m);
        this.type = m.getNextByte();
        this.osBaseType = m.getNextInt();
        this.osVariant = m.getNextInt();
        this.osLinuxArch = m.getNextInt();
        this.osSummary = m.getNextString();
        this.customerID = m.getNextString();
        this.waitingFor = m.getNextLong();
        this.remoteUsername = m.getNextString();
        this.country = m.getNextString();
        this.requestDomain = m.getNextString();
        this.requestURL = m.getNextString();
        int count = m.getNextInt();
        this.detailsKeys = new String[count];
        this.detailsValues = new String[count];
        for (i = 0; i < count; ++i) {
            this.detailsKeys[i] = m.getNextString();
            this.detailsValues[i] = m.getNextString();
        }
        if (this.version > 0) {
            this.localHostname = m.getNextString();
            count = m.getNextInt();
            this.localIPs = new String[count];
            for (i = 0; i < count; ++i) {
                this.localIPs[i] = m.getNextString();
            }
            this.wanIP = m.getNextString();
        }
    }

    public Customer(byte type, String customerID) {
        this(type);
        this.setCustomerID(customerID);
    }

    @Override
    public void toXML(StringBuffer buffer, int tabCount) {
        int i;
        String tabs = TypeUtil.getTabString(tabCount);
        buffer.append(tabs).append("<Customer>\n");
        TypeUtil.append(buffer, "Type", this.type, tabCount + 1);
        TypeUtil.append(buffer, "OSBaseType", this.osBaseType, tabCount + 1);
        TypeUtil.append(buffer, "OSVariant", this.osVariant, tabCount + 1);
        TypeUtil.append(buffer, "OSLinuxArch", this.osLinuxArch, tabCount + 1);
        TypeUtil.append(buffer, "OSSummary", this.osSummary, tabCount + 1);
        TypeUtil.append(buffer, "CustomerID", this.customerID, tabCount + 1);
        TypeUtil.append(buffer, "WaitingFor", this.waitingFor, tabCount + 1);
        TypeUtil.append(buffer, "RemoteUsername", this.remoteUsername, tabCount + 1);
        TypeUtil.append(buffer, "Country", this.country, tabCount + 1);
        TypeUtil.append(buffer, "RequestDomain", this.requestDomain, tabCount + 1);
        TypeUtil.append(buffer, "RequestURL", this.requestURL, tabCount + 1);
        TypeUtil.append(buffer, "DetailsSize", this.detailsKeys.length, tabCount + 1);
        for (i = 0; i < this.detailsKeys.length; ++i) {
            TypeUtil.append(buffer, "Key", this.detailsKeys[i], Integer.toString(i), tabCount + 1);
            TypeUtil.append(buffer, "Value", this.detailsValues[i], Integer.toString(i), tabCount + 1);
        }
        TypeUtil.append(buffer, "Hostname", this.localHostname, tabCount + 1);
        TypeUtil.append(buffer, "WanIP", this.wanIP, tabCount + 1);
        if (this.localIPs == null) {
            TypeUtil.append(buffer, "IPSize", 0L, tabCount + 1);
        } else {
            TypeUtil.append(buffer, "IPSize", this.localIPs.length, tabCount + 1);
            for (i = 0; i < this.localIPs.length; ++i) {
                TypeUtil.append(buffer, "IPElement", this.localIPs[i], Integer.toString(i), tabCount + 1);
            }
        }
        super.toXML(buffer, tabCount + 1);
        buffer.append(tabs).append("</Customer>\n");
    }

    @Override
    public void handleXMLElement(String element, String value, String attribute) {
        if (element.equals("Type")) {
            this.type = Byte.parseByte(value);
        } else if (element.equals("OSBaseType")) {
            this.osBaseType = Integer.parseInt(value);
        } else if (element.equals("OSVariant")) {
            this.osVariant = Integer.parseInt(value);
        } else if (element.equals("OSLinuxArch")) {
            this.osLinuxArch = Integer.parseInt(value);
        } else if (element.equals("OSSummary")) {
            this.osSummary = value;
        } else if (element.equals("CustomerID")) {
            this.customerID = value;
        } else if (element.equals("WaitingFor")) {
            this.waitingFor = Long.parseLong(value);
        } else if (element.equals("RemoteUsername")) {
            this.remoteUsername = value;
        } else if (element.equals("Country")) {
            this.country = value;
        } else if (element.equals("RequestDomain")) {
            this.requestDomain = value;
        } else if (element.equals("RequestURL")) {
            this.requestURL = value;
        } else if (element.equals("Hostname")) {
            this.localHostname = value;
        } else if (element.equals("WanIP")) {
            this.wanIP = value;
        } else if (element.equals("IPSize")) {
            int size = Integer.parseInt(value);
            this.localIPs = new String[size];
        } else if (element.startsWith("IPElement")) {
            int index = Integer.parseInt(attribute);
            this.localIPs[index] = value;
        } else if (element.equals("DetailsSize")) {
            int size = Integer.parseInt(value);
            this.detailsKeys = new String[size];
            this.detailsValues = new String[size];
        } else if (element.startsWith("Key")) {
            int index = Integer.parseInt(attribute);
            this.detailsKeys[index] = value;
        } else if (element.startsWith("Value")) {
            int index = Integer.parseInt(attribute);
            this.detailsValues[index] = value;
        } else {
            super.handleXMLElement(element, value, attribute);
        }
    }

    public void setOneTimeTechFilters(String techFilter, String groupFilters) {
        if (techFilter != null) {
            this.requestedTechFilters = techFilter.split("\\,");
        }
        if (groupFilters != null) {
            this.requestedGroupFilters = groupFilters.split("\\,");
        }
    }

    public boolean hasOneTimeTechFilters() {
        return this.requestedTechFilters != null && this.requestedTechFilters.length > 0 || this.requestedGroupFilters != null && this.requestedGroupFilters.length > 0;
    }

    @Override
    public String getRootTag() {
        return "Customer";
    }

    public boolean isSH() {
        return this.type == 0;
    }

    public boolean isSG() {
        return this.type == 1;
    }

    public boolean isDemo() {
        return this.type == 2;
    }

    public void setCustomerID(String customerID) {
        this.customerID = customerID;
    }

    public long getWaitingFor() {
        return this.waitingFor;
    }

    public void setWaitingFor(long waitingFor) {
        this.waitingFor = waitingFor;
    }

    public String getRemoteUsername() {
        return this.remoteUsername;
    }

    public void setRemoteUsername(String remoteUsername) {
        this.remoteUsername = remoteUsername;
    }

    public void setWanIP(String wanIP) {
        this.wanIP = wanIP;
    }

    public String getWanIP() {
        return this.wanIP;
    }

    public String getHostname() {
        return this.localHostname;
    }

    public String[] getLocalIPs() {
        return this.localIPs;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getRequestDomain() {
        return this.requestDomain;
    }

    public void setRequestDomain(String requestDomain) {
        this.requestDomain = requestDomain;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public String[] getDetailsKeys() {
        return this.detailsKeys;
    }

    public void setDetailsKeys(String[] detailsKeys) {
        this.detailsKeys = detailsKeys;
    }

    public String[] getDetailsValues() {
        return this.detailsValues;
    }

    public void setDetailsValues(String[] detailsValues) {
        this.detailsValues = detailsValues;
    }

    public String getValue(String key, boolean ignoreCase) {
        if (key.equals("ID") || ignoreCase && key.toLowerCase().equals("id")) {
            return this.customerID;
        }
        if (this.detailsKeys == null) {
            return null;
        }
        for (int i = 0; i < this.detailsKeys.length; ++i) {
            if (this.detailsKeys[i].equals(key)) {
                return this.detailsValues[i];
            }
            if (!ignoreCase || !this.detailsKeys[i].toLowerCase().equals(key.toLowerCase())) continue;
            return this.detailsValues[i];
        }
        return null;
    }

    public String toLogString(int indent) {
        int i;
        StringBuilder buffer = new StringBuilder();
        for (i = 0; i < indent; ++i) {
            buffer.append("\t");
        }
        for (i = 0; i < this.detailsKeys.length; ++i) {
            for (int j = 0; j < indent; ++j) {
                buffer.append("\t");
            }
            buffer.append(this.detailsKeys[i]).append(": ").append(this.detailsValues[i]);
            buffer.append("\n");
        }
        buffer.append("\t").append(Language.get("OPERATING_SYSTEM")).append(": ").append(this.getOsSummary());
        buffer.append("\t").append(Language.get("USERNAME")).append(": ").append(this.remoteUsername);
        buffer.append("\t").append(Language.get("COUNTRY")).append(": ").append(this.country);
        if (this.requestDomain != null) {
            buffer.append("\t").append(Language.get("CONNECT_DOMAIN")).append(": ").append(this.requestDomain);
        }
        if (this.requestURL != null) {
            buffer.append("\t").append(Language.get("CONNECT_URL")).append(": ").append(this.requestURL);
        }
        buffer.append("\t").append(Language.get("HOSTNAME")).append(": ").append(this.localHostname);
        buffer.append("\t").append(Language.get("WAN IP")).append(": ").append(this.wanIP);
        buffer.append("\t").append(Language.get("LAN IP")).append(": ").append(this.getLocalIPsAsString());
        return buffer.toString();
    }

    public String getLocalIPsAsString() {
        if (this.localIPs == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.localIPs.length; ++i) {
            if (i > 0) {
                result.append(" / ");
            }
            result.append(this.localIPs[i]);
        }
        return result.toString();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeId) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.detailsKeys.length; ++i) {
            buffer.append(" (").append(this.detailsKeys[i]).append(":").append(this.detailsValues[i]).append(")");
        }
        if (includeId) {
            buffer.append(" [ID:").append(this.getCustomerID()).append(":ID]");
        }
        buffer.append(" (OS:").append(super.toString()).append(")");
        buffer.append(" (Country:").append(this.country).append(")");
        buffer.append(" (OS User:").append(this.remoteUsername).append(")");
        if (this.requestDomain != null) {
            buffer.append(" (Domain:").append(this.requestDomain).append(")");
        }
        if (this.requestURL != null) {
            buffer.append(" (URL:").append(this.requestURL).append(")");
        }
        return buffer.toString();
    }

    public String getUsefulHumanReadableName() {
        String nameIfExists = this.getValue("Name", true);
        if (nameIfExists != null) {
            return nameIfExists;
        }
        nameIfExists = this.getValue("", true);
        if (nameIfExists != null) {
            return nameIfExists;
        }
        if (this.detailsKeys != null && this.detailsKeys.length > 0 && (nameIfExists = this.getValue(this.detailsKeys[0], true)) != null) {
            return nameIfExists;
        }
        if (this.remoteUsername != null) {
            return this.remoteUsername;
        }
        return this.customerID;
    }

    public String getCustomerID() {
        return this.customerID;
    }

    public boolean hasDetails() {
        return this.detailsKeys != null && this.detailsKeys.length > 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer type = (Customer)o;
        return this.getCustomerID().equals(type.getCustomerID());
    }

    public void copyDataFrom(Customer other) {
        this.setWaitingFor(other.getWaitingFor());
    }

    public static Customer fromXML(String xml) {
        Customer customer = new Customer(0);
        TypeUtil.fromXML(xml, customer);
        return customer;
    }

    public static Customer createTestCustomer() {
        Customer customer = new Customer(0);
        Random r = new Random();
        customer.setCustomerID("" + r.nextLong());
        String name = firstNames[r.nextInt(firstNames.length)] + " " + lastNames[r.nextInt(lastNames.length)];
        String company = companyNames[r.nextInt(companyNames.length)];
        customer.setWaitingFor(r.nextInt(30000));
        customer.setWaitingFor(Math.max(1L, customer.getWaitingFor()));
        customer.osBaseType = r.nextInt(3);
        customer.osVariant = r.nextInt(7) + 1;
        switch (customer.osBaseType) {
            case 2: {
                customer.osSummary = "Linux v" + r.nextInt(1000);
                break;
            }
            case 1: {
                customer.osSummary = "MacOS v" + r.nextInt(1000);
                break;
            }
            case 0: {
                customer.osSummary = "Windows v" + r.nextInt(1000);
            }
        }
        customer.setDetailsKeys(new String[]{"Name", "Company", "Life"});
        customer.setDetailsValues(new String[]{name, company, "Yes"});
        return customer;
    }

    @Override
    public String getOsSummary() {
        return this.osSummary;
    }

    @Override
    public int getOsBaseType() {
        return this.osBaseType;
    }

    @Override
    public int getOsVariant() {
        return this.osVariant;
    }

    @Override
    public int getOsLinuxArch() {
        return this.osLinuxArch;
    }

    public void detectNetworkSettings() {
        int i;
        try {
            this.localHostname = JWGenericOS.getInstance().getHostname();
        }
        catch (Throwable t) {
            System.out.println("[Customer] Unable to use native API query for hostname");
            t.printStackTrace();
        }
        this.localIPs = null;
        if (OS.isWindows()) {
            try {
                JWWindowsOS.NetworkAdapterInfo[] networkInfo = JWWindowsOS.getWindowsInstance().getNetworkInfo();
                if (networkInfo != null) {
                    this.localIPs = new String[networkInfo.length];
                    for (i = 0; i < this.localIPs.length; ++i) {
                        this.localIPs[i] = networkInfo[i].ipAddress;
                    }
                }
            }
            catch (Throwable t) {
                System.out.println("[Customer] Unable to use native API query for network stats");
                t.printStackTrace();
                this.localIPs = null;
            }
        }
        if (this.localIPs == null) {
            try {
                String[] pairs = IpStats.getIpMacPairs();
                this.localIPs = new String[pairs.length];
                for (i = 0; i < this.localIPs.length; ++i) {
                    this.localIPs[i] = pairs[i].substring(0, pairs[i].indexOf(47)).trim();
                }
            }
            catch (Throwable tt) {
                tt.printStackTrace();
            }
        }
        if (this.localIPs == null) {
            this.localIPs = new String[0];
        }
        Arrays.sort(this.localIPs);
    }

    @Override
    public boolean matchesFilter(String filter) {
        if (super.matchesFilter(filter)) {
            return true;
        }
        if (this.remoteUsername != null && this.remoteUsername.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.country != null && this.country.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.requestDomain != null && this.requestDomain.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.requestURL != null && this.requestURL.toLowerCase().contains(filter)) {
            return true;
        }
        for (String s : this.localIPs) {
            if (s == null || !s.toLowerCase().contains(filter)) continue;
            return true;
        }
        if (this.localHostname != null && this.localHostname.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.wanIP != null && this.wanIP.toLowerCase().contains(filter)) {
            return true;
        }
        for (String s : this.detailsValues) {
            if (s == null || !s.toLowerCase().contains(filter)) continue;
            return true;
        }
        return false;
    }

    public void debugSetOSInfo(int os, int variant, String summary) {
        this.osBaseType = os;
        this.osVariant = variant;
        this.osSummary = summary;
    }

    @Override
    public void toProperties(Properties properties) {
        properties.put("customer", this.getUsefulHumanReadableName());
    }

    public boolean includesTechnicianInFilter(TechUser techUser, MergedTechGroup loggedInContext) {
        boolean haveTechGroupFilter;
        if (techUser.isServerAdmin()) {
            return true;
        }
        if (!this.hasOneTimeTechFilters()) {
            return true;
        }
        boolean haveTechFilter = this.requestedTechFilters != null && this.requestedTechFilters.length > 0;
        boolean bl = haveTechGroupFilter = this.requestedGroupFilters != null && this.requestedGroupFilters.length > 0;
        if (haveTechFilter) {
            for (String techFilter : this.requestedTechFilters) {
                if (techFilter == null || !techUser.getLogin().toLowerCase().equals(techFilter.trim().toLowerCase())) continue;
                return true;
            }
        }
        if (haveTechGroupFilter) {
            for (String techGroupFilter : this.requestedGroupFilters) {
                if (techGroupFilter == null || loggedInContext == null) continue;
                for (String groupName : loggedInContext.getGroupNames()) {
                    if (groupName == null || !techGroupFilter.equalsIgnoreCase(groupName)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

