/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.proxy.alerts.AlertRegistryAPI;
import com.aem.shelp.proxy.types.AlertInput;
import com.aem.shelp.proxy.types.FastXMLInterface;
import com.aem.shelp.proxy.types.GlobalEvents;
import com.aem.shelp.proxy.types.TypeUtil;
import com.aem.shelp.proxy.types.VersionType;
import com.aem.shelp.proxy.types.alerts.BasicAlert;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import com.aem.shelp.proxy.types.alerts.threshold.CPUThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.TimerEventSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import utils.message.Message;
import utils.osstats.AbstractStats;
import utils.osstats.Stats;
import utils.osstats.av.SecurityProduct;
import utils.xml.XML14Util;

public abstract class Alert
extends VersionType
implements FastXMLInterface,
TypeUtil.XMLListener,
AlertInput {
    private static boolean READ_ONLY_ALERTS = false;
    private static int RO_FAILS = 0;
    String alertID = Alert.nextID();
    String alertName;
    long modifiedClock = 0L;
    private boolean active = true;
    private boolean usingDefaultName = true;
    String masterID = "";
    private long lastStateReport = 0L;
    private long lastStateChange = SafeClock.currentTimeMillis();
    private boolean triggeredState = false;
    private long nextStateReport = 0L;
    protected static final boolean TRIGGERED = true;
    protected static final boolean RESET = false;

    public static void setReadOnlyAlerts(boolean b) {
        READ_ONLY_ALERTS = b;
    }

    public static boolean isReadOnly() {
        return READ_ONLY_ALERTS;
    }

    public static boolean readOnlyAlerts() {
        if (READ_ONLY_ALERTS && RO_FAILS < 10) {
            ++RO_FAILS;
            new Exception("Warning: read only alert modification attempted").printStackTrace();
        }
        return READ_ONLY_ALERTS;
    }

    public ArrayList<Alert> getAllSubAlerts() {
        return new ArrayList<Alert>();
    }

    public boolean isActive() {
        if (this instanceof BasicAlert) {
            return this.active;
        }
        return true;
    }

    public void setActive(boolean b) {
        if (Alert.readOnlyAlerts()) {
            return;
        }
        this.active = this instanceof BasicAlert ? b : true;
    }

    public void importIDfrom(Alert alert) {
        if (Alert.readOnlyAlerts()) {
            return;
        }
        this.alertID = alert.alertID;
    }

    public void setIsCorollaryFor(String id) {
        if (Alert.readOnlyAlerts()) {
            return;
        }
        this.masterID = id;
    }

    public String isCorollaryFor() {
        return this.masterID;
    }

    public boolean amCorollary() {
        return this.masterID != null && this.masterID.length() > 0;
    }

    public void setUsingDefaultName(boolean b) {
        if (Alert.readOnlyAlerts()) {
            return;
        }
        this.usingDefaultName = b;
    }

    public boolean isUsingDefaultName() {
        return this.usingDefaultName;
    }

    public void updateModifiedClock(AlertRegistryAPI reg) {
        if (Alert.readOnlyAlerts()) {
            return;
        }
        this.modifiedClock = reg.getClock().updateClock();
    }

    public long getModifiedClock() {
        return this.modifiedClock;
    }

    public abstract boolean canCreateCorollary();

    public abstract String getTypeNameKey();

    public abstract String getTypeDescKey();

    public abstract String getTypeIconKey();

    public abstract String getTypeOverlayKey();

    public abstract Alert createCorollary();

    public abstract String getDefaultName();

    public Alert cloneWithNewID() {
        Alert alert = ResourceSerialiser.alertFromMessage(ResourceSerialiser.alertToMessage(this));
        if (!Alert.readOnlyAlerts()) {
            alert.alertID = Alert.nextID();
            System.out.println("[Alerts] ***WARNING: alert clone with new ID was attempted but alerts are read only");
        }
        return alert;
    }

    public static long alertIDtoLong(String id) {
        return Long.parseLong(id.substring(3));
    }

    public static String longToAlertID(long value) {
        return "AL-" + value;
    }

    public static String nextID() {
        return "AL-" + Math.abs(BCUtil.getSecureRandom().nextLong());
    }

    public String getID() {
        return this.alertID;
    }

    public void setName(String s) {
        if (Alert.readOnlyAlerts()) {
            return;
        }
        this.alertName = s;
    }

    public String getName() {
        return this.alertName;
    }

    public void fromMessage(Message m) {
        this.version = m.getNextByte();
        this.alertID = m.getNextString();
        this.alertName = m.getNextString();
        this.modifiedClock = m.getNextLong();
        this.usingDefaultName = m.getNextBoolean();
        this.masterID = m.getNextString();
        if (m.getNextType() == 4) {
            Message expansion = m.getNextMessage();
            this.active = expansion.getNextBoolean();
            this.triggeredState = expansion.getNextBoolean();
        } else {
            this.active = m.getNextBoolean();
        }
    }

    public void toMessage(Message m) {
        m.append(this.version);
        m.append(this.alertID);
        if (this.alertName != null) {
            m.append(this.alertName.toString());
        } else {
            m.append((String)null);
        }
        m.append(this.modifiedClock);
        m.append(this.usingDefaultName);
        m.append(this.masterID);
        Message expand = new Message();
        expand.append(this.active);
        expand.append(this.triggeredState);
        m.append(expand);
    }

    public static Alert createTestAlert() {
        Random r = new Random();
        BasicAlert alert = new BasicAlert();
        alert.setName("Alert " + r.nextInt(100));
        return alert;
    }

    @Override
    public void handleXMLElement(String element, String value, String attributeValue) {
        if (element.equals("AlertID")) {
            this.alertID = value;
        } else if (element.equals("AlertName")) {
            this.alertName = XML14Util.unescape(value);
        }
    }

    @Override
    public String getRootTag() {
        return "Alert";
    }

    public String toXML() {
        return this.toXML(0);
    }

    protected StringBuffer indent(StringBuffer sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer sb = new StringBuffer();
        this.indent(sb, indent).append("Alert: " + this.getName()).append(" (").append(this.getID()).append(") (v" + this.version + ")").append('\n');
        this.indent(sb, indent).append("  Clock: " + this.getModifiedClock()).append('\n');
        this.indent(sb, indent).append("  DefName: " + this.usingDefaultName).append('\n');
        this.indent(sb, indent).append("  MasterID: " + this.masterID).append('\n');
        this.indent(sb, indent).append("  Active: " + this.active).append('\n');
        return sb.toString();
    }

    public String toXML(int tabs) {
        StringBuffer buffer = new StringBuffer();
        this.toXML(buffer, tabs);
        return buffer.toString();
    }

    public void toXML(StringBuffer buffer, int tabs) {
        String tab = TypeUtil.getTabString(tabs);
        buffer.append(tab).append("<" + this.getRootTag() + ">\n");
        TypeUtil.append(buffer, "AlertID", this.alertID, tabs + 1);
        TypeUtil.append(buffer, "AlertName", this.alertName.toString(), tabs + 1);
        buffer.append(tab).append("</" + this.getRootTag() + ">\n");
    }

    public abstract boolean isServerSideOnly();

    public boolean isTriggered() {
        return this.triggeredState;
    }

    public void setTriggeredState(boolean state) {
        this.triggeredState = state;
    }

    protected String getPrefix() {
        if (this.amThreshold()) {
            return "ThresholdState";
        }
        return "AlertState";
    }

    public void storeTriggeredStateInto(HashMap<String, Alert> store) {
        store.put(this.getID(), this);
    }

    public void copyTriggeredStateFrom(Alert alert) {
        this.triggeredState = alert.triggeredState;
        this.lastStateChange = alert.lastStateChange;
        this.nextStateReport = alert.nextStateReport;
        if (CentralDebugging.ALERT_STATE_VERBOSE) {
            System.out.println("[" + this.getPrefix() + "] " + this.getName() + " pulled next state report time " + alert.nextStateReport);
        }
        if (alert.isActive() != this.isActive()) {
            if (CentralDebugging.ALERT_STATE_VERBOSE) {
                System.out.println("[" + this.getPrefix() + "] " + this.getName() + " update of active status, will report asap");
            }
            this.triggeredState = false;
            this.lastStateChange = SafeClock.currentTimeMillis();
            this.nextStateReport = 0L;
        }
    }

    public long getStateAgeMS() {
        return SafeClock.currentTimeMillis() - this.lastStateChange;
    }

    private boolean amThreshold() {
        return !(this instanceof BasicAlert);
    }

    protected void updateTriggeredState(boolean triggered) {
        boolean willReportState;
        boolean bl = willReportState = triggered != this.triggeredState || this.amThreshold();
        if (this.amThreshold()) {
            if (CentralDebugging.ALERT_STATE_VERBOSE) {
                System.out.println("[" + this.getPrefix() + "] " + this.getName() + " (" + (willReportState ? "will report state NOW" : "state is consistent, no report required") + ") (state update: sampled=" + triggered + " vs ongoing=" + this.triggeredState + ", threshold=" + this.amThreshold() + ")");
            }
        } else if (CentralDebugging.ALERT_STATE_VERBOSE) {
            System.out.println("[" + this.getPrefix() + "] " + this.getName() + " (threshold) (state update: sampled=" + triggered + " vs ongoing=" + this.triggeredState + ", threshold=" + this.amThreshold() + ")");
        }
        if (willReportState) {
            this.triggeredState = triggered;
            this.lastStateChange = SafeClock.currentTimeMillis();
            if (CentralDebugging.ALERT_STATE_VERBOSE) {
                System.out.println("[" + this.getPrefix() + "] " + this.getName() + " requesting state report (ongoing state now=" + this.triggeredState + ")");
            }
            this.reportState(true);
        }
    }

    public long getLastStateReportAge() {
        return SafeClock.currentTimeMillis() - this.lastStateReport;
    }

    public long getNextStateReportWait() {
        return this.nextStateReport - SafeClock.currentTimeMillis();
    }

    private void reportState(boolean force) {
        if (CentralDebugging.ALERT_STATE_VERBOSE) {
            System.out.println("[" + this.getPrefix() + "] " + this.getName() + " " + this.getLastStateReportAge() + " since last state report, " + this.getNextStateReportWait() + " until next.");
        }
        if (force && CentralDebugging.ALERT_STATE_VERBOSE) {
            System.out.println("[" + this.getPrefix() + "] " + this.getName() + " Forcing a report of state (this is a state CHANGE).");
        }
        if (this.isActive() && force || SafeClock.currentTimeMillis() > this.nextStateReport) {
            if (CentralDebugging.ALERT_STATE_VERBOSE) {
                System.out.println("[" + this.getPrefix() + "] " + this.getName() + " reporting state (active=" + this.isActive() + ") (triggered=" + this.triggeredState + ") (required=" + force + ") (nextReport=" + this.nextStateReport + ")");
            }
            if (CentralDebugging.SG_ALERTS && !this.amThreshold()) {
                System.out.println("[BasicAlert] " + this.getName() + " (" + this.getID() + ") reporting state to server as " + (this.triggeredState ? "TRIGGERED" : "RESET"));
            }
            this.lastStateReport = SafeClock.currentTimeMillis();
            if (!this.isActive()) {
                System.out.println("[" + this.getPrefix() + "] " + this.getName() + " inactive, reporting state as reset");
                GlobalEvents.get().alertReset(this);
            } else if (this.triggeredState) {
                if (CentralDebugging.ALERT_STATE_VERBOSE) {
                    System.out.println("[" + this.getPrefix() + "] " + this.getName() + " reporting triggered event");
                }
                GlobalEvents.get().alertTriggered(this);
            } else {
                if (CentralDebugging.ALERT_STATE_VERBOSE) {
                    System.out.println("[" + this.getPrefix() + "] " + this.getName() + " reporting reset event");
                }
                GlobalEvents.get().alertReset(this);
            }
            long tSince = SafeClock.currentTimeMillis() - this.lastStateChange;
            this.nextStateReport = tSince < 15000L ? SafeClock.currentTimeMillis() + 20000L : (tSince < 60000L ? SafeClock.currentTimeMillis() + 60000L : (tSince < 300000L ? SafeClock.currentTimeMillis() + 300000L : SafeClock.currentTimeMillis() + 600000L));
            if (CentralDebugging.ALERT_STATE_VERBOSE) {
                System.out.println("[" + this.getPrefix() + "] " + this.getName() + " next report due in " + (this.nextStateReport - SafeClock.currentTimeMillis()));
            }
        }
    }

    @Override
    public void securityStats(ArrayList<SecurityProduct> secs) {
    }

    @Override
    public void machineStats(Stats stats) {
    }

    @Override
    public void timePassed() {
        if (CentralDebugging.ALERT_STATE_VERBOSE) {
            System.out.println("[" + this.getPrefix() + "] " + this.getName() + " pushing current state in case re-notification required");
        }
        this.reportState(false);
    }

    @Override
    public void alertTriggered(Alert alert) {
    }

    @Override
    public void alertReset(Alert alert) {
    }

    public static void main(String[] args) throws Exception {
        TimerEventSource secs = new TimerEventSource();
        secs.setName("MyTimer");
        CPUThreshold cpuHigh = new CPUThreshold();
        cpuHigh.setName("CPU High");
        cpuHigh.setTriggerPercent(75.0);
        cpuHigh.setTriggerOnOver(true);
        CPUThreshold cpuLow = new CPUThreshold();
        cpuLow.setName("CPU Low");
        cpuLow.setTriggerOnOver(false);
        cpuLow.setTriggerPercent(50.0);
        ArrayList<AlertInput> list = new ArrayList<AlertInput>();
        list.add(secs);
        list.add(cpuHigh);
        list.add(cpuLow);
        GlobalEvents.get().setAllAlerts(list);
        int pc = 70;
        while (true) {
            Thread.sleep(1000L);
            System.out.println("CPU: " + pc + "%");
            FakeStats stats = new FakeStats(pc);
            GlobalEvents.get().machineStats(stats);
            if (++pc != 100) continue;
            pc = 0;
        }
    }

    private static class FakeStats
    extends AbstractStats {
        FakeStats(int cpu) {
            super(true);
            this.cpuPercentage = cpu;
        }

        @Override
        public void update() {
        }

        @Override
        public void updateLight() {
        }

        @Override
        public String killProcess(String pid) {
            return null;
        }

        @Override
        public void killProcessListeningOn(int port, boolean tcp, boolean udp) {
        }
    }
}

