/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.techclient;

import com.aem.nodelink.utils.DataUtils;
import com.aem.shelp.licence.OemBranding;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jwrapper.jwutils.JWSystem;
import utils.encryption.aes.RijndaelDecryptionStream;
import utils.encryption.aes.RijndaelEncryptionStream;
import utils.files.AtomicFileOutputStream;
import utils.string.Normaliser;

public class TechTwoTierKeyManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getKeyFor(String techUsername, String url) {
        if (techUsername == null) {
            techUsername = OemBranding.OEM_ADMIN_USERNAME;
        }
        String KEY = "gy8UtTFBYb;Z1g3iuy12gi;e{m9PhiWl7t9djdbavs,msg3u14yy9783ndocmla..lrh2u3rhhhhh";
        File f = TechTwoTierKeyManager.getFileLocation(url, techUsername);
        if (!f.exists()) {
            return null;
        }
        FileInputStream fin = null;
        try {
            AtomicFileOutputStream.prepareForReading(f);
            fin = new FileInputStream(f);
            RijndaelDecryptionStream bfin = new RijndaelDecryptionStream((InputStream)new BufferedInputStream(fin), KEY);
            String string = DataUtils.readStringUTF8(bfin);
            return string;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                fin.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setKeyFor(String techUsername, String url, String key) throws IOException {
        if (techUsername == null) {
            techUsername = OemBranding.OEM_ADMIN_USERNAME;
        }
        String KEY = "gy8UtTFBYb;Z1g3iuy12gi;e{m9PhiWl7t9djdbavs,msg3u14yy9783ndocmla..lrh2u3rhhhhh";
        File f = TechTwoTierKeyManager.getFileLocation(url, techUsername);
        if (f.exists()) {
            f.delete();
        }
        if (key == null) {
            return;
        }
        AtomicFileOutputStream fout = new AtomicFileOutputStream(f);
        RijndaelEncryptionStream bfout = new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream(fout), KEY);
        DataUtils.writeStringUTF8(bfout, key);
        bfout.flush();
        bfout.close();
    }

    private static final File getFileLocation(String url, String techUsername) {
        System.out.println("[TwoTierKeyRepository] Retrieving ID file location");
        File parent = JWSystem.getAllAppVersionsSharedFolder();
        if (parent == null) {
            return new File("twotier" + Normaliser.safeWithoutNormalising(url) + "-" + Normaliser.safeWithoutNormalising(techUsername) + ".key");
        }
        return new File(parent, "twotier" + Normaliser.safeWithoutNormalising(url) + "-" + Normaliser.safeWithoutNormalising(techUsername) + ".key");
    }
}

