/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.reporting;

import com.aem.shelp.common.history.SearchConfig;
import com.aem.shelp.proxy.MachineDB;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.reporting.AccessReport;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.interfaces.MachineRegistryInterface;
import com.aem.shelp.tech.history.reports.SessionReport;
import com.aem.shelp.tech.history.reports.TechnicianActivityReport;
import com.aem.shelp.tech.reporting.ReportRequest;
import com.aem.shelp.tech.reporting.ReportResult;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.zip.GZIPOutputStream;
import utils.files.FileUtil;
import utils.stream.LimitedBandwidthOutputStream;

public class ReportGenerator {
    private static File REPORTS_DIRECTORY = new File("configuration", "reports");
    private static final ReportGenerationThread GENERATION_THREAD = new ReportGenerationThread();
    private static final Object LOCK = new Object();

    public static ReportResult createReport(ReportRequest request) throws Throwable {
        return GENERATION_THREAD.addRequest(request);
    }

    private static ReportResult createReportNow(ReportRequest request) throws IOException {
        if (request.reportType == 0 || request.reportType == 1) {
            return ReportGenerator.createAccessReport(request);
        }
        if (request.reportType == 2 || request.reportType == 3) {
            return ReportGenerator.createHistoryReport(request);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReportResult createHistoryReport(ReportRequest request) throws IOException {
        File reportFile;
        BufferedOutputStream bout;
        ByteArrayOutputStream byteArrayResult;
        block13: {
            byteArrayResult = new ByteArrayOutputStream();
            bout = new BufferedOutputStream(new GZIPOutputStream(new LimitedBandwidthOutputStream(byteArrayResult)));
            SearchConfig sconfig = request.historySearchConfig;
            if (sconfig == null) {
                throw new IOException("History report has null SearchConfig");
            }
            try {
                if (request.reportType == 2) {
                    if (request.reportFormat != 0) {
                        throw new UnsupportedReportException();
                    }
                    SessionReport.generate(bout, request.transient_historySource);
                    break block13;
                }
                if (request.reportType == 3) {
                    TechnicianActivityReport report = new TechnicianActivityReport();
                    report.generate(request.reportFormat == 2, bout, request.transient_historySource);
                    break block13;
                }
                throw new UnsupportedReportException();
            }
            finally {
                FileUtil.robustClose(bout);
            }
        }
        long time = System.currentTimeMillis();
        Object object = LOCK;
        synchronized (object) {
            reportFile = ReportGenerator.createReportFile(request.serverSideRequestingUser, time);
            bout = new BufferedOutputStream(new FileOutputStream(reportFile));
        }
        try {
            ReportResult result = new ReportResult(request, byteArrayResult.toByteArray(), reportFile, time);
            result.saveTo(reportFile);
            ReportResult reportResult = result;
            return reportResult;
        }
        finally {
            FileUtil.robustClose(bout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReportResult createAccessReport(ReportRequest request) throws IOException {
        File reportFile;
        ByteArrayOutputStream byteArrayResult = new ByteArrayOutputStream();
        AccessReport report = null;
        BufferedOutputStream bout = new BufferedOutputStream(new GZIPOutputStream(new LimitedBandwidthOutputStream(byteArrayResult)));
        try {
            if (request.reportFormat != 0) {
                throw new UnsupportedReportException();
            }
            report = AccessReport.createAccessReport(request);
            report.initAccessReport(bout);
            MachineDB machineInfoRegistry = ProxyServer.INSTANCE.getMachineDB();
            MachineRegistryInterface machineRegistry = ProxyServer.INSTANCE.getMachineRegistry();
            if (request.machineIDs != null) {
                for (String machineID : request.machineIDs) {
                    Machine m = machineRegistry.getMachineByID(machineID);
                    MachineInfo machineInfo = machineInfoRegistry.getInfoFor(machineID);
                    if (!request.userCanViewMachine(m)) continue;
                    report.addMachine(m, machineInfo);
                }
            } else {
                String[] allMachines;
                for (String machineID : allMachines = machineInfoRegistry.getAllMachineIDs()) {
                    Machine m = machineRegistry.getMachineByID(machineID);
                    if (!request.includeMachine(m) || !request.userCanViewMachine(m)) continue;
                    report.addMachine(m, machineInfoRegistry.getInfoFor(machineID));
                }
            }
        }
        finally {
            if (report != null) {
                report.finishAccessReport();
            }
            FileUtil.robustClose(bout);
        }
        long time = System.currentTimeMillis();
        Object object = LOCK;
        synchronized (object) {
            reportFile = ReportGenerator.createReportFile(request.serverSideRequestingUser, time);
            bout = new BufferedOutputStream(new FileOutputStream(reportFile));
        }
        try {
            ReportResult result = new ReportResult(request, byteArrayResult.toByteArray(), reportFile, time);
            result.saveTo(reportFile);
            ReportResult reportResult = result;
            return reportResult;
        }
        finally {
            FileUtil.robustClose(bout);
        }
    }

    private static File getFolderFor(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        int y = c.get(1);
        int m = c.get(2);
        File folder = new File(new File(REPORTS_DIRECTORY, Integer.toString(y)), Integer.toString(m));
        folder.mkdirs();
        return folder;
    }

    public static File getReportFile(int techUserID, String reportFilename, long time) {
        return new File(new File(ReportGenerator.getFolderFor(time), Integer.toString(techUserID)), reportFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createReportFile(TechUser user, long time) {
        File folder = ReportGenerator.getFolderFor(time);
        String suffix = "report";
        Object object = LOCK;
        synchronized (object) {
            File techFolder = new File(folder, Integer.toString(user.getUserID()));
            techFolder.mkdirs();
            File reportFile = new File(techFolder, "" + System.currentTimeMillis() + "." + suffix);
            while (reportFile.exists()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                reportFile = new File(techFolder, "" + System.currentTimeMillis() + "." + suffix);
            }
            return reportFile;
        }
    }

    private static class ReportGenerationThread
    extends Thread {
        private final LinkedList<ReportRequestWrapper> requests = new LinkedList();

        public ReportGenerationThread() {
            super("ReportGenerator");
            this.setPriority(1);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReportResult addRequest(ReportRequest request) throws Throwable {
            ReportRequestWrapper wrapper = new ReportRequestWrapper();
            Object object = this.requests;
            synchronized (object) {
                wrapper.request = request;
                this.requests.add(wrapper);
                this.requests.notify();
            }
            object = wrapper;
            synchronized (object) {
                while (wrapper.error == null && wrapper.result == null) {
                    try {
                        wrapper.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (wrapper.error != null) {
                throw wrapper.error;
            }
            return wrapper.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ReportRequestWrapper requestJob = null;
                LinkedList<ReportRequestWrapper> linkedList = this.requests;
                synchronized (linkedList) {
                    while (this.requests.size() == 0) {
                        try {
                            this.requests.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    requestJob = this.requests.removeFirst();
                }
                if (requestJob == null) continue;
                try {
                    System.out.println("[ReportGenerator] New report request received. Processing now.");
                    long time = System.currentTimeMillis();
                    ReportResult result = ReportGenerator.createReportNow(requestJob.request);
                    ReportRequestWrapper reportRequestWrapper = requestJob;
                    synchronized (reportRequestWrapper) {
                        requestJob.result = result;
                        requestJob.notify();
                    }
                    time = System.currentTimeMillis() - time;
                    System.out.println("[ReportGenerator] Report generation complete (took " + time + "ms)");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ReportRequestWrapper reportRequestWrapper = requestJob;
                    synchronized (reportRequestWrapper) {
                        requestJob.error = t;
                        requestJob.notify();
                    }
                }
            }
        }
    }

    private static class ReportRequestWrapper {
        ReportRequest request;
        Throwable error = null;
        ReportResult result = null;

        private ReportRequestWrapper() {
        }
    }

    public static class UnsupportedReportException
    extends RuntimeException {
    }
}

