/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.queued;

import com.aem.shelp.proxy.queued.MigrateQueuedAction;
import com.aem.shelp.proxy.queued.QueuedAction;
import com.aem.shelp.proxy.queued.RunToolQueuedAction;
import com.aem.shelp.proxy.queued.StopQueuedAction;
import com.aem.shelp.proxy.types.Machine;
import java.util.ArrayList;
import utils.message.Message;

public class QueuedActionList {
    private final Machine machine;
    private ArrayList<QueuedAction> queuedMachineActions = null;
    private final Object LOCK = new Object();

    public QueuedActionList(Machine machine) {
        this.machine = machine;
    }

    public void setMigrateAction(boolean enable, String add, String remove, String publicKeyAuthHash) {
        if (enable) {
            this.addAction(new MigrateQueuedAction(add, remove, publicKeyAuthHash));
        } else {
            this.removeActionsOfType(2);
        }
        this.updateMachineBitStore();
    }

    public void setStopAction(boolean stop) {
        if (stop) {
            this.addAction(new StopQueuedAction());
        } else {
            this.removeActionsOfType(0);
        }
        this.updateMachineBitStore();
    }

    public void setRunAction(boolean enable, Message item) {
        if (enable) {
            this.addAction(new RunToolQueuedAction(item));
        } else {
            this.removeActionsOfType(1);
        }
        this.updateMachineBitStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMachineBitStore() {
        boolean hasMigrate = false;
        boolean hasRun = false;
        boolean hasStop = false;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.queuedMachineActions != null) {
                for (QueuedAction action : this.queuedMachineActions) {
                    if (action.getType() == 2) {
                        hasMigrate = true;
                        continue;
                    }
                    if (action.getType() == 0) {
                        hasStop = true;
                        continue;
                    }
                    if (action.getType() != 1) continue;
                    hasRun = true;
                }
            }
            this.machine.setQueuedActionsState(hasMigrate, hasRun, hasStop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAction(QueuedAction action) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.queuedMachineActions == null) {
                this.queuedMachineActions = new ArrayList();
            }
            for (int i = this.queuedMachineActions.size() - 1; i >= 0; --i) {
                if (this.queuedMachineActions.get(i).getType() != action.getType()) continue;
                this.queuedMachineActions.remove(i);
            }
            this.queuedMachineActions.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActionsOfType(int type) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.queuedMachineActions == null) {
                return;
            }
            for (int i = this.queuedMachineActions.size() - 1; i >= 0; --i) {
                if (this.queuedMachineActions.get(i).getType() != type) continue;
                this.queuedMachineActions.remove(i);
            }
        }
    }

    public ArrayList<QueuedAction> removeActions() {
        ArrayList<QueuedAction> returnList = this.queuedMachineActions;
        this.queuedMachineActions = null;
        this.machine.clearAllQueuedActions(true);
        return returnList;
    }
}

