/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.support;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.types.Customer;
import java.io.File;
import java.util.Properties;
import utils.xml.XML14Util;

public class TechJoinSupportSessionEvent
extends SimpleHelpLogEvent {
    public static final String ID = "TechJoinSupportSessionEvent";
    public Customer customerInfo;
    public TechUser techUser;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_TECH_JOIN_SUPPORT");
    }

    @Override
    public String getDescription() {
        return "A technician enters into a remote support session with a customer.";
    }

    @Override
    public String getLogText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[" + this.getEventID() + "] Technician started a remote support session with a customer:\n");
        buffer.append("\tTechnician:\n");
        buffer.append(this.techUser.getLogString(2));
        buffer.append("\tCustomer:\n");
        buffer.append(this.customerInfo.toLogString(2));
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/support/technician_join");
    }

    public static TechJoinSupportSessionEvent createEvent(TechUser techUser, Customer customerInfo) {
        TechJoinSupportSessionEvent event = new TechJoinSupportSessionEvent();
        event.customerInfo = customerInfo;
        event.techUser = techUser;
        return event;
    }

    @Override
    public String getEventID() {
        return "TechnicianJoinSupportSession";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.customerInfo != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "customerInfo", this.customerInfo.toString(true));
        }
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "customerInfo", this.customerInfo.toString(true));
        this.safePut(properties, "techUser", this.techUser.toString());
    }
}

