/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.support;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.types.Customer;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class CustJoinQueue
extends SimpleHelpLogEvent {
    public static final String ID = "CustJoinQueue";
    public Customer customerInfo;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_CUST_JOINS_QUEUE");
    }

    @Override
    public String getDescription() {
        return "A customer has joined a technician's waiting queue.";
    }

    @Override
    public String getLogText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + this.getEventID() + "] Customer entered the queue:\n");
        buffer.append("\tCustomer:\n");
        buffer.append(this.customerInfo.toLogString(2));
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/support/customer_login");
    }

    public static CustJoinQueue createEvent(Customer customerInfo) {
        CustJoinQueue event = new CustJoinQueue();
        event.customerInfo = customerInfo;
        return event;
    }

    @Override
    public String getEventID() {
        return "CustomerJoinQueue";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.customerInfo != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "customerInfo", this.customerInfo.toString(true));
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "customerInfo", this.customerInfo.toString(true));
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
    }
}

