/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.sessions;

import com.aem.sdesktop.SessionPerformance;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.SupportSession;
import java.io.File;
import java.util.Properties;
import utils.xml.XML14Util;

public class SessionPerformanceEvent
extends SimpleHelpLogEvent {
    public static final String ID = "SessionPerformanceEvent";
    private AbstractSession session;
    private SessionPerformance performance;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_SESSION_PERFORMANCE");
    }

    @Override
    public String getDescription() {
        return "A new set of session performance metrics are reported.";
    }

    @Override
    public String getLogText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[").append(this.getEventID()).append("] New session performance metrics reported:\n");
        if (this.session != null) {
            buffer.append("\tSession:\n");
            buffer.append("\t\t").append(this.session.toString()).append("\n");
        }
        buffer.append("\tMetrics:\n");
        buffer.append("\t\t").append(this.performance.toString());
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return null;
    }

    public static SessionPerformanceEvent createEvent(AbstractSession session, SessionPerformance performance) {
        SessionPerformanceEvent event = new SessionPerformanceEvent();
        event.session = session;
        event.performance = performance;
        return event;
    }

    @Override
    public String getEventID() {
        return "SessionPerformance";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.session != null) {
            this.session.toXML(buffer, indent + 1);
        }
        if (this.performance != null) {
            this.performance.toXML(buffer, indent + 1);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        if (this.session != null) {
            this.session.toProperties(properties);
        }
        this.performance.toProperties(properties);
    }

    public static void main(String[] args) throws IllegalAccessException {
        SupportSession s = SupportSession.createTestSession();
        SessionPerformance p = SessionPerformance.createTestPerformance();
        SessionPerformanceEvent e = SessionPerformanceEvent.createEvent(s, p);
        System.out.println(e.getLogText());
        System.out.println(e.toXML());
        System.out.println(e.toProperties());
    }
}

