/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.server;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class TechLoginEvent
extends SimpleHelpLogEvent {
    public static final String ID = "TechLoginEvent";
    public TechUser techUser;
    public String ipAddress;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_TECH_LOGIN");
    }

    @Override
    public String getDescription() {
        return "An event generated when a technician logs into SimpleHelp";
    }

    @Override
    public String getLogText() {
        return "[" + this.getEventID() + "] Technician logged in: " + this.techUser.getLogString(0) + " from " + this.ipAddress;
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/technician/login");
    }

    public static TechLoginEvent createEvent(TechUser user, String ipAddress) {
        TechLoginEvent event = new TechLoginEvent();
        event.techUser = user;
        event.ipAddress = ipAddress;
        return event;
    }

    @Override
    public String getEventID() {
        return "TechnicianLogin";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        if (this.ipAddress != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "ipAddress", this.ipAddress);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "techUser", this.techUser.toString());
        this.safePut(properties, "ipAddress", this.ipAddress);
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("ipAddress", null, this.ipAddress));
    }
}

