/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.access;

import com.aem.sdesktop.SessionDescription;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import java.io.File;
import java.util.Properties;
import utils.xml.XML14Util;

public class AccessSessionSummaryEvent
extends SimpleHelpLogEvent {
    public static final String ID = "AccessSessionSummaryEvent";
    public TechUser techUser;
    public SessionDescription.AccessSessionDescription sessionDescription;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_ACCESS_SESSION_ENDS_NAME");
    }

    @Override
    public String getDescription() {
        return "A remote access sessions has ended between a technician an a remote machine.";
    }

    @Override
    public String getLogText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[" + this.getEventID() + "] Remote access session ended:\n");
        buffer.append("\tTechnician:\n");
        buffer.append(this.techUser.getLogString(2));
        buffer.append("\tRemote Machine:\n");
        buffer.append("\t\t" + this.sessionDescription.getRemoteMachineName()).append("\n");
        buffer.append("\tDuration:\n");
        buffer.append("\t\t" + this.sessionDescription.sessionDuration + " (" + this.sessionDescription.sessionDurationMS + "ms)").append("\n");
        buffer.append("\tTechnician Comments:\n");
        buffer.append("\t\t" + this.sessionDescription.technicianSummary).append("\n");
        buffer.append("\tChat Transcript:\n");
        buffer.append("\t\t" + this.sessionDescription.chatTranscript).append("\n");
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/access/session_summary");
    }

    public static AccessSessionSummaryEvent createEvent(TechUser techUser, SessionDescription.AccessSessionDescription sessionDescription) {
        AccessSessionSummaryEvent event = new AccessSessionSummaryEvent();
        event.techUser = techUser;
        event.sessionDescription = sessionDescription;
        return event;
    }

    @Override
    public String getEventID() {
        return "AccessSessionSummary";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        if (this.sessionDescription != null) {
            this.sessionDescription.appendToXML(buffer, indent + 1);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "techUser", this.techUser.toString());
        this.sessionDescription.toProperties("sessionDescription", properties);
    }
}

