/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.history;

import com.aem.shelp.proxy.SessionHistoryRepository;
import com.aem.shelp.proxy.history.MonthFolderIterator;
import com.aem.shelp.proxy.types.AbstractSession;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import utils.dataservice.local.datalist.ByteArrayList;
import utils.message.MessageUtils;

public class SessionHistoryArchiver
extends Thread {
    private final SessionHistoryRepository respository;
    public boolean die = false;
    public boolean debug_runOnce = false;

    public SessionHistoryArchiver(SessionHistoryRepository respository) {
        super("SessionHistoryArchiver");
        this.respository = respository;
    }

    public void runOnce() {
        try {
            this.migrateIfRequired();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (!this.die) {
            long nextTime = SessionHistoryArchiver.getStartOfNextMonth();
            while (System.currentTimeMillis() < nextTime) {
                try {
                    Thread.sleep(Math.max(100L, nextTime - System.currentTimeMillis()));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("[SessionHistoryArchiver] Archiving old session history items");
            this.runOnce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateIfRequired() {
        MonthFolderIterator folderIterator = new MonthFolderIterator(this.respository.getOldestSessionDate(), SessionHistoryArchiver.getEndOfTwoMonthsAgo());
        while (folderIterator.hasNext()) {
            Object[] sessionFiles;
            File month = folderIterator.next();
            System.out.println("[SessionHistoryArchiver] Analysing " + month);
            File dataListFile = new File(month, "history.list");
            if (dataListFile.exists() || (sessionFiles = month.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".shh");
                }
            })) == null) continue;
            System.out.println("[SessionHistoryArchiver] \t Found " + sessionFiles.length + " sessions");
            Arrays.sort(sessionFiles);
            ArrayList<Object> migratedFiles = new ArrayList<Object>();
            File temporaryList = new File(month, "history.list.tmp");
            boolean success = false;
            boolean allMigrated = true;
            try {
                ByteArrayList dataList = new ByteArrayList(temporaryList);
                try {
                    System.out.println("[SessionHistoryArchiver] \t Created list for sessions");
                    for (Object sessionFile : sessionFiles) {
                        try {
                            AbstractSession loadedSession = this.respository.loadSession((File)sessionFile);
                            if (loadedSession == null) continue;
                            dataList.addBytes(loadedSession.getStartTime(), MessageUtils.messageToBytes(loadedSession.toMessage()));
                            migratedFiles.add(sessionFile);
                        }
                        catch (Throwable t) {
                            allMigrated = false;
                            System.out.println("[SessionHistoryArchiver] ERROR: Unable to add session to summary list.");
                            t.printStackTrace();
                        }
                    }
                }
                finally {
                    dataList.close();
                    success = true;
                }
            }
            catch (Throwable t) {
                System.out.println("[SessionHistoryArchiver] ERROR: Unable to create byte array list to migrate to, or unable to close the list.");
                t.printStackTrace();
            }
            if (!success) continue;
            int attempts = 0;
            System.out.println("[SessionHistoryArchiver] \t Renaming data list");
            success = temporaryList.renameTo(dataListFile);
            while (!success) {
                if (++attempts > 10) {
                    System.out.println("[SessionHistoryArchiver] ERROR: Unable to rename byte array list (" + temporaryList.exists() + "," + dataListFile.exists() + ")");
                    success = false;
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                success = temporaryList.renameTo(dataListFile);
            }
            if (!success) continue;
            System.out.println("[SessionHistoryArchiver] \t Cleaning up migrated files");
            for (File file : migratedFiles) {
                try {
                    file.delete();
                }
                catch (Throwable t) {
                    System.out.println("[SessionHistoryArchiver] ERROR: Tried to delete " + file.getName() + " but it failed.");
                    t.printStackTrace();
                }
            }
        }
    }

    private static long getStartOfNextMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        calendar.add(2, 1);
        return calendar.getTimeInMillis();
    }

    private static long getEndOfTwoMonthsAgo() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        calendar.add(2, -1);
        calendar.add(5, -1);
        return calendar.getTimeInMillis();
    }
}

