/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.config;

import com.aem.ServerManagement;
import com.aem.profiles.ClientSafeProfileResolver;
import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.proxy.LoginType;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.utils.authentication.AuthenticationRequest;
import com.aem.utils.authentication.LDAPAuthenticator;
import com.aem.utils.authentication.LDAPProperties;
import com.aem.utils.authentication.RadiusAuthenticationRequest;
import com.aem.utils.authentication.ServerAuthenticationHandler;
import java.util.ArrayList;
import utils.radius.ChallengeHandler;

public class TechGroup
implements Comparable {
    private int uniqueID;
    private String name;
    private CustomerFilter[] customerFilters;
    private MachineFilter[] machineFilters;
    private ArrayList<ArrayList<String>> allowedMachineGroups = new ArrayList();
    private boolean filterByAllowedGroups = false;
    private boolean isPassword = false;
    private LazyPassword groupPassword = new LazyPassword(null);
    private boolean isLDAP = false;
    private LDAPProperties ldapProperties;
    private boolean isMultiTierEmail;
    private int twoTierCodeLength = 8;
    private String twoTierSubject;
    private String twoTierBody;
    private boolean multiRememberMachine = false;
    private boolean allowAnonymousLogins = true;
    private String associatedAppProfileID = null;
    private int maxShGroupConcurrency = -1;
    private int maxShUserConcurrency = -1;
    private int maxSgGroupConcurrency = -1;
    private int maxSgUserConcurrency = -1;
    private long maxFileSize = -1L;
    private TechGroupPermissions permissions;
    private long requestTimeout = 0L;
    private String groupSpecificHostname = null;
    private String defaultSGServiceName;
    private String defaultVideoPassword;
    private boolean isRadius;
    private boolean isMultiTierApp;
    private String transient_appProfileName;
    private String transient_appProfileTypeName;
    private boolean sessionSpeedLimited = false;
    private int sessionSpeedLimitKbps;
    private boolean fpsLimited = false;
    private long fpsDelay;

    public TechGroup(int id, String name) {
        this.uniqueID = id;
        this.name = name;
        this.ldapProperties = new LDAPProperties();
        this.permissions = new TechGroupPermissions();
    }

    public boolean equals(Object o) {
        if (o instanceof TechGroup) {
            return ((TechGroup)o).uniqueID == this.uniqueID;
        }
        return false;
    }

    public boolean isShConcurrencyLimited() {
        return this.maxShGroupConcurrency != -1 || this.maxShUserConcurrency != -1;
    }

    public boolean isSgConcurrencyLimited() {
        return this.maxSgGroupConcurrency != -1 || this.maxSgUserConcurrency != -1;
    }

    public boolean isMaxFileTransferSizeLimited() {
        return this.maxFileSize != -1L;
    }

    public void setMaxFileTransferSize(long maxFileSize) {
        if (maxFileSize != -1L && this.maxFileSize != maxFileSize) {
            System.out.println("[TechGroup] The maximum file transfer size has been set for " + this.getName() + " to " + maxFileSize);
        }
        this.maxFileSize = maxFileSize;
    }

    public long getMaxFileTransferSize() {
        return this.maxFileSize;
    }

    public void setMaxShGroupConcurrency(int n) {
        this.maxShGroupConcurrency = n;
    }

    public void setMaxShUserConcurrency(int n) {
        this.maxShUserConcurrency = n;
    }

    public int getMaxShGroupConcurrency() {
        return this.maxShGroupConcurrency;
    }

    public int getMaxShUserConcurrency() {
        return this.maxShUserConcurrency;
    }

    public void setMaxSgGroupConcurrency(int n) {
        this.maxSgGroupConcurrency = n;
    }

    public void setMaxSgUserConcurrency(int n) {
        this.maxSgUserConcurrency = n;
    }

    public int getMaxSgGroupConcurrency() {
        return this.maxSgGroupConcurrency;
    }

    public int getMaxSgUserConcurrency() {
        return this.maxSgUserConcurrency;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public void setPassword(boolean isPassword) {
        this.isPassword = isPassword;
    }

    public LazyPassword getPassword() {
        return this.groupPassword;
    }

    public void setPassword(LazyPassword password) {
        if (password == null) {
            this.groupPassword = new LazyPassword(null);
        }
        this.groupPassword = password;
    }

    public String getAssociatedAppProfileID() {
        return this.associatedAppProfileID;
    }

    public void setAssociatedAppProfileID(String profileID) {
        this.associatedAppProfileID = profileID;
    }

    public boolean isLDAP() {
        return this.isLDAP;
    }

    public void setLDAP(boolean isLDAP) {
        this.isLDAP = isLDAP;
    }

    public LDAPProperties getLDAPProperties() {
        return this.ldapProperties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        if (this.getAssociatedAppProfileID() != null) {
            if (ServerManagement.isServerJVM()) {
                AppProfile profile = ClientSafeProfileResolver.resolve(this.getAssociatedAppProfileID());
                if (profile != null) {
                    if (profile.getType() != null) {
                        return profile.getType().getName() + " - " + profile.getName();
                    }
                    return Language.get("APP_PROFILE") + " - " + profile.getName();
                }
                return Language.get("APP_PROFILE");
            }
            if (this.transient_appProfileName != null) {
                return this.transient_appProfileTypeName + " - " + this.transient_appProfileName;
            }
            return Language.get("APP_PROFILE") + this.name;
        }
        return this.name;
    }

    public CustomerFilter[] getCustomerFilters() {
        return this.customerFilters;
    }

    public void setAllowAnonymousLogins(boolean anonymousLogins) {
        this.allowAnonymousLogins = anonymousLogins;
    }

    public boolean allowAnonymousLogins() {
        return this.allowAnonymousLogins;
    }

    public boolean authenticate(TechCredentials credentials, LoginType type, ChallengeHandler handler) {
        return this.authenticate(credentials, type, null, handler);
    }

    public boolean authenticate(TechCredentials credentials, LoginType type, TechUser techUser, ChallengeHandler challengeHandler) {
        ServerConfig config;
        if (this.isLDAP) {
            config = ServerConfig.get();
            System.out.println("[Authentication] Checking LDAP authentication against group " + this.getName());
            try {
                LDAPAuthenticator ldap = new LDAPAuthenticator(config.ldapHostname, config.ldapPort, config.ldapAuthentication, config.ldapEnableSSL, config.ldapUsername, config.ldapPassword.getDecryptedPassword(), config.getLDAPGroupClass(), config.getLDAPLogin(), config.getLDAPMemberAttribute(), config.ldapFollowLinks);
                LDAPAuthenticator.LDAPUser ldapUser = ldap.authenticate(credentials.getUsername(), credentials.getPassword(), this.ldapProperties);
                if (ldapUser != null) {
                    type.loginType = 3;
                    if (techUser != null && techUser.isAnonymous()) {
                        if (ldapUser.displayName != null) {
                            techUser.displayName = ldapUser.displayName;
                        }
                        if (ldapUser.emailAddress != null) {
                            techUser.emailAddress = ldapUser.emailAddress;
                        }
                        if (ldapUser.avatar != null) {
                            techUser.avatarImageBytes = ldapUser.avatar;
                        }
                    }
                    return true;
                }
            }
            catch (Exception e) {
                System.out.println("[Authentication] Group LDAP Authentication failed.");
                e.printStackTrace();
            }
        }
        if (this.isPassword) {
            System.out.println("[Authentication] Checking password authentication against group " + this.getName());
            if (this.groupPassword != null && this.groupPassword.getDecryptedPassword() != null && this.groupPassword.getDecryptedPassword().equals(credentials.getPassword())) {
                type.loginType = 2;
                return true;
            }
        }
        if (this.isRadius) {
            System.out.println("[Authentication] Checking RADIUS authentication against group " + this.getName());
            config = ServerConfig.get();
            try {
                Object LOCK = new Object();
                AuthenticationRequest[] authenticationRequests = new RadiusAuthenticationRequest[config.radiusConfigs.length];
                for (int i = 0; i < config.radiusConfigs.length; ++i) {
                    ServerConfig.RadiusConfig rd = config.radiusConfigs[i];
                    authenticationRequests[i] = new RadiusAuthenticationRequest(LOCK, config.radiusAttempts, config.radiusTimeout);
                    ((RadiusAuthenticationRequest)authenticationRequests[i]).authenticationProtocol = rd.radiusAuthProtocol;
                    ((RadiusAuthenticationRequest)authenticationRequests[i]).port = rd.radiusPort;
                    ((RadiusAuthenticationRequest)authenticationRequests[i]).secret = rd.radiusSecret;
                    ((RadiusAuthenticationRequest)authenticationRequests[i]).hostname = rd.radiusHostname;
                    ((RadiusAuthenticationRequest)authenticationRequests[i]).username = credentials.getUsername();
                    ((RadiusAuthenticationRequest)authenticationRequests[i]).password = credentials.getPassword();
                    ((RadiusAuthenticationRequest)authenticationRequests[i]).challengeHandler = challengeHandler;
                }
                ServerAuthenticationHandler serverAuthenticationHandler = new ServerAuthenticationHandler(ServerConfig.get().radiusStrategy, ServerConfig.get().radiusStaggeredTimeout);
                boolean allowed = serverAuthenticationHandler.authenticateUser(authenticationRequests);
                if (allowed) {
                    type.loginType = 4;
                    return true;
                }
            }
            catch (Throwable t) {
                System.out.println("[Authentication] Unable to authenticate using RADIUS server: (" + t.getClass().getName() + ": " + t.getMessage() + ")");
                t.printStackTrace();
            }
        }
        return false;
    }

    public TechGroupPermissions getPermissions() {
        return this.permissions;
    }

    public String getHostname() {
        return this.groupSpecificHostname;
    }

    public void setHostname(String groupSpecificHostname) {
        this.groupSpecificHostname = groupSpecificHostname;
    }

    public void setRadius(boolean useRadius) {
        this.isRadius = useRadius;
    }

    public boolean isRadius() {
        return this.isRadius;
    }

    public boolean isMultiTierApp() {
        return this.isMultiTierApp;
    }

    public void setMultiTierApp(boolean requireTOTP) {
        this.isMultiTierApp = requireTOTP;
    }

    public boolean isMultiTierEmail() {
        return this.isMultiTierEmail;
    }

    public void setMultiTierEmail(boolean isTwoTier) {
        this.isMultiTierEmail = isTwoTier;
    }

    public void setTwoTierCodeLength(int twoTierCodeLength) {
        this.twoTierCodeLength = twoTierCodeLength;
    }

    public void setMultiTierRememberMachine(boolean multiRememberMachine) {
        this.multiRememberMachine = multiRememberMachine;
    }

    public void setTwoTierEmail(String subject, String email) {
        this.twoTierSubject = subject;
        this.twoTierBody = email;
    }

    public String getTwoTierSubject() {
        return this.twoTierSubject;
    }

    public String getTwoTierBody() {
        return this.twoTierBody;
    }

    public int getTwoTierCodeLength() {
        return this.twoTierCodeLength;
    }

    public int compareTo(Object arg0) {
        return this.toString().compareTo(arg0.toString());
    }

    public void setDefaultSGServiceName(String defaultSGServiceName) {
        this.defaultSGServiceName = defaultSGServiceName;
    }

    public String getDefaultSGServiceName() {
        return this.defaultSGServiceName;
    }

    public void setCustomerFilters(CustomerFilter[] customerFilters) {
        this.customerFilters = customerFilters;
    }

    public MachineFilter[] getMachineFilters() {
        return this.machineFilters;
    }

    public void setMachineFilters(MachineFilter[] machineFilters) {
        this.machineFilters = machineFilters;
    }

    public void setRemoteAccessGroupRestrictions(ArrayList<ArrayList<String>> allowed) {
        this.allowedMachineGroups = allowed;
    }

    public ArrayList<ArrayList<String>> getRemoteAccessGroupRestrictions() {
        return this.allowedMachineGroups;
    }

    public void setFilterByAllowedGroups(boolean b) {
        this.filterByAllowedGroups = b;
    }

    public boolean getFilterByAllowedGroups() {
        return this.filterByAllowedGroups;
    }

    public void setDefaultVideoPassword(String videoPassword) {
        this.defaultVideoPassword = videoPassword;
    }

    public String getDefaultVideoPassword() {
        return this.defaultVideoPassword;
    }

    public void setRequestAccessTimeout(long timeout) {
        this.requestTimeout = timeout;
    }

    public long getRequestAccessTimeout() {
        return this.requestTimeout;
    }

    public int getGroupID() {
        return this.uniqueID;
    }

    public boolean isValidTwoTierConfiguration() {
        return this.twoTierCodeLength > 0 && this.twoTierBody != null && this.twoTierBody.length() > 0;
    }

    public boolean getMultiTierRememberMachine() {
        return this.multiRememberMachine;
    }

    public boolean isSessionLimited() {
        return this.sessionSpeedLimited;
    }

    public void setSessionLimited(boolean limited) {
        this.sessionSpeedLimited = limited;
    }

    public boolean isFPSLimited() {
        return this.fpsLimited;
    }

    public void setFPSLimited(boolean limited) {
        this.fpsLimited = limited;
    }

    public long getFPSDelay() {
        return this.fpsDelay;
    }

    public void setFPSDelay(long fpsDelay) {
        this.fpsDelay = fpsDelay;
    }

    public int getSessionLimitKbps() {
        return this.sessionSpeedLimitKbps;
    }

    public void setSessionLimitKbps(int sessionSpeedLimitKbps) {
        this.sessionSpeedLimitKbps = sessionSpeedLimitKbps;
    }

    public void setGroupID(int groupID) {
        this.uniqueID = groupID;
    }

    public void setTransientAppProfileName(String transient_appProfileName) {
        this.transient_appProfileName = transient_appProfileName;
    }

    public void setTransientAppProfileTypeName(String transient_appProfileTypeName) {
        this.transient_appProfileTypeName = transient_appProfileTypeName;
    }

    public void setLdapProperties(LDAPProperties ldapProperties) {
        this.ldapProperties = ldapProperties;
    }
}

