/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.authentication;

public class TOTPConfig {
    public static final int DEFAULT_CODE_DIGITS = 6;
    public static final int DEFAULT_WINDOW_SIZE = 10;
    private int codeDigits = 6;
    private int windowSize = 10;
    private int scratchCodeLengthBytes = 4;
    private int scratchCodeCount = 5;
    private int secretBits = 80;

    public TOTPConfig(int codeLength, int windowSize) {
        this.codeDigits = codeLength;
        this.windowSize = windowSize;
    }

    public int getKeyModulus() {
        return (int)Math.pow(10.0, this.codeDigits);
    }

    public int getBytesPerScratchCode() {
        return this.scratchCodeLengthBytes;
    }

    public int getScratchCodeModulus() {
        return (int)Math.pow(10.0, this.scratchCodeLengthBytes * 2);
    }

    public int getScratchCodeCount() {
        return this.scratchCodeCount;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getSecretSizeBits() {
        return this.secretBits;
    }

    public int getSecretSizeBytes() {
        return this.secretBits / 8;
    }

    public int getCodeDigitLength() {
        return this.codeDigits;
    }
}

