/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.alerts;

import com.aem.CentralDebugging;
import com.aem.shelp.proxy.alerts.AlertNotifyState;
import com.aem.shelp.proxy.types.AlertAllocationListener;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.ResourceContainer;
import java.util.ArrayList;
import utils.switches.Switches;

public class AlertStateManager {
    public static void verifyAllStateExpensive(AlertAllocationListener listener) {
        Machine[] machines;
        for (Machine machine : machines = listener.getMachineRegistry().getMachineNamesAdvanced()) {
            AlertStateManager.verifyState(listener, machine);
        }
        ArrayList<ResourceContainer> alerts = listener.getAlertRegistry().getAll();
        for (ResourceContainer res : alerts) {
            if (!(res instanceof LocatedAlert)) continue;
            AlertStateManager.verifyState(listener, (LocatedAlert)res, true);
        }
    }

    private static void alertStateChanged(AlertAllocationListener listener, LocatedAlert alert) {
        listener.pushUpdatedAlertState(alert);
    }

    private static void machineAlertStateChanged(AlertAllocationListener listener, Machine machine) {
        if (Switches.SH_alertTriggerSavesMachineDB) {
            listener.notifyMachineAlertStateChanged(machine.getMachineInfo());
        }
        listener.pushUpdatedMachineAlertState(machine.getID());
    }

    public static void verifyState(AlertAllocationListener listener, Machine machine) {
        MachineInfo info = machine.getMachineInfo();
        ArrayList<String> alerts = info.getTriggeredAlertIDs();
        for (String alertID : alerts) {
            if (listener.getAlertRegistry().get(alertID) != null) continue;
            System.out.println("[AlertVerify] Machine " + machine.getName().getName() + " has " + alertID + " as triggered but does not exist, resetting");
            if (!info.asmAlertReset(alertID)) continue;
            AlertStateManager.machineAlertStateChanged(listener, machine);
        }
    }

    public static void verifyState(AlertAllocationListener listener, LocatedAlert alert, boolean expensive) {
        if (!alert.isActive()) {
            Machine[] machines = alert.getTriggeredMachines();
            if (machines.size() > 0) {
                for (String string : machines) {
                    System.out.println("[AlertVerify] Alert " + alert.getName() + " is inactive but has " + string + " listed as triggered, resetting");
                    alert.forceRemoveTriggeredMachine(string);
                    AlertStateManager.alertStateChanged(listener, alert);
                    Machine machine = listener.getMachineRegistry().getMachineByID(string);
                    if (!machine.getMachineInfo().asmAlertReset(alert.getID())) continue;
                    AlertStateManager.machineAlertStateChanged(listener, machine);
                }
            }
            if (expensive) {
                for (Machine machine : machines = listener.getMachineRegistry().getMachineNamesAdvanced()) {
                    if (!machine.getMachineInfo().asmAlertReset(alert.getID())) continue;
                    System.out.println("[AlertVerify] Alert " + alert.getName() + " is inactive but has " + machine.getName() + " lists it as triggered, resetting");
                    AlertStateManager.machineAlertStateChanged(listener, machine);
                }
            }
        }
    }

    public static AlertNotifyState setAlertTriggered(String alertID, String machineID, AlertAllocationListener listener, String reason) {
        AlertNotifyState notifyState = new AlertNotifyState();
        ResourceContainer resc = listener.getAlertRegistry().get(alertID);
        if (!(resc instanceof LocatedAlert)) {
            System.out.println("Attempted to trigger non-alert: " + resc);
            notifyState.alertStateChanged = false;
            notifyState.machineAlertedStateChanged = false;
            return notifyState;
        }
        LocatedAlert alert = (LocatedAlert)resc;
        Machine machine = listener.getMachineRegistry().getMachineByID(machineID);
        MachineInfo info = machine.getMachineInfo();
        if (CentralDebugging.PX_ALERT_EVENTS) {
            System.out.println("[AlertState] Alert " + alert.getName() + " (" + alertID + ") triggered for " + info.getMachineName().getName() + " (" + reason + ")");
        }
        if (!alert.isActive()) {
            AlertStateManager.verifyState(listener, alert, false);
        } else {
            boolean bl = notifyState.alertStateChanged = !alert.isTriggered();
            if (!alert.isMachineTriggered(machineID)) {
                notifyState.machineAlertedStateChanged = true;
                alert.asmMachineTriggered(machineID);
                AlertStateManager.alertStateChanged(listener, alert);
            }
            if (!info.isAlertTriggered(alert.getID())) {
                notifyState.machineAlertedStateChanged = true;
                info.asmAlertTriggered(alert.getID());
                AlertStateManager.machineAlertStateChanged(listener, machine);
            }
        }
        return notifyState;
    }

    public static AlertNotifyState setAlertReset(String alertID, String machineID, AlertAllocationListener listener, String reason) {
        MachineInfo info;
        AlertNotifyState notifyState = new AlertNotifyState();
        ResourceContainer resc = listener.getAlertRegistry().get(alertID);
        if (!(resc instanceof LocatedAlert)) {
            System.out.println("Attempted to reset non-alert: " + resc);
            notifyState.alertStateChanged = false;
            notifyState.machineAlertedStateChanged = false;
            return notifyState;
        }
        LocatedAlert alert = (LocatedAlert)resc;
        Machine machine = listener.getMachineRegistry().getMachineByID(machineID);
        if (machine == null) {
            info = null;
            if (CentralDebugging.PX_ALERT_EVENTS) {
                System.out.println("[AlertState] Alert " + alert.getName() + " (" + alertID + ") reset for (removed machine " + machineID + ") (" + reason + ")");
            }
        } else {
            info = machine.getMachineInfo();
            if (CentralDebugging.PX_ALERT_EVENTS) {
                System.out.println("[AlertState] Alert " + alert.getName() + " (" + alertID + ") reset for " + info.getMachineName().getName() + " (" + reason + ")");
            }
        }
        if (!alert.isActive()) {
            AlertStateManager.verifyState(listener, alert, false);
        } else {
            boolean currentlyTriggered = alert.isTriggered();
            if (alert.isMachineTriggered(machineID)) {
                notifyState.machineAlertedStateChanged = true;
                alert.asmMachineReset(machineID);
                AlertStateManager.alertStateChanged(listener, alert);
            }
            if (info != null && info.isAlertTriggered(alert.getID())) {
                notifyState.machineAlertedStateChanged = true;
                info.asmAlertReset(alert.getID());
                AlertStateManager.machineAlertStateChanged(listener, machine);
            }
            if (currentlyTriggered && !alert.isTriggered()) {
                notifyState.alertStateChanged = true;
            }
        }
        return notifyState;
    }
}

