/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.profiles.model.AppProfile;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.proxy.LicenseConfig;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.ToolBoxRegistry;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.utils.StreamUtils;
import com.aem.utils.blowfish.Blowfish;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Random;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.ostools.OS;
import utils.string.HexData;

public class WebsiteServiceUtil {
    private static String SERVER = "https://www.simple-help.com";
    private static final Random r = new Random();
    private static boolean IS_DEBUG = false;

    public static String getLatestLEAgreementFromWebsite() {
        try {
            URL versionURL = new URL(SERVER + "/lets-encrypt-agreement-url");
            HttpURLConnection versionConnection = (HttpURLConnection)versionURL.openConnection();
            versionConnection.setInstanceFollowRedirects(true);
            versionConnection.setDoInput(true);
            versionConnection.setDoOutput(false);
            versionConnection.setUseCaches(false);
            InputStream in = versionConnection.getInputStream();
            String result = StreamUtils.readAllAsStringISO88951(in).trim();
            in.close();
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static String getLatestVersionFromWebsite(boolean isBeta) throws IOException {
        AppProfile[] profiles;
        Message message = new Message();
        System.out.println("[WebsiteServiceUtil] Checking for updates...");
        message.append(Version.get());
        if (ProxyServer.INSTANCE != null) {
            message.append(ProxyServer.INSTANCE.getMachineCount());
        } else {
            message.append(0);
        }
        String licenseType = "0";
        try {
            if (LicenseConfig.get().isLicensed()) {
                licenseType = "1";
            } else if (LicenseConfig.get().isLicensedTrial()) {
                licenseType = "2";
            } else if (LicenseConfig.get().isUnlicensedTrial()) {
                licenseType = "3";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        message.append(licenseType);
        message.append(isBeta);
        if (!IS_DEBUG) {
            String hexPart = LicenseConfig.get().getSecRandomFirst128BitsAsHex();
            if (hexPart != null) {
                message.append(hexPart);
            } else {
                message.append("");
            }
        } else {
            message.append("A1302931273929874619023123AAAFFF");
        }
        message.append(ProxyServer.VM_VENDOR);
        OS.isWindows();
        message.append(OS.base_type);
        message.append(OS.variant);
        message.append(OS.linux_arch);
        message.append(new File("/opt/simplesetup.log").exists());
        ArrayList<ResourceContainer> alerts = ProxyServer.INSTANCE.getAlertRegistry().getAll();
        int n_alerts = 0;
        int n_custom = 0;
        int n_network = 0;
        for (ResourceContainer cont : alerts) {
            if (!(cont instanceof LocatedAlert)) continue;
            ++n_alerts;
            LocatedAlert la = (LocatedAlert)cont;
            ArrayList<Alert> list = la.getAlert().getAllSubAlerts();
            for (Alert alert : list) {
                String key = alert.getTypeIconKey();
                if (key == "images/svg/users/runner.svg,48") {
                    ++n_custom;
                    continue;
                }
                if (key != "images/svg/computing/network.svg,48") continue;
                ++n_network;
            }
        }
        message.append(n_alerts);
        message.append(alerts.size() - n_alerts);
        message.append(n_custom);
        message.append(n_network);
        message.append(ServerConfig.get().getAllTechGroups().length);
        message.append(ServerConfig.get().getAllTechUsersIncludingSimpleHelpAdmin().length - 1);
        int raProfiles = 0;
        int presProfiles = 0;
        int gaProfiles = 0;
        for (AppProfile profile : profiles = ProxyServer.INSTANCE.getProfiles()) {
            String typeid = profile.getType().getID();
            if (typeid.startsWith("RemoteAccessID")) {
                ++raProfiles;
                continue;
            }
            if (typeid.startsWith("PresentOnlyID")) {
                ++presProfiles;
                continue;
            }
            if (!typeid.startsWith("GroupAccessID")) continue;
            ++gaProfiles;
        }
        message.append(raProfiles);
        message.append(presProfiles);
        message.append(gaProfiles);
        int[] info = ToolBoxRegistry.INSTANCE.getToolAvgMaxTotal();
        message.append(info[0]);
        message.append(info[1]);
        message.append(info[2]);
        message.append(ProxyServer.rsSessionCount);
        message.append(ProxyServer.raSessionCount);
        message.append(ProxyServer.presentationsRegistered);
        message.append(ProxyServer.maxSessionsUsed);
        message.append(ProxyServer.maxSessionsLic);
        String key = "6173643532346C6B6A7766656E667765A34025343524A34025494A5344466771333468356C6B6A7145465724A3254B4A5E2436375744666751A3253441525367646661674C51A34A4B25245E4C4851572467444146474C414948A34C244B4825A3";
        Blowfish bf = new Blowfish();
        bf.init(HexData.hexStringToByteArray(key));
        byte[] encryptedBytes = bf.encryptSecure(MessageUtils.messageToBytes(message), false);
        String hex = HexData.byteArrayToHexString(encryptedBytes);
        String data = URLEncoder.encode("v2", "UTF-8") + "=" + URLEncoder.encode(hex, "UTF-8");
        URL versionURL = new URL(SERVER + "/latest_version");
        URLConnection versionConnection = versionURL.openConnection();
        versionConnection.setDoInput(true);
        versionConnection.setDoOutput(true);
        versionConnection.setUseCaches(false);
        OutputStreamWriter wr = new OutputStreamWriter(versionConnection.getOutputStream());
        wr.write(data);
        wr.flush();
        InputStream in = versionConnection.getInputStream();
        String result = StreamUtils.readAllAsStringISO88951(in).toLowerCase().trim();
        in.close();
        return result;
    }

    public static byte[] decrypt(String dataString) {
        utils.encryption.Blowfish bf = new utils.encryption.Blowfish();
        bf.init("asd524lkjwfenfwe\u00a3@%45$\u00a3@%IJSDFgq34h5lkjqEFW$\u00a3%KJ^$67WDfgQ\u00a3%4ARSgdfagLQ\u00a3JK%$^LHQW$gDAFGLAIH\u00a3L$KH%\u00a3");
        byte[] encryptedBytes = HexData.hexStringToByteArray(dataString);
        return bf.decryptSecure(encryptedBytes, 0, false);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Latest Version: '" + WebsiteServiceUtil.getLatestVersionFromWebsite(true) + "'");
        System.out.println(WebsiteServiceUtil.getLatestLEAgreementFromWebsite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPublicallyAccessible(int port) throws IOException {
        URL acurl = new URL(SERVER + "/ispublicaccessible?port=" + port);
        URLConnection acurlc = acurl.openConnection();
        acurlc.setUseCaches(false);
        InputStream acin = acurlc.getInputStream();
        try {
            String result = StreamUtils.readAllAsStringISO88951(acin).toLowerCase().trim();
            boolean bl = result.contains("accessed ok");
            return bl;
        }
        finally {
            FileUtil.robustClose(acin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPublicIP() throws IOException {
        URL url = new URL(SERVER + "/whatismyip");
        URLConnection urlc = url.openConnection();
        urlc.setUseCaches(false);
        InputStream in = urlc.getInputStream();
        try {
            String s = StreamUtils.readAllAsStringISO88951(in);
            if (s != null) {
                String string = s.trim();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            FileUtil.robustClose(in);
        }
    }
}

